/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer.TestDirectoryStructureUtil;
import org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer.TestTraceInfo;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.SWTBotImportWizardUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IEditorReference;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ProjectExplorerTraceActionsTest {
    private static @NonNull TestTraceInfo CUSTOM_TEXT_LOG = new TestTraceInfo("ExampleCustomTxt.log", "Custom Text : TmfGeneric", 10L, "29:52.034");
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String TRACE_NAME = CUSTOM_TEXT_LOG.getTraceName();
    private static final String RENAMED_TRACE_NAME = String.valueOf(TRACE_NAME) + 2;
    private static final String RENAMED_AS_NEW_TRACE_NAME = String.valueOf(TRACE_NAME) + 3;
    private static final String COPY_AS_NEW_TRACE_OPTION = "Copy as a new trace";
    private static final String RESOURCE_PROPERTIES_ITEM_NAME = "Resource properties";
    private static final String LINKED_ITEM_NAME = "linked";
    private static final String COPY_TRACE_DIALOG_TITLE = "Copy Trace";
    private static final String PROJECT_EXPLORER_VIEW_NAME = "Project Explorer";
    private static final String PROPERTIES_VIEW_NAME = "Properties";
    private static final String COPY_EXPERIMENT_DIALOG_TITLE = "Copy Experiment";
    private static final String DEEP_COPY_OPTION = "Deep copy this experiment (each trace will be copied as a new trace)";
    private static final String RENAMED_EXP_DEEP_COPY = "expDeepCopy";
    private static final String RENAMED_EXP_NAME = "exp";
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;
    private static final File TEST_TRACES_PATH;

    static {
        fLogger = Logger.getRootLogger();
        TEST_TRACES_PATH = new File(new Path(TmfTraceManager.getTemporaryDirPath()).append("testtraces").toOSString());
    }

    private static String getPath(String relativePath) {
        return new Path(TEST_TRACES_PATH.getAbsolutePath()).append(relativePath).toOSString();
    }

    @BeforeClass
    public static void init() throws IOException {
        TestDirectoryStructureUtil.generateTraceStructure(TEST_TRACES_PATH);
        SWTBotUtils.initialize();
        CustomTxtTraceDefinition[] txtDefinitions = CustomTxtTraceDefinition.loadAll((String)ProjectExplorerTraceActionsTest.getPath("customParsers/ExampleCustomTxtParser.xml"));
        txtDefinitions[0].save();
        fTestFile = new File(ProjectExplorerTraceActionsTest.getPath(new Path("import").append(CUSTOM_TEXT_LOG.getTracePath()).toString()));
        Assert.assertTrue((boolean)fTestFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
    }

    @AfterClass
    public static void tearDown() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    @Before
    public void openTrace() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
    }

    @After
    public void afterTest() {
        fBot.closeAllEditors();
        SWTBotUtils.clearExperimentFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    @Test
    public void test4_01ContextMenuPresence() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        ImmutableList EXPECTED_MENU_LABELS = ImmutableList.of((Object)"Open", (Object)"Open As Experiment...", (Object)"Open With", (Object)"", (Object)"Copy...", (Object)"Rename...", (Object)"Delete", (Object)"", (Object)"Delete Supplementary Files...", (Object)"", (Object)"Export Trace Package...", (Object)"", (Object[])new String[]{"Select Trace Type...", "", "Apply Time Offset...", "Clear Time Offset", "", "Refresh"});
        List menuItems = traceItem.contextMenu().menuItems();
        Assert.assertEquals((Object)EXPECTED_MENU_LABELS, (Object)menuItems);
    }

    @Test
    public void test4_02Open() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testStatisticsView();
    }

    @Test
    public void test4_03Copy() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        ProjectExplorerTraceActionsTest.createCopy(traceItem, true);
        ProjectExplorerTraceActionsTest.createCopy(traceItem, false);
        fBot.closeAllEditors();
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        copiedItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        SWTBotTreeItem copiedAsNewItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_AS_NEW_TRACE_NAME);
        copiedAsNewItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_AS_NEW_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testLinkStatus(copiedItem, true);
        ProjectExplorerTraceActionsTest.testLinkStatus(copiedAsNewItem, false);
    }

    @Test
    public void test4_04Rename() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Rename..."}).click();
        String RENAME_TRACE_DIALOG_TITLE = "Rename Trace";
        SWTBotShell shell = fBot.shell("Rename Trace").activate();
        SWTBotText text = shell.bot().textWithLabel("New Trace name:");
        text.setText(RENAMED_TRACE_NAME);
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        copiedItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
    }

    @Test
    public void test4_05Delete() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Delete"}).click();
        String DELETE_TRACE_DIALOG_TITLE = "Confirm Delete";
        SWTBotShell shell = fBot.shell("Confirm Delete").activate();
        shell.bot().button("Yes").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        fBot.waitUntil((ICondition)new TraceDeletedCondition());
    }

    @Test
    public void test4_06OpenKeyboard() throws WidgetNotFoundException {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.select();
        traceItem.pressShortcut(new KeyStroke[]{Keystrokes.CR});
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testStatisticsView();
    }

    @Test
    public void test4_07DeleteKeyboard() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.select();
        traceItem.pressShortcut(new KeyStroke[]{Keystrokes.DELETE});
        String DELETE_TRACE_DIALOG_TITLE = "Confirm Delete";
        SWTBotShell shell = fBot.shell("Confirm Delete").activate();
        shell.bot().button("Yes").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        fBot.waitUntil((ICondition)new TraceDeletedCondition());
    }

    @Test
    public void test4_08OpenDoubleClick() throws WidgetNotFoundException {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.doubleClick();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testStatisticsView();
    }

    @Test
    public void test4_09BringToTop() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.doubleClick();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        IEditorReference originalEditor = (IEditorReference)fBot.activeEditor().getReference();
        ProjectExplorerTraceActionsTest.createCopy(traceItem, true);
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        copiedItem.doubleClick();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, RENAMED_TRACE_NAME));
        SWTBotUtils.delay((long)1000L);
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        traceItem.doubleClick();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        Assert.assertTrue((originalEditor == fBot.activeEditor().getReference() ? 1 : 0) != 0);
    }

    @Test
    public void test4_10CopyExperiment() {
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        ProjectExplorerTraceActionsTest.createCopy(traceItem, false);
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        tracesFolder.contextMenu().menu(new String[]{"Open As Experiment...", "Generic Experiment"}).click();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, "Experiment"));
        SWTBotTreeItem experimentsItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)"Experiments");
        experimentsItem.expand();
        fBot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"Experiment [2]", (SWTBotTreeItem)experimentsItem));
        SWTBotTreeItem expItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)experimentsItem, (String)"Experiment");
        ProjectExplorerTraceActionsTest.createExperimentCopy(expItem, false);
        SWTBotTreeItem copiedExpItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)experimentsItem, (String)RENAMED_EXP_NAME);
        ProjectExplorerTraceActionsTest.verifyExperimentCopy(copiedExpItem, false);
        ProjectExplorerTraceActionsTest.createExperimentCopy(expItem, true);
        SWTBotTreeItem deepCopiedExpItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)experimentsItem, (String)RENAMED_EXP_DEEP_COPY);
        ProjectExplorerTraceActionsTest.verifyExperimentCopy(deepCopiedExpItem, true);
        Assert.assertEquals((long)3L, (long)experimentsItem.getItems().length);
    }

    @Test
    public void test4_11DeleteTraceFromExperiment() {
        fBot.closeAllEditors();
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Open As Experiment...", "Generic Experiment"}).click();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        SWTBotTreeItem experimentsItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)"Experiments");
        experimentsItem.expand();
        fBot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"ExampleCustomTxt.log [1]", (SWTBotTreeItem)experimentsItem));
        SWTBotTreeItem expItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)experimentsItem, (String)"ExampleCustomTxt.log [1]");
        expItem.expand();
        SWTBotTreeItem expTrace = expItem.getNode(TRACE_NAME);
        expTrace.contextMenu("Delete").click();
        SWTBotShell shell = fBot.shell("Confirm Delete").activate();
        shell.bot().button("Yes").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        SWTBotUtils.waitUntil(exp -> exp.getItems().length == 0, (Object)experimentsItem, (String)"Failed to delete the trace from the experiment");
        fBot.waitUntil((ICondition)new TraceDeletedCondition());
    }

    @Test
    public void test4_12RemoveTraceFromExperiment() {
        fBot.closeAllEditors();
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Open As Experiment...", "Generic Experiment"}).click();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        SWTBotTreeItem experimentsItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)"Experiments");
        experimentsItem.expand();
        fBot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"ExampleCustomTxt.log [1]", (SWTBotTreeItem)experimentsItem));
        SWTBotTreeItem expItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)experimentsItem, (String)"ExampleCustomTxt.log [1]");
        expItem.expand();
        SWTBotTreeItem expTrace = expItem.getNode(TRACE_NAME);
        expTrace.contextMenu().menu(new String[]{"Remove"}).click();
        SWTBotShell shell = fBot.shell("Confirm Remove").activate();
        shell.bot().button("Yes").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)experimentsItem, (String)"ExampleCustomTxt.log [0]");
        SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
    }

    @Test
    public void testExperimentLinkBackwardCompatibility() {
        fBot.closeAllEditors();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(TRACE_PROJECT_NAME);
        Assert.assertTrue((boolean)project.exists());
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project);
        TmfExperimentFolder experimentsFolder = projectElement.getExperimentsFolder();
        Assert.assertNotNull((String)"Experiment folder should exist", (Object)experimentsFolder);
        IFolder experimentsFolderResource = experimentsFolder.getResource();
        String experimentName = RENAMED_EXP_NAME;
        IFolder expFolder = experimentsFolderResource.getFolder(experimentName);
        Assert.assertFalse((boolean)expFolder.exists());
        try {
            expFolder.create(true, true, null);
            IFile file = expFolder.getFile(TRACE_NAME);
            file.createLink(Path.fromOSString((String)fTestFile.getAbsolutePath()), 256, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Assert.fail((String)"Failed to create the experiment");
        }
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        SWTBotTreeItem experimentsItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)"Experiments");
        SWTBotTreeItem expItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)experimentsItem, (String)RENAMED_EXP_NAME);
        expItem.expand();
        expItem.getNode(TRACE_NAME);
        expItem.contextMenu().menu(new String[]{"Open"}).click();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, experimentName));
    }

    @Test
    public void testCopySymbolicLinks() throws CoreException, TmfTraceImportException {
        ProjectExplorerTraceActionsTest.importTraceAsSymlink();
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        ProjectExplorerTraceActionsTest.createCopy(traceItem, true);
        ProjectExplorerTraceActionsTest.createCopy(traceItem, false);
        fBot.closeAllEditors();
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        copiedItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        SWTBotTreeItem copiedAsNewItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_AS_NEW_TRACE_NAME);
        copiedAsNewItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_AS_NEW_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testLinkStatus(copiedItem, true);
        ProjectExplorerTraceActionsTest.testLinkStatus(copiedAsNewItem, false);
    }

    @Test
    public void testRenameSymbolicLinks() throws CoreException, TmfTraceImportException {
        ProjectExplorerTraceActionsTest.importTraceAsSymlink();
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        traceItem.doubleClick();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        traceItem.contextMenu().menu(new String[]{"Rename..."}).click();
        String RENAME_TRACE_DIALOG_TITLE = "Rename Trace";
        SWTBotShell shell = fBot.shell("Rename Trace").activate();
        SWTBotText text = shell.bot().textWithLabel("New Trace name:");
        text.setText(RENAMED_TRACE_NAME);
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        copiedItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testLinkStatus(copiedItem, true);
    }

    private static void importTraceAsSymlink() throws TmfTraceImportException, CoreException {
        TraceTypeHelper helper = TmfTraceTypeUIUtils.selectTraceType((String)fTestFile.getAbsolutePath(), null, null);
        boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
        IProject project = TmfProjectRegistry.createProject((String)TRACE_PROJECT_NAME, null, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)project);
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project);
        TmfTraceFolder folder = projectElement.getTracesFolder();
        Assert.assertNotNull((Object)folder);
        IFile file = folder.getResource().getFile(fTestFile.getName());
        Assert.assertNotNull((Object)file);
        ResourceUtil.createSymbolicLink((IResource)file, (IPath)new Path(fTestFile.getAbsolutePath()), (!IS_WINDOWS ? 1 : 0) != 0, null);
        folder.getResource().refreshLocal(2, null);
        TmfTraceTypeUIUtils.setTraceType((IResource)file, (TraceTypeHelper)helper, (boolean)false);
    }

    private static void createCopy(SWTBotTreeItem traceItem, boolean copyAsLink) {
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        traceItem.contextMenu().menu(new String[]{"Copy..."}).click();
        SWTBotShell shell = fBot.shell(COPY_TRACE_DIALOG_TITLE).activate();
        SWTBotText text = shell.bot().textWithLabel("New Trace name:");
        text.setText(RENAMED_TRACE_NAME);
        if (!copyAsLink) {
            shell.bot().radio(COPY_AS_NEW_TRACE_OPTION).click();
            text.setText(RENAMED_AS_NEW_TRACE_NAME);
        }
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
    }

    private static void createExperimentCopy(SWTBotTreeItem expItem, boolean deepCopy) {
        fBot.viewByTitle(PROJECT_EXPLORER_VIEW_NAME).setFocus();
        expItem.contextMenu().menu(new String[]{"Copy..."}).click();
        SWTBotShell shell = fBot.shell(COPY_EXPERIMENT_DIALOG_TITLE).activate();
        SWTBotText text = shell.bot().textWithLabel("New Experiment name:");
        text.setText(RENAMED_EXP_NAME);
        if (deepCopy) {
            text.setText(RENAMED_EXP_DEEP_COPY);
            shell.bot().checkBox(DEEP_COPY_OPTION).click();
        }
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
    }

    private static void testStatisticsView() {
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.tmf.ui.views.statistics");
        SWTBotView view = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.statistics");
        Assert.assertTrue((boolean)view.bot().tree().hasItems());
        view.bot().tree().cell(0, 1).equals(Long.toString(CUSTOM_TEXT_LOG.getNbEvents()));
    }

    private static void testLinkStatus(SWTBotTreeItem traceItem, boolean isLinked) {
        SWTBotView viewBot = fBot.viewByTitle(PROPERTIES_VIEW_NAME);
        viewBot.show();
        fBot.waitUntil(ConditionHelpers.viewIsOpened((SWTBotView)viewBot));
        traceItem.select();
        SWTBotTree tree = viewBot.bot().tree();
        SWTBotTreeItem resourcePropertiesItem = tree.getTreeItem(RESOURCE_PROPERTIES_ITEM_NAME);
        fBot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)LINKED_ITEM_NAME, (SWTBotTreeItem)resourcePropertiesItem));
        SWTBotTreeItem linkedNode = resourcePropertiesItem.getNode(LINKED_ITEM_NAME);
        String linkedValue = linkedNode.cell(1);
        Assert.assertEquals((Object)Boolean.toString(isLinked), (Object)linkedValue);
    }

    private static void verifyExperimentCopy(SWTBotTreeItem copiedExpItem, boolean isDeepCopied) {
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        tracesFolder.expand();
        SWTBotTreeItem[] traceItems = tracesFolder.getItems();
        copiedExpItem.expand();
        if (isDeepCopied) {
            Assert.assertEquals((long)3L, (long)traceItems.length);
            copiedExpItem.getNode("expDeepCopy/" + TRACE_NAME);
            copiedExpItem.getNode("expDeepCopy/" + RENAMED_AS_NEW_TRACE_NAME);
            SWTBotTreeItem deepCopiedExpTracesFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)RENAMED_EXP_DEEP_COPY);
            deepCopiedExpTracesFolder.expand();
            SWTBotTreeItem[] expTracesFolderItems = deepCopiedExpTracesFolder.getItems();
            Assert.assertEquals((long)2L, (long)expTracesFolderItems.length);
            SWTBotTreeItem[] sWTBotTreeItemArray = expTracesFolderItems;
            int n = expTracesFolderItems.length;
            int n2 = 0;
            while (n2 < n) {
                SWTBotTreeItem traceItem = sWTBotTreeItemArray[n2];
                ProjectExplorerTraceActionsTest.testLinkStatus(traceItem, false);
                ++n2;
            }
        } else {
            Assert.assertEquals((long)2L, (long)traceItems.length);
            copiedExpItem.getNode(TRACE_NAME);
            copiedExpItem.getNode(RENAMED_AS_NEW_TRACE_NAME);
        }
    }

    private final class TraceDeletedCondition
    extends DefaultCondition {
        private TraceDeletedCondition() {
        }

        public boolean test() throws Exception {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(ProjectExplorerTraceActionsTest.TRACE_PROJECT_NAME).findMember((IPath)new Path("Traces/" + TRACE_NAME)) == null;
        }

        public String getFailureMessage() {
            return String.valueOf(TRACE_NAME) + " was not deleted successfully.";
        }
    }
}

