/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.io.diskioactivity.DiskIOActivityView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.ui.IViewPart;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.swtchart.Chart;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class DisksIOViewTest
extends XYDataProviderBaseTest {
    private static final RGB PURPLE = new RGB(255, 0, 255);
    private static final RGB GREEN = new RGB(0, 255, 0);
    private static final int NUMBER_OF_POINT = 50;
    private static final int MORE_POINTS = 100;
    private static final @NonNull String TITLE = "Disk I/O View";
    private static final @NonNull String READ_SERIES_NAME = "scp_dest/8,0/read";
    private static final @NonNull String WRITE_SERIES_NAME = "scp_dest/8,0/write";
    private static final @NonNull ITmfTimestamp ZOOM_START_TIME = TmfTimestamp.fromNanos((long)1361214078967381303L);
    private static final @NonNull ITmfTimestamp ZOOM_END_TIME = TmfTimestamp.fromNanos((long)1361214078967971599L);
    private static final Bundle BUNDLE = Platform.getBundle((String)"org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests");

    @Test
    public void testDiskView() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException, IOException {
        SWTBotTreeItem[] items;
        WaitUtils.waitForJobs();
        IViewPart viewSite = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewSite instanceof DiskIOActivityView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)DisksIOViewTest.getChartViewer((IViewPart)viewSite);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        SWTBotTreeItem[] sWTBotTreeItemArray = items = this.getSWTBotView().bot().tree().getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            item.check();
            ++n2;
        }
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length > 0, (Object)chart, (String)"No data available");
        chartViewer.setNbPoints(50);
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{WRITE_SERIES_NAME}), (Object)DisksIOViewTest.getFullPath("resources/disk/disk0-res50.json"), (String)"Chart data is not valid");
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, new TmfTimeRange(ZOOM_START_TIME, ZOOM_END_TIME)));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)new TmfTimeRange(ZOOM_START_TIME, ZOOM_END_TIME)));
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        this.verifyChartStyle();
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{WRITE_SERIES_NAME}), (Object)DisksIOViewTest.getFullPath("resources/disk/disk1-res50.json"), (String)"Chart data is not valid");
        chartViewer.setNbPoints(100);
        this.verifyChartStyle();
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{WRITE_SERIES_NAME}), (Object)DisksIOViewTest.getFullPath("resources/disk/disk2-res100.json"), (String)"Chart data is not valid");
    }

    private static String getFullPath(String bundlePath) throws URISyntaxException, IOException {
        URL location = FileLocator.find((Bundle)BUNDLE, (IPath)new Path(bundlePath), null);
        URI uri = FileLocator.toFileURL((URL)location).toURI();
        return new File(uri).getAbsolutePath();
    }

    private void verifyChartStyle() {
        this.verifySeriesStyle(READ_SERIES_NAME, ISeries.SeriesType.LINE, GREEN, LineStyle.SOLID, true);
        this.verifySeriesStyle(WRITE_SERIES_NAME, ISeries.SeriesType.LINE, PURPLE, LineStyle.SOLID, true);
    }

    protected String getMainSeriesName() {
        return READ_SERIES_NAME;
    }

    protected String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return "org.eclipse.tracecompass.analysis.os.linux.views.diskioactivity";
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_DEST);
    }

    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.SYNC_DEST);
    }
}

