/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlTimeGraphEntryModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlDataProviderManager;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class XmlTimeGraphDataProviderTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final @NonNull String ANALYSIS_ID = "xml.core.tests.simple.pattern";
    private static final @NonNull String TIME_GRAPH_VIEW_ID = "xml.core.tests.simple.pattern.timegraph";
    private static final @NonNull String TIME_GRAPH_VIEW_ID2 = "xml.core.tests.simple.pattern.timegraph2";
    private static final @NonNull IProgressMonitor MONITOR = new NullProgressMonitor();

    @Before
    public void setUp() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile());
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    public void cleanUp() {
        XmlUtils.deleteFiles((Collection)ImmutableList.of((Object)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile().getName(), (Object)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile().getName()));
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    private ITmfTrace getTrace() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, trace, null);
        ((TmfTrace)trace).traceOpened(signal);
        TmfTraceManager.getInstance().traceOpened(signal);
        IAnalysisModule module = trace.getAnalysisModule(ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        return trace;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testTwoLevels() throws IOException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"timeGraphView", (String)TIME_GRAPH_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            Assert.assertNotNull((Object)timeGraphProvider);
            List<String> expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphTree", new String[0]));
            Map<Long, String> tree = XmlTimeGraphDataProviderTest.assertAndGetTree((ITimeGraphDataProvider<XmlTimeGraphEntryModel>)timeGraphProvider, trace, expectedStrings);
            expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphRows", new String[0]));
            XmlTimeGraphDataProviderTest.assertRows((ITimeGraphDataProvider<XmlTimeGraphEntryModel>)timeGraphProvider, tree, expectedStrings);
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    private static void assertRows(ITimeGraphDataProvider<@NonNull XmlTimeGraphEntryModel> provider, Map<Long, String> tree, List<String> expectedStrings) {
        TmfModelResponse rowResponse = provider.fetchRowModel(new SelectionTimeQueryFilter(1L, 20L, 20, tree.keySet()), null);
        Assert.assertNotNull((Object)rowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        List rowModel = (List)rowResponse.getModel();
        Assert.assertNotNull((Object)rowModel);
        rowModel.sort(Comparator.comparingLong(ITimeGraphRowModel::getEntryID));
        Assert.assertEquals((long)expectedStrings.size(), (long)rowModel.size());
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(":");
            ITimeGraphRowModel row = (ITimeGraphRowModel)rowModel.get(i);
            Assert.assertEquals((Object)split[0], (Object)tree.get(row.getEntryID()));
            XmlTimeGraphDataProviderTest.assertEqualsStates(split[0], split[1], row.getStates());
            ++i;
        }
    }

    private static void assertEqualsStates(String name, String string, @NonNull List<@NonNull ITimeGraphState> states) {
        String[] stringStates = string.split(",");
        int i = 0;
        while (i < stringStates.length / 4) {
            ITimeGraphState state = states.get(i);
            Assert.assertNotNull((String)("State " + i + " for " + name), (Object)state);
            Assert.assertEquals((String)("Start time of state " + i + " for " + name), (long)Long.parseLong(stringStates[i * 4]), (long)state.getStartTime());
            Assert.assertEquals((String)("Duration of state " + i + " for " + name), (long)Long.parseLong(stringStates[i * 4 + 1]), (long)state.getDuration());
            Assert.assertEquals((String)("Value of state " + i + " for " + name), (long)Long.parseLong(stringStates[i * 4 + 2]), (long)state.getValue());
            Assert.assertEquals((String)("Label of state " + i + " for " + name), (Object)stringStates[i * 4 + 3], (Object)String.valueOf(state.getLabel()));
            ++i;
        }
        Assert.assertEquals((String)"Expected number of states", (long)(stringStates.length / 4), (long)states.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<Long, String> assertAndGetTree(ITimeGraphDataProvider<@NonNull XmlTimeGraphEntryModel> timeGraphProvider, ITmfTrace trace, List<String> expectedStrings) {
        @NonNull @NonNull TmfModelResponse treeResponse = timeGraphProvider.fetchTree(new TimeQueryFilter(0L, Long.MAX_VALUE, 2), MONITOR);
        Assert.assertNotNull((Object)treeResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)treeResponse.getStatus());
        List treeModel = (List)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        Collections.sort(treeModel, Comparator.comparingLong(TmfTreeDataModel::getId));
        HashMap<Long, String> map = new HashMap<Long, String>();
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            Assert.assertTrue((String)("actual entry present at " + i + ": " + expectedString), (treeModel.size() > i ? 1 : 0) != 0);
            String[] split = expectedString.split(",");
            XmlTimeGraphEntryModel xmlTgEntry = (XmlTimeGraphEntryModel)treeModel.get(i);
            Assert.assertEquals((String)("Checking entry name at " + i), (Object)split[0], (Object)xmlTgEntry.getName());
            Assert.assertEquals((String)("Checking entry start time at " + i), (long)Long.parseLong(split[1]), (long)xmlTgEntry.getStartTime());
            Assert.assertEquals((String)("Checking entry end time at " + i), (long)Long.parseLong(split[2]), (long)xmlTgEntry.getEndTime());
            long parentId = xmlTgEntry.getParentId();
            if (parentId < 0L) {
                Assert.assertEquals((String)("Checking empty parent at " + i), (Object)split[3], (Object)"null");
            } else {
                String parentName = (String)map.get(parentId);
                Assert.assertEquals((String)("Checking parent at " + i), (Object)split[3], (Object)parentName);
            }
            map.put(xmlTgEntry.getId(), xmlTgEntry.getName());
            ++i;
        }
        Assert.assertEquals((String)"Extra actual entries", (long)expectedStrings.size(), (long)treeModel.size());
        return map;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testNoParentDisplay() throws IOException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"timeGraphView", (String)TIME_GRAPH_VIEW_ID2);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITimeGraphDataProvider timeGraphProvider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            Assert.assertNotNull((Object)timeGraphProvider);
            List<String> expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphTree", new String[0]));
            Map<Long, String> tree = XmlTimeGraphDataProviderTest.assertAndGetTree((ITimeGraphDataProvider<XmlTimeGraphEntryModel>)timeGraphProvider, trace, expectedStrings);
            expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedTimeGraphRows", new String[0]));
            expectedStrings.remove(0);
            XmlTimeGraphDataProviderTest.assertRows((ITimeGraphDataProvider<XmlTimeGraphEntryModel>)timeGraphProvider, tree, expectedStrings);
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }
}

