/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlDataProviderManager;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class XmlXyDataProviderTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private static final @NonNull String ANALYSIS_ID = "xml.core.tests.simple.pattern";
    private static final @NonNull String XY_VIEW_ID = "xml.core.tests.simple.pattern.xy";
    private static final @NonNull IProgressMonitor MONITOR = new NullProgressMonitor();

    @Before
    public void setUp() {
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile());
        XmlUtils.addXmlFile((File)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile());
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    public void cleanUp() {
        XmlUtils.deleteFiles((Collection)ImmutableList.of((Object)TmfXmlTestFiles.VALID_PATTERN_SIMPLE_FILE.getFile().getName(), (Object)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getFile().getName()));
        XmlAnalysisModuleSource.notifyModuleChange();
    }

    private ITmfTrace getTrace() {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        TmfTraceOpenedSignal signal = new TmfTraceOpenedSignal((Object)this, trace, null);
        ((TmfTrace)trace).traceOpened(signal);
        TmfTraceManager.getInstance().traceOpened(signal);
        IAnalysisModule module = trace.getAnalysisModule(ANALYSIS_ID);
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        return trace;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testXYDataProvider() throws IOException {
        ITmfTrace trace = this.getTrace();
        Assert.assertNotNull((Object)trace);
        try {
            Element viewElement = TmfXmlUtils.getElementInFile((String)TmfXmlTestFiles.DATA_PROVIDER_SIMPLE_FILE.getPath().toOSString(), (String)"xyView", (String)XY_VIEW_ID);
            Assert.assertNotNull((Object)viewElement);
            @NonNull ITmfTreeXYDataProvider xyProvider = XmlDataProviderManager.getInstance().getXyProvider(trace, viewElement);
            Assert.assertNotNull((Object)xyProvider);
            List<String> expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedXYTree", new String[0]));
            Map<Long, String> tree = XmlXyDataProviderTest.assertAndGetTree((ITmfTreeXYDataProvider<ITmfTreeDataModel>)xyProvider, trace, expectedStrings);
            expectedStrings = Files.readAllLines(Paths.get("test_traces/simple_dataprovider/expectedXYData", new String[0]));
            XmlXyDataProviderTest.assertRows((ITmfTreeXYDataProvider<ITmfTreeDataModel>)xyProvider, tree, expectedStrings);
        }
        finally {
            trace.dispose();
            TmfTraceManager.getInstance().traceClosed(new TmfTraceClosedSignal((Object)this, trace));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertRows(ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> xyProvider, Map<Long, String> tree, List<String> expectedStrings) {
        @NonNull TmfModelResponse rowResponse = xyProvider.fetchXY((TimeQueryFilter)new SelectionTimeQueryFilter(1L, 20L, 20, tree.keySet()), null);
        Assert.assertNotNull((Object)rowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        ITmfXyModel rowModel = (ITmfXyModel)rowResponse.getModel();
        Assert.assertNotNull((Object)rowModel);
        @NonNull @NonNull Map data = rowModel.getData();
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(":");
            String rowName = split[0];
            ISeriesModel row = (ISeriesModel)data.get(rowName);
            Assert.assertNotNull((Object)row);
            String[] expectedData = split[1].split(",");
            double[] actualData = row.getData();
            int j = 0;
            while (j < expectedData.length) {
                Assert.assertTrue((String)("Presence of data at position " + j + " for row " + rowName), (actualData.length > j ? 1 : 0) != 0);
                double expectedValue = Double.parseDouble(expectedData[j]);
                Assert.assertEquals((String)("Data at position " + j + " for row " + rowName), (double)expectedValue, (double)actualData[j], (double)0.001);
                ++j;
            }
            ++i;
        }
        Assert.assertEquals((String)"Same number of data", (long)expectedStrings.size(), (long)data.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<Long, String> assertAndGetTree(ITmfTreeXYDataProvider<@NonNull ITmfTreeDataModel> xyProvider, ITmfTrace trace, List<String> expectedStrings) {
        @NonNull TmfModelResponse treeResponse = xyProvider.fetchTree(new TimeQueryFilter(0L, Long.MAX_VALUE, 2), MONITOR);
        Assert.assertNotNull((Object)treeResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)treeResponse.getStatus());
        List treeModel = (List)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        HashMap<Long, String> map = new HashMap<Long, String>();
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            Assert.assertTrue((String)("actual entry absent at " + i + ": " + expectedString), (treeModel.size() > i ? 1 : 0) != 0);
            String[] split = expectedString.split(",");
            ITmfTreeDataModel xmlXyEntry = (ITmfTreeDataModel)treeModel.get(i);
            Assert.assertEquals((String)("Checking entry name at " + i), (Object)split[0], (Object)xmlXyEntry.getName());
            long parentId = xmlXyEntry.getParentId();
            if (parentId < 0L) {
                Assert.assertEquals((String)("Checking empty parent at " + i), (Object)split[1], (Object)"null");
            } else {
                String parentName = (String)map.get(parentId);
                Assert.assertEquals((String)("Checking parent at " + i), (Object)split[1], (Object)parentName);
            }
            map.put(xmlXyEntry.getId(), xmlXyEntry.getName());
            ++i;
        }
        Assert.assertEquals((String)"Extra actual entries", (long)expectedStrings.size(), (long)treeModel.size());
        return map;
    }
}

