/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateProviderCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenAnalysisModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class XmlModuleTestBase {
    private TmfAbstractAnalysisModule fModule;

    @Test
    public void testModuleConstruction() {
        Document doc = this.getXmlFile().getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList analysisNodes = doc.getElementsByTagName(this.getAnalysisNodeName());
        Assert.assertTrue((analysisNodes.getLength() > 0 ? 1 : 0) != 0);
        Element node = (Element)analysisNodes.item(0);
        Assert.assertNotNull((Object)node);
        this.createModule(node);
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        this.fModule.setId(moduleId);
        Assert.assertEquals((Object)this.getAnalysisId(), (Object)this.fModule.getId());
        Assert.assertEquals((Object)this.getAnalysisName(), (Object)this.fModule.getName());
        this.fModule.dispose();
    }

    private void createModule(@NonNull Element element) {
        switch (this.getAnalysisNodeName()) {
            case "pattern": {
                this.fModule = new XmlPatternAnalysis();
                ((XmlPatternAnalysis)this.fModule).setXmlFile(this.getXmlFile().getFile().toPath());
                this.fModule.setName(XmlModuleTestBase.getName(element));
                break;
            }
            case "stateProvider": {
                String analysisId = element.getAttribute("id");
                TmfXmlStateProviderCu compile = TmfXmlStateProviderCu.compile((Path)this.getXmlFile().getFile().toPath(), (String)analysisId);
                Assert.assertNotNull((Object)compile);
                this.fModule = new DataDrivenAnalysisModule(analysisId, compile);
                this.fModule.setName(XmlModuleTestBase.getName(element));
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    protected abstract @NonNull String getAnalysisNodeName();

    protected abstract TmfXmlTestFiles getXmlFile();

    protected abstract String getAnalysisName();

    protected abstract String getAnalysisId();

    protected abstract @NonNull CtfTestTrace getTrace();

    public static @NonNull String getName(Element element) {
        List labels;
        String name = null;
        List head = TmfXmlUtils.getChildElements((Element)element, (String)"head");
        if (head.size() == 1 && !(labels = TmfXmlUtils.getChildElements((Element)((Element)head.get(0)), (String)"label")).isEmpty()) {
            name = ((Element)labels.get(0)).getAttribute("value");
        }
        Assert.assertNotNull((String)"analysis name", name);
        return name;
    }

    @Test
    public void testModuleExecution() {
        block5: {
            Document doc = this.getXmlFile().getXmlDocument();
            Assert.assertNotNull((Object)doc);
            NodeList stateproviderNodes = doc.getElementsByTagName(this.getAnalysisNodeName());
            Element node = (Element)stateproviderNodes.item(0);
            Assert.assertNotNull((Object)node);
            this.createModule(node);
            String moduleId = node.getAttribute("id");
            Assert.assertNotNull((Object)moduleId);
            this.fModule.setId(moduleId);
            CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)this.getTrace());
            try {
                try {
                    this.fModule.setTrace((ITmfTrace)trace);
                    this.fModule.schedule();
                    Assert.assertTrue((boolean)this.fModule.waitForCompletion((IProgressMonitor)new NullProgressMonitor()));
                }
                catch (TmfAnalysisException e) {
                    Assert.fail((String)("Cannot set trace " + e.getMessage()));
                    trace.dispose();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                trace.dispose();
                throw throwable;
            }
            trace.dispose();
        }
        this.fModule.dispose();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)this.getTrace());
    }
}

