/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ResetStoredFieldsAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.UpdateStoredFieldsAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlPatternEventHandler {
    private final XmlPatternStateProvider fParent;
    private final List<String> fInitialFsm;
    private final Map<String, DataDrivenCondition> fTestMap;
    private final Map<String, ITmfXmlAction> fActionMap;
    private final Map<String, TmfXmlFsm> fFsmMap = new LinkedHashMap<String, TmfXmlFsm>();
    private final List<TmfXmlFsm> fActiveFsmList = new ArrayList<TmfXmlFsm>();

    public TmfXmlPatternEventHandler(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer parent) {
        this.fParent = (XmlPatternStateProvider)parent;
        String initialFsm = node.getAttribute("initial");
        this.fInitialFsm = initialFsm.isEmpty() ? Collections.emptyList() : Arrays.asList(initialFsm.split(":"));
        HashMap<String, DataDrivenCondition> testMap = new HashMap<String, DataDrivenCondition>();
        NodeList nodesTest = node.getElementsByTagName("test");
        int i = 0;
        while (i < nodesTest.getLength()) {
            Element element = (Element)nodesTest.item(i);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            String testId = modelFactory.createTransitionValidator(element, this.fParent);
            TmfXmlConditionCu test = Objects.requireNonNull(this.fParent.getAnalysisCompilationData().getTest(testId));
            testMap.put(testId, test.generate());
            ++i;
        }
        this.fTestMap = Collections.unmodifiableMap(testMap);
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableMap.Builder builder = ImmutableMap.builder();
        NodeList nodesAction = node.getElementsByTagName("action");
        int i2 = 0;
        while (i2 < nodesAction.getLength()) {
            Element element = (Element)nodesAction.item(i2);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            TmfXmlAction action = modelFactory.createAction(element, this.fParent);
            builder.put((Object)action.getId(), (Object)action);
            ++i2;
        }
        builder.put((Object)"#clearStoredFields", (Object)new ResetStoredFieldsAction(this.fParent));
        builder.put((Object)"#saveStoredFields", (Object)new UpdateStoredFieldsAction(this.fParent));
        this.fActionMap = builder.build();
        NodeList nodesFsm = node.getElementsByTagName("fsm");
        int i3 = 0;
        while (i3 < nodesFsm.getLength()) {
            Element element = (Element)nodesFsm.item(i3);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            TmfXmlFsm fsm = modelFactory.createFsm(element, this.fParent);
            this.fFsmMap.put(fsm.getId(), fsm);
            ++i3;
        }
    }

    public void startScenario(List<String> fsmIds, @Nullable ITmfEvent event, boolean force) {
        for (String fsmId : fsmIds) {
            TmfXmlFsm fsm = (TmfXmlFsm)NonNullUtils.checkNotNull((Object)this.fFsmMap.get(fsmId));
            if (!this.fActiveFsmList.contains(fsm)) {
                this.fActiveFsmList.add(fsm);
            }
            fsm.createScenario(event, this, force);
        }
    }

    public Map<String, DataDrivenCondition> getTestMap() {
        return this.fTestMap;
    }

    public Map<String, ITmfXmlAction> getActionMap() {
        return this.fActionMap;
    }

    public void handleEvent(ITmfEvent event) {
        @NonNull List<@NonNull TmfXmlFsm> activeFsmList = this.fActiveFsmList;
        @NonNull Map<@NonNull String, @NonNull TmfXmlFsm> fsmMap = this.fFsmMap;
        if (activeFsmList.isEmpty()) {
            List<String> fsmIds = this.fInitialFsm;
            if (fsmIds.isEmpty()) {
                fsmIds = new ArrayList<String>();
                for (TmfXmlFsm fsm : fsmMap.values()) {
                    fsmIds.add(fsm.getId());
                }
            }
            if (!fsmIds.isEmpty()) {
                this.startScenario(fsmIds, null, true);
            }
        } else {
            ArrayList<String> fsmToStart = new ArrayList<String>();
            for (Map.Entry<String, TmfXmlFsm> entry : fsmMap.entrySet()) {
                if (!entry.getValue().isNewScenarioAllowed()) continue;
                fsmToStart.add(entry.getKey());
            }
            if (!fsmToStart.isEmpty()) {
                this.startScenario(fsmToStart, null, false);
            }
        }
        for (TmfXmlFsm fsm : activeFsmList) {
            fsm.handleEvent(event, this.fTestMap, this.fParent);
        }
    }

    public void dispose() {
        for (TmfXmlFsm fsm : this.fActiveFsmList) {
            fsm.dispose();
        }
    }

    public @Nullable TmfXmlFsm getFsm(String fsmId) {
        return this.fFsmMap.get(fsmId);
    }
}

