/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.events.TmfEventTableColumnDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.events.TmfEventTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.events.TmfEventTableFilterModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.EventTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.EventTableLine;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfFilterModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.TmfVirtualTableModel;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@NonNullByDefault
public class TmfEventTableDataProviderTest {
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private static ITmfTrace fTrace = new TmfTraceStub();
    private static ITmfVirtualTableDataProvider<TmfEventTableColumnDataModel, EventTableLine> fProvider = new TmfEventTableDataProvider(fTrace);
    private static final String TIMESTAMP_COLUMN_NAME = "Timestamp";
    private static final String EVENT_TYPE_COLUMN_NAME = "Event type";
    private static final String CONTENTS_COLUMN_NAME = "Contents";
    private static Map<String, Long> fColumns = Collections.emptyMap();

    @BeforeClass
    public static void beforeClass() throws TmfTraceException {
        fTrace.dispose();
        fTrace = new TmfTraceStub(TEST_TRACE.getFullPath(), 1000, false, null);
        fProvider = new TmfEventTableDataProvider(fTrace);
        fColumns = TmfEventTableDataProviderTest.fetchColumnId();
    }

    private static Map<String, Long> fetchColumnId() {
        List columns = (List)fProvider.fetchTree(new TimeQueryFilter(0L, 0L, 1), null).getModel();
        if (columns == null) {
            return Collections.emptyMap();
        }
        Assert.assertEquals((Object)TIMESTAMP_COLUMN_NAME, (Object)((TmfEventTableColumnDataModel)columns.get(0)).getName());
        Assert.assertEquals((Object)EVENT_TYPE_COLUMN_NAME, (Object)((TmfEventTableColumnDataModel)columns.get(1)).getName());
        Assert.assertEquals((Object)CONTENTS_COLUMN_NAME, (Object)((TmfEventTableColumnDataModel)columns.get(2)).getName());
        LinkedHashMap<String, Long> expectedColumns = new LinkedHashMap<String, Long>();
        for (TmfEventTableColumnDataModel column : columns) {
            expectedColumns.put(column.getName(), column.getId());
        }
        return expectedColumns;
    }

    private static String lineTimestamp(long millisecond) {
        return TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)millisecond).toNanos());
    }

    @AfterClass
    public static void tearDown() {
        fTrace.dispose();
    }

    @Test
    public void testDataProviderFetchColumn() {
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long contentsColumnId = fColumns.get(CONTENTS_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        Assert.assertNotNull((Object)contentsColumnId);
        List<TmfEventTableColumnDataModel> expectedColumnModel = Arrays.asList(new TmfEventTableColumnDataModel(timestampColumnId.longValue(), -1L, TIMESTAMP_COLUMN_NAME, "", false), new TmfEventTableColumnDataModel(eventTypeColumnId.longValue(), -1L, EVENT_TYPE_COLUMN_NAME, "The type of this event. This normally determines the field layout.", false), new TmfEventTableColumnDataModel(contentsColumnId.longValue(), -1L, CONTENTS_COLUMN_NAME, "The fields (or payload) of this event", false));
        TmfModelResponse response = fProvider.fetchTree(new TimeQueryFilter(0L, 0L, 1), null);
        List currentColumnModel = (List)response.getModel();
        Assert.assertEquals(expectedColumnModel, (Object)currentColumnModel);
    }

    @Test
    public void testDataProvider() {
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Collections.emptyList(), 0L, 5, null);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(TmfEventTableDataProviderTest.lineTimestamp(1L), "Type-0", ""), 0L, TmfTimestamp.fromMillis((long)1L), 0L, 0L), new EventTableLine(Arrays.asList(TmfEventTableDataProviderTest.lineTimestamp(2L), "Type-1", ""), 1L, TmfTimestamp.fromMillis((long)2L), 1L, 0L), new EventTableLine(Arrays.asList(TmfEventTableDataProviderTest.lineTimestamp(3L), "Type-2", ""), 2L, TmfTimestamp.fromMillis((long)3L), 2L, 0L), new EventTableLine(Arrays.asList(TmfEventTableDataProviderTest.lineTimestamp(4L), "Type-3", ""), 3L, TmfTimestamp.fromMillis((long)4L), 3L, 0L), new EventTableLine(Arrays.asList(TmfEventTableDataProviderTest.lineTimestamp(5L), "Type-4", ""), 4L, TmfTimestamp.fromMillis((long)5L), 4L, 0L));
        TmfModelResponse response = fProvider.fetchLines((VirtualTableQueryFilter)queryFilter, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, fTrace.getNbEvents());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithOutOfBoundIndex() {
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Collections.emptyList(), 2000000L, 5, null);
        TmfModelResponse response = fProvider.fetchLines((VirtualTableQueryFilter)queryFilter, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        Assert.assertEquals(new ArrayList<Long>(fColumns.values()), (Object)currentModel.getColumnIds());
        Assert.assertTrue((boolean)currentModel.getData().isEmpty());
    }

    @Test
    public void testDataProviderWithDesiredColumns() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Collections.singletonList(eventTypeColumnId), 5L, 5, null);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList("Type-5"), 5L, TmfTimestamp.fromMillis((long)6L), 5L, 0L), new EventTableLine(Arrays.asList("Type-6"), 6L, TmfTimestamp.fromMillis((long)7L), 6L, 0L), new EventTableLine(Arrays.asList("Type-0"), 7L, TmfTimestamp.fromMillis((long)8L), 7L, 0L), new EventTableLine(Arrays.asList("Type-1"), 8L, TmfTimestamp.fromMillis((long)9L), 8L, 0L), new EventTableLine(Arrays.asList("Type-2"), 9L, TmfTimestamp.fromMillis((long)10L), 9L, 0L));
        TmfModelResponse response = fProvider.fetchLines((VirtualTableQueryFilter)queryFilter, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 5L, fTrace.getNbEvents());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithOneNonExistentColumns() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, 10L, timestampColumnId), 150L, 5, null);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList("Type-3", TmfEventTableDataProviderTest.lineTimestamp(151L)), 150L, TmfTimestamp.fromMillis((long)151L), 150L, 0L), new EventTableLine(Arrays.asList("Type-4", TmfEventTableDataProviderTest.lineTimestamp(152L)), 151L, TmfTimestamp.fromMillis((long)152L), 151L, 0L), new EventTableLine(Arrays.asList("Type-5", TmfEventTableDataProviderTest.lineTimestamp(153L)), 152L, TmfTimestamp.fromMillis((long)153L), 152L, 0L), new EventTableLine(Arrays.asList("Type-6", TmfEventTableDataProviderTest.lineTimestamp(154L)), 153L, TmfTimestamp.fromMillis((long)154L), 153L, 0L), new EventTableLine(Arrays.asList("Type-0", TmfEventTableDataProviderTest.lineTimestamp(155L)), 154L, TmfTimestamp.fromMillis((long)155L), 154L, 0L));
        TmfModelResponse response = fProvider.fetchLines((VirtualTableQueryFilter)queryFilter, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 150L, fTrace.getNbEvents());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithNonExistentColumns() {
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(10L, 11L), 0L, 10, null);
        TmfModelResponse response = fProvider.fetchLines((VirtualTableQueryFilter)queryFilter, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        Assert.assertTrue((boolean)currentModel.getColumnIds().isEmpty());
        Assert.assertTrue((boolean)currentModel.getData().isEmpty());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithSimpleFilter() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        HashMap<Long, String> tableFilter = new HashMap<Long, String>();
        tableFilter.put(eventTypeColumnId, "1");
        TmfEventTableFilterModel filterModel = new TmfEventTableFilterModel(tableFilter, null, false);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, 5, (ITmfFilterModel)filterModel);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList("Type-1", TmfEventTableDataProviderTest.lineTimestamp(2L)), 0L, TmfTimestamp.fromMillis((long)2L), 1L, 0L), new EventTableLine(Arrays.asList("Type-1", TmfEventTableDataProviderTest.lineTimestamp(9L)), 1L, TmfTimestamp.fromMillis((long)9L), 8L, 0L), new EventTableLine(Arrays.asList("Type-1", TmfEventTableDataProviderTest.lineTimestamp(16L)), 2L, TmfTimestamp.fromMillis((long)16L), 15L, 0L), new EventTableLine(Arrays.asList("Type-1", TmfEventTableDataProviderTest.lineTimestamp(23L)), 3L, TmfTimestamp.fromMillis((long)23L), 22L, 0L), new EventTableLine(Arrays.asList("Type-1", TmfEventTableDataProviderTest.lineTimestamp(30L)), 4L, TmfTimestamp.fromMillis((long)30L), 29L, 0L));
        TmfModelResponse response = fProvider.fetchLines((VirtualTableQueryFilter)queryFilter, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 0L, 1429L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithMultipleFilter() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        HashMap<Long, String> tableFilter = new HashMap<Long, String>();
        tableFilter.put(eventTypeColumnId, "0");
        tableFilter.put(timestampColumnId, "8");
        TmfEventTableFilterModel filterModel = new TmfEventTableFilterModel(tableFilter, null, false);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(1L, 0L), 0L, 5, (ITmfFilterModel)filterModel);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList("Type-0", TmfEventTableDataProviderTest.lineTimestamp(8L)), 0L, TmfTimestamp.fromMillis((long)8L), 7L, 0L), new EventTableLine(Arrays.asList("Type-0", TmfEventTableDataProviderTest.lineTimestamp(78L)), 1L, TmfTimestamp.fromMillis((long)78L), 77L, 0L), new EventTableLine(Arrays.asList("Type-0", TmfEventTableDataProviderTest.lineTimestamp(85L)), 2L, TmfTimestamp.fromMillis((long)85L), 84L, 0L), new EventTableLine(Arrays.asList("Type-0", TmfEventTableDataProviderTest.lineTimestamp(148L)), 3L, TmfTimestamp.fromMillis((long)148L), 147L, 0L), new EventTableLine(Arrays.asList("Type-0", TmfEventTableDataProviderTest.lineTimestamp(183L)), 4L, TmfTimestamp.fromMillis((long)183L), 182L, 0L));
        TmfModelResponse response = fProvider.fetchLines((VirtualTableQueryFilter)queryFilter, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 0L, 492L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryFilterIndexParameter() {
        new EventTableQueryFilter(Collections.emptyList(), -1L, 5, null);
    }
}

