/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.tmf.core.filter.TmfFilterHelper;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@NonNullByDefault
public class TmfFilterHelperTest {
    private static @Nullable ITmfTrace STUB_TRACE;
    private static final String FIELD1_NAME = "afield";
    private static final String FIELD2_NAME = "bfield";
    private static final String EVENT_NAME1 = "type1";
    private static final String EVENT_NAME2 = "type2";
    private static final String EVENT_NAME3 = "type3";
    private static final ITmfEventType EVENT_TYPE1;
    private static final ITmfEventType EVENT_TYPE2;
    private static final ITmfEventType EVENT_TYPE3;
    private static final String FIELD1_VALUE1 = "afield value 1";
    private static final String FIELD1_VALUE2 = "another afield value";
    private static final String FIELD2_VALUE1 = "1";
    private static final String FIELD2_VALUE2 = "2";
    private ITmfEventField[] fFields1 = new ITmfEventField[]{new TmfEventField("afield", (Object)"afield value 1", null)};
    private ITmfEventField[] fFields2 = new ITmfEventField[]{new TmfEventField("bfield", (Object)"1", null)};
    private ITmfEventField[] fFields3 = new ITmfEventField[]{new TmfEventField("afield", (Object)"another afield value", null), new TmfEventField("bfield", (Object)"2", null)};
    private ITmfEventField fContent1 = new TmfEventField(":root:", null, this.fFields1);
    private ITmfEventField fContent2 = new TmfEventField(":root:", null, this.fFields2);
    private ITmfEventField fContent3 = new TmfEventField(":root:", null, this.fFields3);
    private TmfEvent fEvent1 = new TmfEvent(STUB_TRACE, 0L, TmfTimestamp.fromNanos((long)1L), EVENT_TYPE1, this.fContent1);
    private TmfEvent fEvent2 = new TmfEvent(STUB_TRACE, 1L, TmfTimestamp.fromNanos((long)2L), EVENT_TYPE2, this.fContent2);
    private TmfEvent fEvent3 = new TmfEvent(STUB_TRACE, 2L, TmfTimestamp.fromNanos((long)3L), EVENT_TYPE3, this.fContent3);
    private Map<String, String> fObjectMap1 = ImmutableMap.of((Object)"afield", (Object)"afield value 1", (Object)TmfBaseAspects.getEventTypeAspect().getName(), (Object)"type1");
    private Map<String, String> fObjectMap2 = ImmutableMap.of((Object)"bfield", (Object)"1", (Object)TmfBaseAspects.getEventTypeAspect().getName(), (Object)"type2");
    private Map<String, String> fObjectMap3 = ImmutableMap.of((Object)"afield", (Object)"another afield value", (Object)"bfield", (Object)"2", (Object)TmfBaseAspects.getEventTypeAspect().getName(), (Object)"type3");

    static {
        EVENT_TYPE1 = new TmfEventType(EVENT_NAME1, TmfEventField.makeRoot((String[])new String[]{FIELD1_NAME}));
        EVENT_TYPE2 = new TmfEventType(EVENT_NAME2, TmfEventField.makeRoot((String[])new String[]{FIELD1_NAME}));
        EVENT_TYPE3 = new TmfEventType(EVENT_NAME3, TmfEventField.makeRoot((String[])new String[]{FIELD1_NAME}));
    }

    @BeforeClass
    public static void initTrace() {
        STUB_TRACE = TmfTestTrace.A_TEST_10K.getTrace();
    }

    @AfterClass
    public static void cleanUp() {
        ITmfTrace trace = STUB_TRACE;
        if (trace != null) {
            trace.dispose();
        }
    }

    private static ITmfFilter getFilter(String regex) {
        ITmfTrace trace = STUB_TRACE;
        Assert.assertNotNull((Object)trace);
        ITmfFilter filter = TmfFilterHelper.buildFilterFromRegex(Collections.singleton(regex), (ITmfTrace)trace);
        Assert.assertNotNull((Object)filter);
        return filter;
    }

    private static Predicate<Map<String, String>> getRegex(ITmfFilter filter, String expected) {
        String regex = TmfFilterHelper.getRegexFromFilter((ITmfFilter)filter);
        Assert.assertEquals((Object)expected, (Object)regex);
        FilterCu compile = FilterCu.compile((String)regex);
        Assert.assertNotNull((Object)compile);
        Predicate predicate = compile.generate();
        return predicate;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexAspect() {
        @NonNull ITmfEventAspect eventTypeAspect = TmfBaseAspects.getEventTypeAspect();
        String regex = "\"" + eventTypeAspect.getName() + "\" == " + EVENT_NAME1;
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterEqualsNode));
        TmfFilterEqualsNode equalsNode = (TmfFilterEqualsNode)child;
        Assert.assertEquals((Object)eventTypeAspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)EVENT_NAME1, (Object)equalsNode.getValue());
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexNoAspect() {
        @NonNull TmfEventFieldAspect contentAspect = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        String regex = "afield == \"afield value 1\"";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterEqualsNode));
        TmfFilterEqualsNode equalsNode = (TmfFilterEqualsNode)child;
        Assert.assertEquals((Object)contentAspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)FIELD1_VALUE1, (Object)equalsNode.getValue());
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexNoField() {
        String regex = FIELD1_NAME;
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterOrNode));
        TmfFilterOrNode orNode = (TmfFilterOrNode)child;
        ITmfTrace trace = STUB_TRACE;
        Assert.assertNotNull((Object)trace);
        @NonNull Iterable eventAspects = trace.getEventAspects();
        Assert.assertEquals((long)Iterables.size((Iterable)eventAspects), (long)orNode.getChildrenCount());
        int i = 0;
        while (i < orNode.getChildrenCount()) {
            Assert.assertTrue((boolean)(orNode.getChild(i) instanceof TmfFilterMatchesNode));
            ++i;
        }
        for (ITmfEventAspect aspect : eventAspects) {
            ITmfFilterTreeNode[] children = orNode.getChildren();
            TmfFilterMatchesNode found = null;
            int i2 = 0;
            while (i2 < children.length) {
                TmfFilterMatchesNode childFilter = (TmfFilterMatchesNode)children[i2];
                if (aspect.equals(childFilter.getEventAspect())) {
                    found = childFilter;
                    break;
                }
                ++i2;
            }
            Assert.assertNotNull((String)("found aspect " + aspect.getName()), found);
            Assert.assertEquals((Object)regex, (Object)found.getRegex());
        }
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexContains() {
        @NonNull ITmfEventAspect eventTypeAspect = TmfBaseAspects.getEventTypeAspect();
        String regex = "\"" + eventTypeAspect.getName() + "\" contains 1";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterContainsNode));
        TmfFilterContainsNode equalsNode = (TmfFilterContainsNode)child;
        Assert.assertEquals((Object)eventTypeAspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)FIELD2_VALUE1, (Object)equalsNode.getValue());
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexPresent() {
        @NonNull TmfEventFieldAspect aspect = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        String regex = "afield present";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterMatchesNode));
        TmfFilterMatchesNode equalsNode = (TmfFilterMatchesNode)child;
        Assert.assertEquals((Object)aspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)".*", (Object)equalsNode.getRegex());
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexMatches() {
        @NonNull TmfEventFieldAspect contentAspect = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        String regex = "afield matches .*other.*";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterMatchesNode));
        TmfFilterMatchesNode equalsNode = (TmfFilterMatchesNode)child;
        Assert.assertEquals((Object)contentAspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)".*other.*", (Object)equalsNode.getRegex());
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexCompare() {
        @NonNull TmfEventFieldAspect contentAspect = TmfBaseAspects.getContentsAspect().forField(FIELD2_NAME);
        String regex = "bfield > 1";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterCompareNode));
        TmfFilterCompareNode equalsNode = (TmfFilterCompareNode)child;
        Assert.assertEquals((Object)contentAspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)FIELD2_VALUE1, (Object)equalsNode.getValue());
        Assert.assertEquals((long)1L, (long)equalsNode.getResult());
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent3));
        regex = "bfield < 2";
        filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterCompareNode));
        equalsNode = (TmfFilterCompareNode)child;
        Assert.assertEquals((Object)contentAspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)FIELD2_VALUE2, (Object)equalsNode.getValue());
        Assert.assertEquals((long)-1L, (long)equalsNode.getResult());
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexAnd() {
        String regex = "afield matches .*afield.* && bfield present";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        @NonNull TmfEventFieldAspect aspectF1 = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        @NonNull TmfEventFieldAspect aspectF2 = TmfBaseAspects.getContentsAspect().forField(FIELD2_NAME);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterAndNode));
        TmfFilterAndNode andNode = (TmfFilterAndNode)child;
        Assert.assertEquals((long)2L, (long)andNode.getChildrenCount());
        child = andNode.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterMatchesNode));
        TmfFilterMatchesNode equalsNode = (TmfFilterMatchesNode)child;
        Assert.assertEquals((Object)aspectF1, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)".*afield.*", (Object)equalsNode.getRegex());
        child = andNode.getChild(1);
        Assert.assertTrue((boolean)(child instanceof TmfFilterMatchesNode));
        equalsNode = (TmfFilterMatchesNode)child;
        Assert.assertEquals((Object)aspectF2, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)".*", (Object)equalsNode.getRegex());
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexMatchesNot() {
        @NonNull TmfEventFieldAspect contentAspect = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        String regex = "!(afield matches .*other.*)";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterMatchesNode));
        TmfFilterMatchesNode equalsNode = (TmfFilterMatchesNode)child;
        Assert.assertEquals((Object)contentAspect, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)".*other.*", (Object)equalsNode.getRegex());
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputRegexNot() {
        String regex = "!(afield matches .*afield.* && bfield present)";
        ITmfFilter filter = TmfFilterHelperTest.getFilter(regex);
        @NonNull TmfEventFieldAspect aspectF1 = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        @NonNull TmfEventFieldAspect aspectF2 = TmfBaseAspects.getContentsAspect().forField(FIELD2_NAME);
        Assert.assertTrue((boolean)(filter instanceof TmfFilterRootNode));
        TmfFilterRootNode node = (TmfFilterRootNode)filter;
        Assert.assertEquals((long)1L, (long)node.getChildrenCount());
        ITmfFilterTreeNode child = node.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterAndNode));
        TmfFilterAndNode andNode = (TmfFilterAndNode)child;
        Assert.assertEquals((long)2L, (long)andNode.getChildrenCount());
        child = andNode.getChild(0);
        Assert.assertTrue((boolean)(child instanceof TmfFilterMatchesNode));
        TmfFilterMatchesNode equalsNode = (TmfFilterMatchesNode)child;
        Assert.assertEquals((Object)aspectF1, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)".*afield.*", (Object)equalsNode.getRegex());
        child = andNode.getChild(1);
        Assert.assertTrue((boolean)(child instanceof TmfFilterMatchesNode));
        equalsNode = (TmfFilterMatchesNode)child;
        Assert.assertEquals((Object)aspectF2, (Object)equalsNode.getEventAspect());
        Assert.assertEquals((Object)".*", (Object)equalsNode.getRegex());
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)filter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)filter.matches((ITmfEvent)this.fEvent3));
    }

    private static String notRegex(String string) {
        return "!(" + string + ")";
    }

    @Test
    public void testInputFilterUnsupported() {
        TmfFilterTraceTypeNode filter = new TmfFilterTraceTypeNode(null);
        String regex = TmfFilterHelper.getRegexFromFilter((ITmfFilter)filter);
        Assert.assertEquals((Object)"", (Object)regex);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputFilterCompare() {
        @NonNull TmfEventFieldAspect aspect = TmfBaseAspects.getContentsAspect().forField(FIELD2_NAME);
        String expected = "\"bfield\" > \"1\"";
        TmfFilterCompareNode compareFilter = new TmfFilterCompareNode(null);
        compareFilter.setEventAspect((ITmfEventAspect)aspect);
        compareFilter.setValue(FIELD2_VALUE1);
        compareFilter.setResult(1);
        Predicate<Map<String, String>> predicate = TmfFilterHelperTest.getRegex((ITmfFilter)compareFilter, expected);
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap2));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap3));
        compareFilter.setNot(true);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)compareFilter, TmfFilterHelperTest.notRegex(expected));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
        expected = "\"bfield\" < \"2\"";
        compareFilter = new TmfFilterCompareNode(null);
        compareFilter.setEventAspect((ITmfEventAspect)aspect);
        compareFilter.setValue(FIELD2_VALUE2);
        compareFilter.setResult(-1);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)compareFilter, expected);
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
        expected = "\"bfield\" == \"1\"";
        compareFilter = new TmfFilterCompareNode(null);
        compareFilter.setEventAspect((ITmfEventAspect)aspect);
        compareFilter.setValue(FIELD2_VALUE1);
        compareFilter.setResult(0);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)compareFilter, expected);
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputFilterContains() {
        @NonNull TmfEventFieldAspect aspect = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        String expected = "\"afield\" contains \"other\"";
        TmfFilterContainsNode containsFilter = new TmfFilterContainsNode(null);
        containsFilter.setEventAspect((ITmfEventAspect)aspect);
        containsFilter.setValue("other");
        Predicate<Map<String, String>> predicate = TmfFilterHelperTest.getRegex((ITmfFilter)containsFilter, expected);
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap2));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap3));
        containsFilter.setNot(true);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)containsFilter, TmfFilterHelperTest.notRegex(expected));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputFilterEquals() {
        @NonNull ITmfEventAspect aspect = TmfBaseAspects.getEventTypeAspect();
        String expected = "\"" + aspect.getName() + "\" " + "==" + " \"" + EVENT_NAME1 + "\"";
        TmfFilterEqualsNode equalsFilter = new TmfFilterEqualsNode(null);
        equalsFilter.setEventAspect(aspect);
        equalsFilter.setValue(EVENT_NAME1);
        Predicate<Map<String, String>> predicate = TmfFilterHelperTest.getRegex((ITmfFilter)equalsFilter, expected);
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap1));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
        equalsFilter.setNot(true);
        expected = "\"" + aspect.getName() + "\" " + "!=" + " \"" + EVENT_NAME1 + "\"";
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)equalsFilter, expected);
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputFilterMatches() {
        @NonNull TmfEventFieldAspect aspect = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        String expected = "\"afield\" matches \".*other.*\"";
        TmfFilterMatchesNode matchesFilter = new TmfFilterMatchesNode(null);
        matchesFilter.setEventAspect((ITmfEventAspect)aspect);
        matchesFilter.setRegex(".*other.*");
        Predicate<Map<String, String>> predicate = TmfFilterHelperTest.getRegex((ITmfFilter)matchesFilter, expected);
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap2));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap3));
        matchesFilter.setNot(true);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)matchesFilter, TmfFilterHelperTest.notRegex(expected));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
        expected = "\"afield\" present";
        matchesFilter.setRegex(".*");
        matchesFilter.setNot(false);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)matchesFilter, expected);
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap1));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap2));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap3));
        matchesFilter.setNot(true);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)matchesFilter, TmfFilterHelperTest.notRegex(expected));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputFilterAnd() {
        @NonNull TmfEventFieldAspect aspectF1 = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        @NonNull TmfEventFieldAspect aspectF2 = TmfBaseAspects.getContentsAspect().forField(FIELD2_NAME);
        String expected = "\"afield\" matches \".*afield.*\" && \"bfield\" present";
        TmfFilterMatchesNode matchesFilter1 = new TmfFilterMatchesNode(null);
        matchesFilter1.setEventAspect((ITmfEventAspect)aspectF1);
        matchesFilter1.setRegex(".*afield.*");
        TmfFilterMatchesNode matchesFilter2 = new TmfFilterMatchesNode(null);
        matchesFilter2.setEventAspect((ITmfEventAspect)aspectF2);
        matchesFilter2.setRegex(".*");
        TmfFilterAndNode andFilter = new TmfFilterAndNode(null);
        andFilter.addChild((ITmfFilterTreeNode)matchesFilter1);
        andFilter.addChild((ITmfFilterTreeNode)matchesFilter2);
        Predicate<Map<String, String>> predicate = TmfFilterHelperTest.getRegex((ITmfFilter)andFilter, expected);
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap2));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap3));
        andFilter.setNot(true);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)andFilter, TmfFilterHelperTest.notRegex(expected));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInputFilterOr() {
        @NonNull TmfEventFieldAspect aspectF1 = TmfBaseAspects.getContentsAspect().forField(FIELD1_NAME);
        @NonNull TmfEventFieldAspect aspectF2 = TmfBaseAspects.getContentsAspect().forField(FIELD2_NAME);
        String expected = "\"afield\" matches \".*afield.*\" || \"bfield\" matches \".*2.*\"";
        TmfFilterMatchesNode matchesFilter1 = new TmfFilterMatchesNode(null);
        matchesFilter1.setEventAspect((ITmfEventAspect)aspectF1);
        matchesFilter1.setRegex(".*afield.*");
        TmfFilterMatchesNode matchesFilter2 = new TmfFilterMatchesNode(null);
        matchesFilter2.setEventAspect((ITmfEventAspect)aspectF2);
        matchesFilter2.setRegex(".*2.*");
        TmfFilterOrNode orFilter = new TmfFilterOrNode(null);
        orFilter.addChild((ITmfFilterTreeNode)matchesFilter1);
        orFilter.addChild((ITmfFilterTreeNode)matchesFilter2);
        Predicate<Map<String, String>> predicate = TmfFilterHelperTest.getRegex((ITmfFilter)orFilter, expected);
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap1));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap2));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap3));
        orFilter.setNot(true);
        predicate = TmfFilterHelperTest.getRegex((ITmfFilter)orFilter, TmfFilterHelperTest.notRegex(expected));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap1));
        Assert.assertTrue((boolean)predicate.test(this.fObjectMap2));
        Assert.assertFalse((boolean)predicate.test(this.fObjectMap3));
    }
}

