/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeLinkEvent;

class StubPresentationProvider
extends TimeGraphPresentationProvider {
    private static final int MARKER_COLOR = new RGBAColor(160, 170, 200, 80).toInt();
    private static final List<StateItem> SYMBOLS = Arrays.asList(new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.symbolStyle(), (Object)"CIRCLE", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR)), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.symbolStyle(), (Object)"SQUARE", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR)), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.symbolStyle(), (Object)"TRIANGLE", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR)), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.symbolStyle(), (Object)"INVERTED_TRIANGLE", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR)), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.symbolStyle(), (Object)"CROSS", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR)), new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.symbolStyle(), (Object)"PLUS", (Object)ITimeEventStyleStrings.fillColor(), (Object)MARKER_COLOR)));
    private static final StateItem LASER = new StateItem((Map)ImmutableMap.of((Object)ITimeEventStyleStrings.label(), (Object)"\"LASER\"", (Object)ITimeEventStyleStrings.heightFactor(), (Object)Float.valueOf(0.1f), (Object)ITimeEventStyleStrings.fillColor(), (Object)-16776961));
    public static final StateItem[] STATES = new StateItem[]{new StateItem(new RGB(0, 255, 0), "HAT"), new StateItem(new RGB(128, 192, 255), "SKIN"), new StateItem(new RGB(0, 64, 128), "HAIR"), new StateItem(new RGB(0, 0, 255), "EYE"), new StateItem(new RGB(255, 64, 128), "PUCK"), LASER};

    StubPresentationProvider() {
    }

    public String getPreferenceKey() {
        return "Stub";
    }

    public StateItem[] getStateTable() {
        return STATES;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeLinkEvent) {
            return 5;
        }
        if (event instanceof TimeEvent) {
            return ((TimeEvent)event).getValue();
        }
        return -1;
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        if (event instanceof MarkerEvent && event.getDuration() == 0L) {
            MarkerEvent markerEvent = (MarkerEvent)event;
            int value = markerEvent.getValue();
            StateItem sym = SYMBOLS.get(value);
            HashMap<String, Object> ret = new HashMap<String, Object>(super.getSpecificEventStyle(event));
            ret.putAll(sym.getStyleMap());
            return ret;
        }
        return super.getSpecificEventStyle(event);
    }
}

