/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphColorListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider2;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITmfTimeGraphDrawingHelper;

public class TimeGraphPresentationProvider
implements ITimeGraphPresentationProvider2 {
    private static final StateItem[] EMPTY_STATE_TABLE = new StateItem[0];
    private ITmfTimeGraphDrawingHelper fDrawingHelper;
    private final String fStateTypeName;
    private final List<ITimeGraphColorListener> fListeners = new ArrayList<ITimeGraphColorListener>();
    private static final int DEFAULT_ITEM_HEIGHT = 19;

    public TimeGraphPresentationProvider(String stateTypeName) {
        this.fStateTypeName = stateTypeName;
    }

    public TimeGraphPresentationProvider() {
        this(Messages.TmfTimeLegend_TRACE_STATES);
    }

    @Override
    public String getStateTypeName() {
        return this.fStateTypeName;
    }

    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        return null;
    }

    @Override
    public StateItem[] getStateTable() {
        return EMPTY_STATE_TABLE;
    }

    @Override
    public int getStateTableIndex(ITimeEvent event) {
        return 0;
    }

    @Override
    public ITmfTimeGraphDrawingHelper getDrawingHelper() {
        return this.fDrawingHelper;
    }

    @Override
    public void setDrawingHelper(ITmfTimeGraphDrawingHelper helper) {
        this.fDrawingHelper = helper;
    }

    @Override
    public void postDrawControl(Rectangle bounds, GC gc) {
    }

    @Override
    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
    }

    @Override
    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
    }

    @Override
    public int getItemHeight(ITimeGraphEntry entry) {
        return 19;
    }

    @Override
    public Image getItemImage(ITimeGraphEntry entry) {
        return null;
    }

    @Override
    public String getEventName(ITimeEvent event) {
        return null;
    }

    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        return null;
    }

    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        return this.getEventHoverToolTipInfo(event);
    }

    @Override
    public boolean displayTimesInTooltip() {
        return true;
    }

    @Override
    public void addColorListener(ITimeGraphColorListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    @Override
    public void removeColorListener(ITimeGraphColorListener listener) {
        this.fListeners.remove(listener);
    }

    protected void fireColorSettingsChanged() {
        this.refresh();
    }

    @Override
    public void refresh() {
        for (ITimeGraphColorListener listener : this.fListeners) {
            listener.colorSettingsChanged(this.getStateTable());
        }
    }
}

