/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter.parser;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.tmf.core.tests.filter.parser.ElementResolverStub;
import org.junit.Assert;
import org.junit.Test;

public class ElementResolverFilterTest {
    private static final ElementResolverStub ELEMENT = new ElementResolverStub((Map<String, String>)ImmutableMap.of((Object)"label", (Object)"elementLabel", (Object)"key0", (Object)"value0", (Object)"key1", (Object)"value1", (Object)"key 2", (Object)"value2", (Object)"key3", (Object)"10"));

    @Test
    public void testRegex() {
        FilterCu cu = FilterCu.compile((String)"Label");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"0$");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"a.*l");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"y$");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testLogicalOperator() {
        FilterCu cu = FilterCu.compile((String)"Label && value");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label && fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"Label || absent");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"absent || fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testEqualsOperator() {
        FilterCu cu = FilterCu.compile((String)"label == elementLabel");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label == fail");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testNotEqualsOperator() {
        FilterCu cu = FilterCu.compile((String)"label != fail");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label != elementLabel");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testNotOperator() {
        FilterCu cu = FilterCu.compile((String)"!fail");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"!elementLabel");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testContainsOperator() {
        FilterCu cu = FilterCu.compile((String)"label contains element");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"label contains value");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testPresentOperator() {
        FilterCu cu = FilterCu.compile((String)"key1 present");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"invalidKey present");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testMatchesOperator() {
        FilterCu cu = FilterCu.compile((String)"key1 matches v.*ue");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"key1 matches v.*ue$");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)" \"key 2\" matches value2");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testGreaterThanOperator() {
        FilterCu cu = FilterCu.compile((String)"key3 > 9");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"key3 > 10");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testLessThanOperator() {
        FilterCu cu = FilterCu.compile((String)"key3 < 11");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"key3 < 10");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testComplexFilter() {
        FilterCu cu = FilterCu.compile((String)"(key1 matches v.*ue) && Label");
        Assert.assertNotNull((Object)cu);
        Predicate predicate = cu.generate();
        Assert.assertTrue((boolean)predicate.test(ELEMENT.computeData()));
        cu = FilterCu.compile((String)"!(key1 matches v.*ue) && Label");
        Assert.assertNotNull((Object)cu);
        predicate = cu.generate();
        Assert.assertFalse((boolean)predicate.test(ELEMENT.computeData()));
    }

    @Test
    public void testInvalid() {
        FilterCu cu = FilterCu.compile((String)"label = elementLabel");
        Assert.assertNull((Object)cu);
    }
}

