/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.sorters.SkeletonViewerSorter;

public class CommonSorterDescriptor
implements INavigatorContentExtPtConstants {
    private IConfigurationElement element;
    private Expression parentExpression;
    private String id;

    protected CommonSorterDescriptor(IConfigurationElement anElement) {
        this.element = anElement;
        this.init();
    }

    private void init() {
        IConfigurationElement[] children;
        this.id = this.element.getAttribute("id");
        if (this.id == null) {
            this.id = "";
        }
        if ((children = this.element.getChildren("parentExpression")).length == 1) {
            this.parentExpression = new CustomAndExpression(children[0]);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabledForParent(Object aParent) {
        if (aParent == null) {
            return false;
        }
        if (this.parentExpression != null) {
            IEvaluationContext context = NavigatorPlugin.getEvalContext(aParent);
            return NavigatorPlugin.safeEvaluate(this.parentExpression, context) == EvaluationResult.TRUE;
        }
        return true;
    }

    public ViewerSorter createSorter() {
        final ViewerSorter[] sorter = new ViewerSorter[1];
        SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(this.element){

            @Override
            public void run() throws Exception {
                sorter[0] = (ViewerSorter)CommonSorterDescriptor.this.element.createExecutableExtension("class");
            }
        });
        if (sorter[0] != null) {
            return sorter[0];
        }
        return SkeletonViewerSorter.INSTANCE;
    }

    public String toString() {
        return "CommonSorterDescriptor[" + this.getId() + "]";
    }
}

