/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class NavigatorDecoratingLabelProvider
extends DecoratingStyledCellLabelProvider
implements IPropertyChangeListener,
ILabelProvider,
ITableLabelProvider {
    public NavigatorDecoratingLabelProvider(ILabelProvider commonLabelProvider) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StyledLabelProviderAdapter(commonLabelProvider), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        this.setOwnerDrawEnabled(NavigatorDecoratingLabelProvider.showColoredLabels());
        super.initialize(viewer, column);
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
    }

    private void refresh() {
        ColumnViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        boolean showColoredLabels = NavigatorDecoratingLabelProvider.showColoredLabels();
        if (showColoredLabels != this.isOwnerDrawEnabled()) {
            this.setOwnerDrawEnabled(showColoredLabels);
            viewer.refresh();
        } else if (showColoredLabels) {
            viewer.refresh();
        }
    }

    private static boolean showColoredLabels() {
        return PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS");
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("QUALIFIER_COLOR") || property.equals("COUNTER_COLOR") || property.equals("DECORATIONS_COLOR") || property.equals("USE_COLORED_LABELS")) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NavigatorDecoratingLabelProvider.this.refresh();
                }
            });
        }
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return ((StyledLabelProviderAdapter)this.getStyledStringProvider()).getColumnImage(element, columnIndex);
    }

    public String getColumnText(Object element, int columnIndex) {
        return ((StyledLabelProviderAdapter)this.getStyledStringProvider()).getColumnText(element, columnIndex);
    }

    private static class StyledLabelProviderAdapter
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        private final ILabelProvider provider;

        public StyledLabelProviderAdapter(ILabelProvider provider) {
            this.provider = provider;
        }

        public Image getImage(Object element) {
            return this.provider.getImage(element);
        }

        public StyledString getStyledText(Object element) {
            if (this.provider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                return ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.provider).getStyledText(element);
            }
            String text = this.provider.getText(element);
            if (text == null) {
                text = "";
            }
            return new StyledString(text);
        }

        public void addListener(ILabelProviderListener listener) {
            this.provider.addListener(listener);
        }

        public void dispose() {
            this.provider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.provider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.provider.removeListener(listener);
        }

        public Color getBackground(Object element) {
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getBackground(element);
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getForeground(element);
            }
            return null;
        }

        public Font getFont(Object element) {
            if (this.provider instanceof IFontProvider) {
                return ((IFontProvider)this.provider).getFont(element);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (this.provider instanceof ITableLabelProvider) {
                return ((ITableLabelProvider)this.provider).getColumnImage(element, columnIndex);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (this.provider instanceof ITableLabelProvider) {
                return ((ITableLabelProvider)this.provider).getColumnText(element, columnIndex);
            }
            return null;
        }
    }
}

