/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer.TestDirectoryStructureUtil;
import org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer.TestTraceInfo;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTracesFolder;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.SWTBotImportWizardUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IEditorReference;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

@RunWith(value=SWTBotJunit4ClassRunner.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ProjectExplorerTracesFolderTest {
    private static final String PROP_LAST_MODIFIED_PROPERTY = "last modified";
    private static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final String GENERIC_CTF_TRACE_TYPE = "Common Trace Format : Generic CTF Trace";
    private static final String LTTNG_KERNEL_TRACE_TYPE = "Common Trace Format : Linux Kernel Trace";
    private static final String LTTNG_UST_TRACE_TYPE = "Common Trace Format : LTTng UST Trace";
    private static final String CUSTOM_TEXT_TRACE_TYPE = "Custom Text : TmfGeneric";
    private static final String CUSTOM_XML_TRACE_TYPE = "Custom XML : Custom XML Log";
    private static final @NonNull TestTraceInfo CUSTOM_TEXT_LOG = new TestTraceInfo("ExampleCustomTxt.log", "Custom Text : TmfGeneric", 10L, "29:52.034");
    private static final @NonNull TestTraceInfo CUSTOM_XML_LOG = new TestTraceInfo("ExampleCustomXml.xml", "Custom XML : Custom XML Log", 6L, "22:01:20");
    private static final @NonNull TestTraceInfo LTTNG_KERNEL_TRACE = new TestTraceInfo("kernel-overlap-testing", "Common Trace Format : Linux Kernel Trace", 1000L, "04:32.650 993 664");
    private static final @NonNull TestTraceInfo SIMPLE_SERVER1_UST_TRACE = new TestTraceInfo("simple_server-thread1", "Common Trace Format : LTTng UST Trace", 1000L, "04:32.650 993 664");
    private static final @NonNull TestTraceInfo SIMPLE_SERVER2_UST_TRACE = new TestTraceInfo("simple_server-thread2", "Common Trace Format : LTTng UST Trace", 1000L, "04:32.650 993 664");
    private static final @NonNull TestTraceInfo UST_OVERLAP_TESTING_UST_TRACE = new TestTraceInfo("ust-overlap-testing", "Common Trace Format : LTTng UST Trace", 1000L, "04:32.650 993 664");
    private static final String CLASHES_DIR_NAME = "z-clashes";
    private static final @NonNull TestTraceInfo CLASHES_CUSTOM_TEXT_LOG = new TestTraceInfo("ExampleCustomTxt.log", "z-clashes/ExampleCustomTxt.log", "Custom Text : TmfGeneric", 11L, "29:52.034");
    private static final @NonNull TestTraceInfo CLASHES_CUSTOM_XML_LOG = new TestTraceInfo("ExampleCustomXml.xml", "z-clashes/ExampleCustomXml.xml", "Custom XML : Custom XML Log", 7L, "22:01:20");
    private static final @NonNull TestTraceInfo CLASHES_LTTNG_KERNEL_TRACE = new TestTraceInfo("kernel-overlap-testing", "z-clashes/kernel-overlap-testing", "Common Trace Format : Linux Kernel Trace", 1001L, "04:32.650 993 664");
    private static final @NonNull TestTraceInfo CLASHES_SIMPLE_SERVER1_UST_TRACE = new TestTraceInfo("simple_server-thread1", "z-clashes/simple_server-thread1", "Common Trace Format : LTTng UST Trace", 1001L, "04:32.650 993 664");
    private static final @NonNull TestTraceInfo CLASHES_SIMPLE_SERVER2_UST_TRACE = new TestTraceInfo("simple_server-thread2", "z-clashes/simple_server-thread2", "Common Trace Format : LTTng UST Trace", 1001L, "04:32.650 993 664");
    private static final @NonNull TestTraceInfo CLASHES_UST_OVERLAP_TESTING_UST_TRACE = new TestTraceInfo("ust-overlap-testing", "z-clashes/ust-overlap-testing", "Common Trace Format : LTTng UST Trace", 1001L, "04:32.650 993 664");
    private static final @NonNull TestTraceInfo LTTNG_KERNEL_TRACE_METADATA = new TestTraceInfo(LTTNG_KERNEL_TRACE.getTraceName(), String.valueOf(LTTNG_KERNEL_TRACE.getTraceName()) + "/metadata", LTTNG_KERNEL_TRACE.getTraceType(), LTTNG_KERNEL_TRACE.getNbEvents(), LTTNG_KERNEL_TRACE.getFirstEventTimestamp());
    private static final @NonNull TestTraceInfo UNRECOGNIZED_LOG = new TestTraceInfo("unrecognized.log", "", 0L, "");
    private static final @NonNull TestTraceInfo CUSTOM_XML_LOG_AS_TEXT = new TestTraceInfo("ExampleCustomXml.xml", "Custom Text : TmfGeneric", 0L, "");
    private static final @NonNull TestTraceInfo CLASHES_CUSTOM_XML_LOG_AS_TEXT = new TestTraceInfo("ExampleCustomXml.xml", "z-clashes/ExampleCustomXml.xml", "Custom Text : TmfGeneric", 0L, "");
    private static final TestTraceInfo[] ALL_TRACEINFOS = new TestTraceInfo[]{CUSTOM_TEXT_LOG, CUSTOM_XML_LOG, LTTNG_KERNEL_TRACE, SIMPLE_SERVER1_UST_TRACE, SIMPLE_SERVER2_UST_TRACE, UST_OVERLAP_TESTING_UST_TRACE, CLASHES_CUSTOM_TEXT_LOG, CLASHES_CUSTOM_XML_LOG, CLASHES_LTTNG_KERNEL_TRACE, CLASHES_SIMPLE_SERVER1_UST_TRACE, CLASHES_SIMPLE_SERVER2_UST_TRACE, CLASHES_UST_OVERLAP_TESTING_UST_TRACE};
    private static final Set<TestTraceInfo> CLASHING_TRACEINFOS = ImmutableSet.of((Object)CLASHES_CUSTOM_TEXT_LOG, (Object)CLASHES_CUSTOM_XML_LOG, (Object)CLASHES_LTTNG_KERNEL_TRACE, (Object)CLASHES_SIMPLE_SERVER1_UST_TRACE, (Object)CLASHES_SIMPLE_SERVER2_UST_TRACE, (Object)CLASHES_UST_OVERLAP_TESTING_UST_TRACE, (Object[])new TestTraceInfo[0]);
    private static final int NUM_UNIQUE_TRACES = CLASHING_TRACEINFOS.size() + 1;
    private static final File TEST_TRACES_PATH = new File(new Path(TmfTraceManager.getTemporaryDirPath()).append("testtraces").toOSString());
    private static final String DEFAULT_PROJECT_NAME = "Tracing";
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String MANAGE_CUSTOM_PARSERS_SHELL_TITLE = "Manage Custom Parsers";
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;
    private static final long DISK_ACCESS_TIMEOUT = 120000L;

    static {
        fLogger = Logger.getRootLogger();
    }

    private static String getPath(String relativePath) {
        return new Path(TEST_TRACES_PATH.getAbsolutePath()).append(relativePath).toOSString();
    }

    @BeforeClass
    public static void init() throws IOException {
        TestDirectoryStructureUtil.generateTraceStructure(TEST_TRACES_PATH);
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        ProjectExplorerTracesFolderTest.importCustomParsers();
    }

    @AfterClass
    public static void tearDown() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        SWTBotUtils.deleteProject((String)DEFAULT_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    @After
    public void afterTest() {
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    private static void importCustomParsers() {
        CustomTxtTraceDefinition[] txtDefinitions = CustomTxtTraceDefinition.loadAll((String)ProjectExplorerTracesFolderTest.getPath("customParsers/ExampleCustomTxtParser.xml"));
        txtDefinitions[0].save();
        CustomXmlTraceDefinition[] xmlDefinitions = CustomXmlTraceDefinition.loadAll((String)ProjectExplorerTracesFolderTest.getPath("customParsers/ExampleCustomXmlParser.xml"));
        xmlDefinitions[0].save();
        SWTBotTreeItem traceFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        traceFolder.contextMenu("Manage Custom Parsers...").click();
        SWTBotShell shell = fBot.shell(MANAGE_CUSTOM_PARSERS_SHELL_TITLE).activate();
        SWTBot shellBot = shell.bot();
        shellBot.list().select(CUSTOM_TEXT_LOG.getTraceType());
        shellBot.radio("XML").click();
        shellBot.list().select(CUSTOM_XML_LOG.getTraceType());
        shellBot.button("Close").click();
        shellBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 120000L);
    }

    @Test
    public void test3_01ContextMenuPresence() {
        SWTBotTreeItem traceItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        ImmutableList EXPECTED_MENU_LABELS = ImmutableList.of((Object)"Open Trace...", (Object)"Open As Experiment...", (Object)"", (Object)"Import...", (Object)"", (Object)"New Folder...", (Object)"Clear", (Object)"", (Object)"Import Trace Package...", (Object)"Fetch Remote Traces...", (Object)"", (Object)"Export Trace Package...", (Object[])new String[]{"", "Manage Custom Parsers...", "Manage XML analyses...", "", "Apply Time Offset...", "Clear Time Offset", "", "Refresh"});
        List menuLabels = traceItem.contextMenu().menuItems();
        int i = 0;
        while (i < menuLabels.size()) {
            Assert.assertEquals(EXPECTED_MENU_LABELS.get(i), menuLabels.get(i));
            ++i;
        }
        fBot.closeAllEditors();
    }

    @Test
    public void test3_02Import() {
        SWTBotTreeItem traceItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotShell shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(traceItem);
        shell.bot().button("Cancel").click();
    }

    @Test
    public void test3_03SingleCustomTextTrace() {
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.testSingleTrace(CUSTOM_TEXT_LOG, optionFlags);
    }

    @Test
    public void test3_04SingleCustomXmlTrace() {
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.testSingleTrace(CUSTOM_XML_LOG, optionFlags);
    }

    @Test
    public void test3_05SingleCtfTrace() {
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.testSingleTrace(LTTNG_KERNEL_TRACE, optionFlags);
    }

    @Test
    public void test3_06RenameCopyImport() {
        ProjectExplorerTracesFolderTest.testRenameCopyImport(CUSTOM_TEXT_LOG);
        ProjectExplorerTracesFolderTest.testRenameCopyImport(CUSTOM_XML_LOG);
        ProjectExplorerTracesFolderTest.testRenameCopyImport(LTTNG_KERNEL_TRACE);
    }

    private static void testRenameCopyImport(TestTraceInfo traceInfo) {
        int optionFlags = 8;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.RENAME, traceInfo.getTraceName());
        String renamed = ProjectExplorerTracesFolderTest.toRenamedName(traceInfo.getTraceName());
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, optionFlags, renamed);
    }

    @Test
    public void test3_07OverwriteCopyImport() {
        ProjectExplorerTracesFolderTest.testOverwriteCopyImport(CUSTOM_TEXT_LOG);
        ProjectExplorerTracesFolderTest.testOverwriteCopyImport(CUSTOM_XML_LOG);
        ProjectExplorerTracesFolderTest.testOverwriteCopyImport(LTTNG_KERNEL_TRACE);
    }

    private static void testOverwriteCopyImport(TestTraceInfo traceInfo) {
        String traceName = traceInfo.getTraceName();
        SWTBotTreeItem traceItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String[])new String[]{traceName});
        String lastModified = ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY);
        int optionFlags = 8;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.OVERWRITE, traceName);
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, optionFlags);
        Assert.assertNotEquals((Object)lastModified, (Object)ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY));
    }

    @Test
    public void test3_08SkipImport() {
        ProjectExplorerTracesFolderTest.testSkipImport(CUSTOM_TEXT_LOG);
        ProjectExplorerTracesFolderTest.testSkipImport(CUSTOM_XML_LOG);
        ProjectExplorerTracesFolderTest.testSkipImport(LTTNG_KERNEL_TRACE);
    }

    private static void testSkipImport(TestTraceInfo traceInfo) {
        String traceName = traceInfo.getTraceName();
        SWTBotTreeItem traceItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String[])new String[]{traceName});
        String lastModified = ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY);
        int optionFlags = 8;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.SKIP, traceName);
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, optionFlags);
        Assert.assertEquals((Object)lastModified, (Object)ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY));
    }

    @Test
    public void test3_09OverwriteOptionImport() {
        ProjectExplorerTracesFolderTest.testOverwriteOptionImport(CUSTOM_TEXT_LOG);
        ProjectExplorerTracesFolderTest.testOverwriteOptionImport(CUSTOM_XML_LOG);
        ProjectExplorerTracesFolderTest.testOverwriteOptionImport(LTTNG_KERNEL_TRACE);
    }

    private static void testOverwriteOptionImport(TestTraceInfo traceInfo) {
        String traceName = traceInfo.getTraceName();
        SWTBotTreeItem traceItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String[])new String[]{traceName});
        String lastModified = ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY);
        int optionFlags = 24;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.CONTINUE, traceName);
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, optionFlags);
        Assert.assertNotEquals((Object)lastModified, (Object)ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY));
    }

    @Test
    public void test3_10ImportUnrecognized() {
        String traceName = UNRECOGNIZED_LOG.getTraceName();
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, traceName);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags);
    }

    @Test
    public void test3_11ImportUnrecognizedIgnore() {
        String traceName = UNRECOGNIZED_LOG.getTraceName();
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int numTraces = tracesFolderItem.getItems().length;
        SWTBotTreeItem traceItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String[])new String[]{traceName});
        String lastModified = ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY);
        int optionFlags = 4;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, traceName);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags);
        Assert.assertEquals((Object)lastModified, (Object)ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, PROP_LAST_MODIFIED_PROPERTY));
        Assert.assertEquals((long)numTraces, (long)tracesFolderItem.getItems().length);
    }

    @Test
    public void test3_12ImportCtfWithMetadataSelection() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        ProjectExplorerTracesFolderTest.testSingleTrace(LTTNG_KERNEL_TRACE_METADATA, 12);
    }

    @Test
    public void test3_13ImportRecursiveAutoRenameAll() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.RENAME_ALL, "");
        TestTraceInfo[] testTraceInfoArray = ALL_TRACEINFOS;
        int n = ALL_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            String traceName = info.getTraceName();
            if (CLASHING_TRACEINFOS.contains(info)) {
                traceName = ProjectExplorerTracesFolderTest.toRenamedName(traceName);
            }
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags, traceName);
            ++n2;
        }
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags);
    }

    @Test
    public void test3_14ImportRecursiveAutoOverwriteAll() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.OVERWRITE_ALL, "");
        for (TestTraceInfo info : CLASHING_TRACEINFOS) {
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags);
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)NUM_UNIQUE_TRACES, (long)tracesFolderItem.getItems().length);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags);
    }

    @Test
    public void test3_15ImportRecursiveAutoSkipAll() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.SKIP_ALL, "");
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        TestTraceInfo[] testTraceInfoArray = ALL_TRACEINFOS;
        int n = ALL_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            if (!CLASHING_TRACEINFOS.contains(info)) {
                ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags);
            }
            ++n2;
        }
        Assert.assertEquals((long)NUM_UNIQUE_TRACES, (long)tracesFolderItem.getItems().length);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags);
    }

    @Test
    public void test3_16ImportRecursiveAutoRenameOverwriteSkip() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        ImportConfirmationSupplier confirmationSupplier = new ImportConfirmationSupplier(ImportConfirmation.RENAME, ImportConfirmation.OVERWRITE, ImportConfirmation.SKIP);
        int optionFlags = 12;
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, confirmationSupplier, LTTNG_KERNEL_TRACE.getTracePath(), CLASHES_LTTNG_KERNEL_TRACE.getTracePath(), SIMPLE_SERVER1_UST_TRACE.getTracePath(), CLASHES_SIMPLE_SERVER1_UST_TRACE.getTracePath(), SIMPLE_SERVER2_UST_TRACE.getTracePath(), CLASHES_SIMPLE_SERVER2_UST_TRACE.getTracePath(), UNRECOGNIZED_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags);
        String renamed = ProjectExplorerTracesFolderTest.toRenamedName(CLASHES_LTTNG_KERNEL_TRACE.getTraceName());
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_LTTNG_KERNEL_TRACE, optionFlags, renamed);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_SIMPLE_SERVER1_UST_TRACE, optionFlags);
        ProjectExplorerTracesFolderTest.verifyTrace(SIMPLE_SERVER2_UST_TRACE, optionFlags);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags);
    }

    @Test
    public void test3_17ImportRecursiveSpecifyTraceTypeCTF() {
        TestTraceInfo[] CTF_TRACEINFOS;
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 4;
        ProjectExplorerTracesFolderTest.importTrace(GENERIC_CTF_TRACE_TYPE, optionFlags, ImportConfirmation.SKIP_ALL, "");
        TestTraceInfo[] testTraceInfoArray = CTF_TRACEINFOS = new TestTraceInfo[]{LTTNG_KERNEL_TRACE, SIMPLE_SERVER1_UST_TRACE, SIMPLE_SERVER2_UST_TRACE, UST_OVERLAP_TESTING_UST_TRACE};
        int n = CTF_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags, info.getTraceName(), GENERIC_CTF_TRACE_TYPE);
            ++n2;
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)CTF_TRACEINFOS.length, (long)tracesFolderItem.getItems().length);
    }

    @Test
    public void test3_18ImportRecursiveSpecifyTraceTypeKernel() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 4;
        ProjectExplorerTracesFolderTest.importTrace(LTTNG_KERNEL_TRACE_TYPE, optionFlags, ImportConfirmation.SKIP_ALL, "");
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags);
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)1L, (long)tracesFolderItem.getItems().length);
    }

    @Test
    public void test3_19ImportRecursiveSpecifyTraceTypeUST() {
        TestTraceInfo[] UST_TRACEINFOS;
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 4;
        ProjectExplorerTracesFolderTest.importTrace(LTTNG_UST_TRACE_TYPE, optionFlags, ImportConfirmation.SKIP_ALL, "");
        TestTraceInfo[] testTraceInfoArray = UST_TRACEINFOS = new TestTraceInfo[]{SIMPLE_SERVER1_UST_TRACE, SIMPLE_SERVER2_UST_TRACE, UST_OVERLAP_TESTING_UST_TRACE};
        int n = UST_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags);
            ++n2;
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)UST_TRACEINFOS.length, (long)tracesFolderItem.getItems().length);
    }

    @Test
    public void test3_20ImportRecursiveSpecifyTraceTypeCustomText() {
        TestTraceInfo[] TEXT_BASED_TRACEINFOS;
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 4;
        ProjectExplorerTracesFolderTest.importTrace(CUSTOM_TEXT_TRACE_TYPE, optionFlags, ImportConfirmation.SKIP_ALL, "");
        TestTraceInfo[] testTraceInfoArray = TEXT_BASED_TRACEINFOS = new TestTraceInfo[]{CUSTOM_TEXT_LOG, CUSTOM_XML_LOG_AS_TEXT, UNRECOGNIZED_LOG};
        int n = TEXT_BASED_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags, info.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
            ++n2;
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)TEXT_BASED_TRACEINFOS.length, (long)tracesFolderItem.getItems().length);
    }

    @Test
    public void test3_21ImportFromMenuProjectSelected() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotShell shell = ProjectExplorerTracesFolderTest.openWorkbenchMenuImport();
        int optionFlags = 4;
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), CUSTOM_TEXT_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags);
    }

    @Test
    public void test3_22ImportFromMenuProjectNotSelected() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotView projectExplorerBot = fBot.viewByTitle("Project Explorer");
        projectExplorerBot.show();
        projectExplorerBot.bot().waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)projectExplorerBot.bot().tree()));
        projectExplorerBot.bot().tree().unselect();
        SWTBotShell shell = ProjectExplorerTracesFolderTest.openWorkbenchMenuImport();
        int optionFlags = 4;
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), CUSTOM_TEXT_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_LOG.getTraceType(), DEFAULT_PROJECT_NAME);
        SWTBotUtils.deleteProject((String)DEFAULT_PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @Test
    public void test3_29ImportRecursivePreserve() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 6;
        ProjectExplorerTracesFolderTest.importTrace(CUSTOM_TEXT_TRACE_TYPE, optionFlags, ImportConfirmation.CONTINUE, "");
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_XML_LOG_AS_TEXT, optionFlags, CUSTOM_XML_LOG_AS_TEXT.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags, UNRECOGNIZED_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_TEXT_LOG, optionFlags, CLASHES_CUSTOM_TEXT_LOG.getTracePath(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_XML_LOG_AS_TEXT, optionFlags, CLASHES_CUSTOM_XML_LOG_AS_TEXT.getTracePath(), CUSTOM_TEXT_TRACE_TYPE);
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)4L, (long)tracesFolderItem.getItems().length);
        SWTBotTreeItem clashesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)CLASHES_DIR_NAME);
        Assert.assertEquals((long)2L, (long)clashesFolderItem.getItems().length);
    }

    @Test
    public void test3_30ImportRecursivePreserveSkipAll() {
        int optionFlags = 6;
        ProjectExplorerTracesFolderTest.importTrace(CUSTOM_TEXT_TRACE_TYPE, optionFlags, ImportConfirmation.SKIP_ALL, "");
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_XML_LOG_AS_TEXT, optionFlags, CUSTOM_XML_LOG_AS_TEXT.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags, UNRECOGNIZED_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_TEXT_LOG, optionFlags, CLASHES_CUSTOM_TEXT_LOG.getTracePath(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_XML_LOG_AS_TEXT, optionFlags, CLASHES_CUSTOM_XML_LOG_AS_TEXT.getTracePath(), CUSTOM_TEXT_TRACE_TYPE);
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)4L, (long)tracesFolderItem.getItems().length);
        SWTBotTreeItem clashesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)CLASHES_DIR_NAME);
        Assert.assertEquals((long)2L, (long)clashesFolderItem.getItems().length);
    }

    @Test
    public void test3_31ImportRecursivePreserveRenameAll() {
        int optionFlags = 6;
        ProjectExplorerTracesFolderTest.importTrace(CUSTOM_TEXT_TRACE_TYPE, optionFlags, ImportConfirmation.RENAME_ALL, "");
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, ProjectExplorerTracesFolderTest.toRenamedName(CUSTOM_TEXT_LOG.getTraceName()), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_XML_LOG_AS_TEXT, optionFlags, ProjectExplorerTracesFolderTest.toRenamedName(CUSTOM_XML_LOG_AS_TEXT.getTraceName()), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(UNRECOGNIZED_LOG, optionFlags, ProjectExplorerTracesFolderTest.toRenamedName(UNRECOGNIZED_LOG.getTraceName()), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_TEXT_LOG, optionFlags, ProjectExplorerTracesFolderTest.toRenamedName(CLASHES_CUSTOM_TEXT_LOG.getTracePath()), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_XML_LOG_AS_TEXT, optionFlags, ProjectExplorerTracesFolderTest.toRenamedName(CLASHES_CUSTOM_XML_LOG_AS_TEXT.getTracePath()), CUSTOM_TEXT_TRACE_TYPE);
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)7L, (long)tracesFolderItem.getItems().length);
        SWTBotTreeItem clashesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)CLASHES_DIR_NAME);
        Assert.assertEquals((long)4L, (long)clashesFolderItem.getItems().length);
    }

    @Test
    public void test3_32DeleteTraceAndFolder() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        tracesFolder.contextMenu().menu(new String[]{"New Folder..."}).click();
        SWTBot newFolderShellBot = fBot.shell("New Folder").bot();
        newFolderShellBot.text().setText("FolderA");
        newFolderShellBot.button("OK").click();
        tracesFolder.contextMenu().menu(new String[]{"New Folder..."}).click();
        newFolderShellBot = fBot.shell("New Folder").bot();
        newFolderShellBot.text().setText("FolderB");
        newFolderShellBot.button("OK").click();
        int optionFlags = 4;
        SWTBotTreeItem traceFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderA");
        SWTBotShell shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(traceFolder);
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), CUSTOM_TEXT_LOG.getTracePath(), LTTNG_KERNEL_TRACE.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, "FolderA/" + CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags, "FolderA/" + LTTNG_KERNEL_TRACE.getTraceName(), LTTNG_KERNEL_TRACE_TYPE);
        traceFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderB");
        shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(traceFolder);
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), CUSTOM_TEXT_LOG.getTracePath(), LTTNG_KERNEL_TRACE.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, "FolderB/" + CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags, "FolderB/" + LTTNG_KERNEL_TRACE.getTraceName(), LTTNG_KERNEL_TRACE_TYPE);
        SWTBotTree tree = fBot.viewByTitle("Project Explorer").bot().tree();
        SWTBotTreeItem folderAItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderA");
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)folderAItem, (String)CUSTOM_TEXT_LOG.getTraceName());
        SWTBotTreeItem folderBItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderB");
        tree.select(new SWTBotTreeItem[]{traceItem, folderBItem});
        tree.contextMenu().menu(new String[]{"Delete"}).click();
        SWTBot deleteConfirmationShellBot = fBot.shell("Confirm Delete").bot();
        deleteConfirmationShellBot.button("Yes").click();
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)("FolderA/" + CUSTOM_TEXT_LOG.getTraceName())));
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)("FolderB/" + CUSTOM_TEXT_LOG.getTraceName())));
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)("FolderB/" + LTTNG_KERNEL_TRACE.getTraceName())));
        fBot.waitUntil(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)("FolderA/" + LTTNG_KERNEL_TRACE.getTraceName())));
        SWTBotUtils.waitUntil(folder -> folder.getNodes().size() == 1, (Object)tracesFolder, (String)"Traces folder not empty");
        SWTBotUtils.waitUntil(folder -> folder.getNodes().size() == 1, (Object)folderAItem, (String)"Traces folder (folderAItem) not empty");
    }

    @Test
    public void test3_33DeleteMultipleFolders() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        tracesFolder.contextMenu().menu(new String[]{"New Folder..."}).click();
        SWTBot newFolderShellBot = fBot.shell("New Folder").bot();
        newFolderShellBot.text().setText("FolderA");
        newFolderShellBot.button("OK").click();
        tracesFolder.contextMenu().menu(new String[]{"New Folder..."}).click();
        newFolderShellBot = fBot.shell("New Folder").bot();
        newFolderShellBot.text().setText("FolderB");
        newFolderShellBot.button("OK").click();
        int optionFlags = 4;
        SWTBotTreeItem traceFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderA");
        SWTBotShell shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(traceFolder);
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), CUSTOM_TEXT_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, "FolderA/" + CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        traceFolder = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderB");
        shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(traceFolder);
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), LTTNG_KERNEL_TRACE.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags, "FolderB/" + LTTNG_KERNEL_TRACE.getTraceName(), LTTNG_KERNEL_TRACE_TYPE);
        SWTBotTree tree = fBot.viewByTitle("Project Explorer").bot().tree();
        SWTBotTreeItem folderAItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderA");
        SWTBotTreeItem folderBItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolder, (String)"FolderB");
        tree.select(new SWTBotTreeItem[]{folderAItem, folderBItem});
        tree.contextMenu().menu(new String[]{"Delete"}).click();
        SWTBot deleteConfirmationShellBot = fBot.shell("Confirm Delete").bot();
        deleteConfirmationShellBot.button("Yes").click();
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)("FolderA/" + CUSTOM_TEXT_LOG.getTraceName())));
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)("FolderB/" + LTTNG_KERNEL_TRACE.getTraceName())));
        SWTBotUtils.waitUntil(folder -> folder.getNodes().isEmpty(), (Object)tracesFolder, (String)"Traces folder not empty");
    }

    @Test
    public void test3_34ClearSingleTracesFolder() {
        int optionFlags = 6;
        ProjectExplorerTracesFolderTest.importTrace(CUSTOM_TEXT_TRACE_TYPE, optionFlags, ImportConfirmation.CONTINUE, CUSTOM_TEXT_LOG.getTraceName(), CLASHES_CUSTOM_TEXT_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE);
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_TEXT_LOG, optionFlags, CLASHES_CUSTOM_TEXT_LOG.getTracePath(), CUSTOM_TEXT_TRACE_TYPE);
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        tracesFolder.contextMenu().menu(new String[]{"Clear"}).click();
        SWTBot deleteConfirmationShellBot = fBot.shell("Confirm Clear").bot();
        deleteConfirmationShellBot.button("Yes").click();
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)CUSTOM_TEXT_LOG.getTraceName()));
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)CLASHES_CUSTOM_TEXT_LOG.getTracePath()));
        SWTBotUtils.waitUntil(folder -> folder.getNodes().size() == 0, (Object)tracesFolder, (String)"Traces folder not empty");
    }

    @Test
    public void test3_35ClearMultipleTracesFolder() {
        int optionFlags = 4;
        SWTBotTreeItem tracesFolder1 = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotShell shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(tracesFolder1);
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), CUSTOM_TEXT_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(CUSTOM_TEXT_LOG, optionFlags, CUSTOM_TEXT_LOG.getTraceName(), CUSTOM_TEXT_TRACE_TYPE, TRACE_PROJECT_NAME);
        SWTBotUtils.createProject((String)DEFAULT_PROJECT_NAME);
        SWTBotTreeItem tracesFolder2 = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)DEFAULT_PROJECT_NAME);
        shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(tracesFolder2);
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, optionFlags, new ImportConfirmationSupplier(new ImportConfirmation[0]), LTTNG_KERNEL_TRACE.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags, LTTNG_KERNEL_TRACE.getTraceName(), LTTNG_KERNEL_TRACE_TYPE, DEFAULT_PROJECT_NAME);
        SWTBotTree tree = fBot.viewByTitle("Project Explorer").bot().tree();
        tree.select(new SWTBotTreeItem[]{tracesFolder1, tracesFolder2});
        tree.contextMenu().menu(new String[]{"Clear"}).click();
        SWTBot deleteConfirmationShellBot = fBot.shell("Confirm Clear").bot();
        deleteConfirmationShellBot.button("Yes").click();
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)CUSTOM_TEXT_LOG.getTraceName()));
        fBot.waitWhile(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)LTTNG_KERNEL_TRACE.getTraceName()));
        SWTBotUtils.waitUntil(folder -> folder.getNodes().isEmpty(), (Object)tracesFolder1, (String)"Traces folder (tracesFolder1) not empty");
        SWTBotUtils.waitUntil(folder -> folder.getNodes().isEmpty(), (Object)tracesFolder2, (String)"Traces folder (tracesFolder2) not empty");
        SWTBotUtils.deleteProject((String)DEFAULT_PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @Test
    public void test3_36ImportZipArchivePreserve() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 2;
        ProjectExplorerTracesFolderTest.importTrace("traces.zip", null, optionFlags, ImportConfirmation.CONTINUE, "");
        TestTraceInfo[] testTraceInfoArray = ALL_TRACEINFOS;
        int n = ALL_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags, info.getTracePath());
            ++n2;
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)7L, (long)tracesFolderItem.getItems().length);
        SWTBotTreeItem clashesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)CLASHES_DIR_NAME);
        Assert.assertEquals((long)6L, (long)clashesFolderItem.getItems().length);
    }

    @Test
    public void test3_37ImportZipArchiveNoPreserve() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 0;
        ProjectExplorerTracesFolderTest.importTrace("traces.zip", null, optionFlags, ImportConfirmation.RENAME_ALL, "");
        TestTraceInfo[] testTraceInfoArray = ALL_TRACEINFOS;
        int n = ALL_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            String traceName = info.getTraceName();
            if (CLASHING_TRACEINFOS.contains(info)) {
                traceName = ProjectExplorerTracesFolderTest.toRenamedName(traceName);
            }
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags, traceName);
            ++n2;
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)12L, (long)tracesFolderItem.getItems().length);
    }

    @Test
    public void test3_38ImportZipArchiveSpecificTraces() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 2;
        ProjectExplorerTracesFolderTest.importTrace("traces.zip", null, optionFlags, ImportConfirmation.CONTINUE, "z-clashes/ExampleCustomTxt.log", "kernel-overlap-testing/");
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_TEXT_LOG, optionFlags, CLASHES_CUSTOM_TEXT_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags, LTTNG_KERNEL_TRACE.getTracePath());
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)2L, (long)tracesFolderItem.getItems().length);
        SWTBotTreeItem clashesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)CLASHES_DIR_NAME);
        Assert.assertEquals((long)1L, (long)clashesFolderItem.getItems().length);
    }

    @Test
    public void test3_39ImportTarGzipArchivePreserve() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 2;
        ProjectExplorerTracesFolderTest.importTrace("traces.tar.gz", null, optionFlags, ImportConfirmation.CONTINUE, "");
        TestTraceInfo[] testTraceInfoArray = ALL_TRACEINFOS;
        int n = ALL_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags, info.getTracePath());
            ++n2;
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)7L, (long)tracesFolderItem.getItems().length);
        SWTBotTreeItem clashesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)CLASHES_DIR_NAME);
        Assert.assertEquals((long)6L, (long)clashesFolderItem.getItems().length);
    }

    @Test
    public void test3_40ImportTarGzipArchiveNoPreserve() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 0;
        ProjectExplorerTracesFolderTest.importTrace("traces.tar.gz", null, optionFlags, ImportConfirmation.RENAME_ALL, "");
        TestTraceInfo[] testTraceInfoArray = ALL_TRACEINFOS;
        int n = ALL_TRACEINFOS.length;
        int n2 = 0;
        while (n2 < n) {
            TestTraceInfo info = testTraceInfoArray[n2];
            String traceName = info.getTraceName();
            if (CLASHING_TRACEINFOS.contains(info)) {
                traceName = ProjectExplorerTracesFolderTest.toRenamedName(traceName);
            }
            ProjectExplorerTracesFolderTest.verifyTrace(info, optionFlags, traceName);
            ++n2;
        }
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)12L, (long)tracesFolderItem.getItems().length);
    }

    @Test
    public void test3_41ImportTarGzipArchiveSpecificTraces() {
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        int optionFlags = 2;
        ProjectExplorerTracesFolderTest.importTrace("traces.tar.gz", null, optionFlags, ImportConfirmation.CONTINUE, "z-clashes/ExampleCustomTxt.log", "kernel-overlap-testing/");
        ProjectExplorerTracesFolderTest.verifyTrace(CLASHES_CUSTOM_TEXT_LOG, optionFlags, CLASHES_CUSTOM_TEXT_LOG.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(LTTNG_KERNEL_TRACE, optionFlags, LTTNG_KERNEL_TRACE.getTracePath());
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        Assert.assertEquals((long)2L, (long)tracesFolderItem.getItems().length);
        SWTBotTreeItem clashesFolderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)CLASHES_DIR_NAME);
        Assert.assertEquals((long)1L, (long)clashesFolderItem.getItems().length);
    }

    @Test
    public void test_RenameFolderWorkaroundBug525833() {
        SWTBotTreeItem tracesFolderItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        tracesFolderItem.contextMenu().menu(new String[]{"New Folder..."}).click();
        String NEW_FOLDER_DIALOG_TITLE = "New Folder";
        SWTBotShell shell = fBot.shell("New Folder").activate();
        SWTBotText text = shell.bot().textWithLabel("Folder name:");
        String FOLDER_NAME = "aaa";
        text.setText("aaa");
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 120000L);
        SWTBotTreeItem folderItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)tracesFolderItem, (String)"aaa");
        shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(folderItem);
        ProjectExplorerTracesFolderTest.importTrace(shell, null, null, 4, new ImportConfirmationSupplier(ImportConfirmation.CONTINUE), LTTNG_KERNEL_TRACE.getTracePath());
        String EXP_NAME = "exp";
        SWTBotUtils.createExperiment((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME, (String)"exp");
        final SWTBotTreeItem project = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotTreeItem experiment = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Experiments", "exp"});
        folderItem.expand();
        folderItem.getNode(LTTNG_KERNEL_TRACE.getTraceName()).dragAndDrop((AbstractSWTBot)experiment);
        experiment.expand();
        String NEW_FOLDER_NAME = "bbb";
        folderItem.contextMenu().menu(new String[]{"Rename..."}).click();
        String RENAME_FOLDER_DIALOG_TITLE = "Rename Folder";
        shell = fBot.shell("Rename Folder").activate();
        text = shell.bot().textWithLabel("New Folder name:");
        text.setText("bbb");
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 120000L);
        SWTBotTreeItem expTrace = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Experiments", "exp", "bbb/" + LTTNG_KERNEL_TRACE.getTraceName()});
        Assert.assertEquals((Object)("bbb/" + LTTNG_KERNEL_TRACE.getTraceName()), (Object)expTrace.getText());
        IStatus status = (IStatus)UIThreadRunnable.syncExec((Result)new Result<IStatus>(){

            public IStatus run() {
                TmfTracesFolder tmfTracesFolder;
                IFolder tFolder;
                String path;
                File fileSystemPath;
                TmfExperimentElement tmfExp;
                IFolder expFolder;
                String path2;
                File fileSystemPath2;
                String PLUGIN_ID = "org.eclipse.tracecompass.integration.swtbot.tests";
                SWTBotTreeItem exp = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Experiments", "exp"});
                Object expObj = ((TreeItem)exp.widget).getData();
                if (expObj instanceof TmfExperimentElement && (fileSystemPath2 = new File(path2 = (expFolder = (tmfExp = (TmfExperimentElement)expObj).getResource()).getLocation().toOSString())).isDirectory()) {
                    File[] fileArray = fileSystemPath2.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if ("aaa".equals(file.getName())) {
                            return new Status(4, "org.eclipse.tracecompass.integration.swtbot.tests", "aaa exists under experiment!", null);
                        }
                        ++n2;
                    }
                }
                SWTBotTreeItem tracesItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)ProjectExplorerTracesFolderTest.TRACE_PROJECT_NAME);
                Object tracesFolderObj = ((TreeItem)tracesItem.widget).getData();
                if (tracesFolderObj instanceof TmfTracesFolder && (fileSystemPath = new File(path = (tFolder = (tmfTracesFolder = (TmfTracesFolder)tracesFolderObj).getResource()).getLocation().toOSString())).isDirectory()) {
                    File[] fileArray = fileSystemPath.listFiles();
                    int n = fileArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        File file = fileArray[n3];
                        if ("aaa".equals(file.getName())) {
                            return new Status(4, "org.eclipse.tracecompass.integration.swtbot.tests", "aaa exists in trace folder!", null);
                        }
                        ++n3;
                    }
                }
                return Status.OK_STATUS;
            }
        });
        if (!status.isOK()) {
            Assert.fail((String)status.getMessage());
        }
    }

    private static void verifyTrace(TestTraceInfo traceInfo, int importOptionFlags) {
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, importOptionFlags, traceInfo.getTraceName());
    }

    private static void verifyTrace(TestTraceInfo traceInfo, int importOptionFlags, String traceName) {
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, importOptionFlags, traceName, traceInfo.getTraceType());
    }

    private static void verifyTrace(TestTraceInfo traceInfo, int importOptionFlags, String traceName, String traceType) {
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, importOptionFlags, traceName, traceType, TRACE_PROJECT_NAME);
    }

    private static void verifyTrace(TestTraceInfo traceInfo, int importOptionFlags, String traceName, String traceType, String projectName) {
        String[] tracePath = new Path(traceName).segments();
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)projectName), (String[])tracePath);
        ProjectExplorerTracesFolderTest.checkTraceType(traceItem, traceType);
        ProjectExplorerTracesFolderTest.openTrace(traceItem);
        if (traceType != null && !traceType.isEmpty()) {
            SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)traceName, (long)traceInfo.getNbEvents(), (String)traceInfo.getFirstEventTimestamp());
        } else {
            fBot.waitUntil(ConditionHelpers.isEditorOpened((SWTWorkbenchBot)fBot, (String)traceName));
            SWTBotEditor editor = fBot.editorByTitle(traceName);
            Assert.assertEquals((Object)TEXT_EDITOR_ID, (Object)((IEditorReference)editor.getReference()).getId());
        }
        ProjectExplorerTracesFolderTest.checkTraceLinked(traceItem, (importOptionFlags & 4) != 0);
    }

    private static String toRenamedName(String traceName) {
        return String.valueOf(traceName) + "(2)";
    }

    private static void openTrace(SWTBotTreeItem traceItem) {
        traceItem.select();
        traceItem.doubleClick();
    }

    private static void testSingleTrace(TestTraceInfo traceInfo, int optionFlags) {
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, traceInfo.getTracePath());
        ProjectExplorerTracesFolderTest.verifyTrace(traceInfo, optionFlags);
    }

    private static void importTrace(int optionFlags, String ... tracePaths) {
        ProjectExplorerTracesFolderTest.importTrace(optionFlags, ImportConfirmation.CONTINUE, tracePaths);
    }

    private static void importTrace(int optionFlags, ImportConfirmation confirmationMode, String ... tracePaths) {
        ProjectExplorerTracesFolderTest.importTrace(null, optionFlags, confirmationMode, tracePaths);
    }

    private static void importTrace(String traceType, int optionFlags, ImportConfirmation confirmationMode, String ... tracePaths) {
        ProjectExplorerTracesFolderTest.importTrace(null, traceType, optionFlags, confirmationMode, tracePaths);
    }

    private static void importTrace(String archiveFile, String traceType, int optionFlags, ImportConfirmation confirmationMode, String ... tracePaths) {
        ProjectExplorerTracesFolderTest.importTrace(archiveFile, traceType, optionFlags, new ImportConfirmationSupplier(confirmationMode), tracePaths);
    }

    private static void importTrace(int optionFlags, Supplier<ImportConfirmation> confirmationSuplier, String ... tracePaths) {
        ProjectExplorerTracesFolderTest.importTrace(null, null, optionFlags, confirmationSuplier, tracePaths);
    }

    private static void importTrace(String archiveFile, String traceType, int optionFlags, Supplier<ImportConfirmation> confirmationSuplier, String ... tracePaths) {
        SWTBotTreeItem traceFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        SWTBotShell shell = ProjectExplorerTracesFolderTest.openTraceFoldersImport(traceFolder);
        ProjectExplorerTracesFolderTest.importTrace(shell, archiveFile, traceType, optionFlags, confirmationSuplier, tracePaths);
    }

    private static void importTrace(SWTBotShell shell, String archiveFile, String traceType, int optionFlags, Supplier<ImportConfirmation> confirmationSuplier, String ... tracePaths) {
        String rootFolderName;
        SWTBot bot = shell.bot();
        if (archiveFile == null) {
            rootFolderName = "import";
            String importDirectoryFullPath = ProjectExplorerTracesFolderTest.getPath(rootFolderName);
            SWTBotImportWizardUtils.selectImportFromDirectory((SWTBot)bot, (String)importDirectoryFullPath);
        } else {
            rootFolderName = "/";
            String importArchiveFullPath = ProjectExplorerTracesFolderTest.getPath("archives" + File.separator + archiveFile);
            SWTBotImportWizardUtils.selectImportFromArchive((SWTBot)bot, (String)importArchiveFullPath);
        }
        String[] stringArray = tracePaths;
        int n = tracePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String tracePath = stringArray[n2];
            IPath somePath = new Path(rootFolderName).append(tracePath);
            String[] treePath = somePath.segments();
            if (archiveFile != null) {
                String[] newPath = new String[treePath.length + 1];
                newPath[0] = "/";
                System.arraycopy(treePath, 0, newPath, 1, treePath.length);
                treePath = newPath;
            }
            SWTBotImportWizardUtils.selectItem((SWTBot)fBot, (String[])treePath);
            ++n2;
        }
        SWTBotImportWizardUtils.setOptions((SWTBot)bot, (int)optionFlags, (String)traceType);
        bot.button("Finish").click();
        ImportConfirmation importConfirmation = confirmationSuplier.get();
        while (importConfirmation != null) {
            if (importConfirmation != ImportConfirmation.CONTINUE) {
                SWTBotShell shell2 = fBot.shell("Confirmation").activate();
                SWTBotButton button = shell2.bot().button(importConfirmation.getInName());
                button.click();
            }
            importConfirmation = confirmationSuplier.get();
        }
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell), 120000L);
    }

    private static void checkTraceType(SWTBotTreeItem traceItem, String traceType) {
        Assert.assertEquals((Object)traceType, (Object)ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, "type"));
    }

    private static void checkTraceLinked(SWTBotTreeItem traceItem, boolean linked) {
        Assert.assertEquals((Object)Boolean.toString(linked), (Object)ProjectExplorerTracesFolderTest.getTraceProperty(traceItem, "linked"));
    }

    private static String getTraceProperty(SWTBotTreeItem traceItem, String property) {
        SWTBotUtils.openView((String)"org.eclipse.ui.views.PropertySheet");
        SWTBotView view = fBot.viewById("org.eclipse.ui.views.PropertySheet");
        view.show();
        traceItem.select();
        SWTBotTreeItem traceTypeItem = SWTBotUtils.getTreeItem((SWTBot)view.bot(), (SWTBotTree)view.bot().tree(), (String[])new String[]{"Resource properties", property});
        return traceTypeItem.cell(1);
    }

    private static SWTBotShell openTraceFoldersImport(SWTBotTreeItem traceItem) {
        traceItem.contextMenu().menu(new String[]{"Import..."}).click();
        return fBot.shell("Trace Import").activate();
    }

    private static SWTBotShell openWorkbenchMenuImport() {
        fBot.menu().menu(new String[]{"File", "Import..."}).click();
        SWTBot shellBot = fBot.shell("Import").activate().bot();
        SWTBotTree tree = shellBot.tree();
        SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)tree, (String[])new String[]{DEFAULT_PROJECT_NAME, "Trace Import"}).select();
        shellBot.button("Next >").click();
        SWTBotShell shell = fBot.shell("Trace Import");
        return shell;
    }

    private static final class ImportConfirmationSupplier
    implements Supplier<ImportConfirmation> {
        List<ImportConfirmation> fConfirmations = Lists.newArrayList((Object[])new ImportConfirmation[]{ImportConfirmation.CONTINUE});

        public ImportConfirmationSupplier(ImportConfirmation ... confirmations) {
            this.fConfirmations = Lists.newArrayList((Object[])confirmations);
        }

        @Override
        public ImportConfirmation get() {
            return this.fConfirmations.isEmpty() ? null : this.fConfirmations.remove(0);
        }
    }
}

