/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.uml2sd.trace;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfEventParser;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;

public class TmfUml2SDTestTrace
implements ITmfEventParser {
    ITmfTrace fEventStream;

    public TmfUml2SDTestTrace() {
    }

    public TmfUml2SDTestTrace(ITmfTrace eventStream) {
        this.fEventStream = eventStream;
    }

    public void setTrace(ITmfTrace eventStream) {
        this.fEventStream = eventStream;
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        if (!(this.fEventStream instanceof TmfTraceStub)) {
            return null;
        }
        RandomAccessFile stream = ((TmfTraceStub)this.fEventStream).getStream();
        long location = 0L;
        if (context != null) {
            location = (Long)context.getLocation().getLocationInfo();
        }
        try {
            stream.seek(location);
            long ts = stream.readLong();
            stream.readUTF();
            String type = stream.readUTF();
            stream.readUTF();
            String sender = stream.readUTF();
            String receiver = stream.readUTF();
            String signal = stream.readUTF();
            String[] labels = new String[]{"sender", "receiver", "signal"};
            TmfEventType tmfEventType = new TmfEventType(type, TmfEventField.makeRoot((String[])labels));
            String content = "[";
            content = String.valueOf(content) + sender;
            content = String.valueOf(content) + "," + receiver;
            content = String.valueOf(content) + "," + signal;
            content = String.valueOf(content) + "]";
            TmfEventField[] fields = new TmfEventField[]{new TmfEventField("sender", (Object)sender, null), new TmfEventField("receiver", (Object)receiver, null), new TmfEventField("signal", (Object)signal, null)};
            TmfEventField tmfContent = new TmfEventField(":root:", (Object)content, (ITmfEventField[])fields);
            TmfEvent tmfEvent = new TmfEvent(this.fEventStream, -1L, TmfTimestamp.create((long)ts, (int)-9), (ITmfEventType)tmfEventType, (ITmfEventField)tmfContent);
            return tmfEvent;
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

