/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateSystemPathCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlTimeGraphEntryModel;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.IRegexQuery;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.TimeGraphStateQueryFilter;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.w3c.dom.Element;

public class XmlTimeGraphDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<XmlTimeGraphEntryModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlTimeGraphDataProvider";
    private static final AtomicLong sfAtomicId = new AtomicLong();
    private static final @NonNull String SPLIT_STRING = "/";
    private final List<ITmfStateSystem> fSs;
    private final List<Element> fEntries;
    private final Table<ITmfStateSystem, Integer, Long> fBaseQuarkToId = HashBasedTable.create();
    private final Map<Long, Pair<ITmfStateSystem, Integer>> fIDToDisplayQuark = new HashMap<Long, Pair<ITmfStateSystem, Integer>>();
    private final @NonNull AnalysisCompilationData fCompilationData;

    public static XmlTimeGraphDataProvider create(@NonNull ITmfTrace trace, Element viewElement) {
        Set<@NonNull String> analysisIds = TmfXmlUtils.getViewAnalysisIds(viewElement);
        List<Element> entries = TmfXmlUtils.getChildElements(viewElement, "entry");
        HashSet<@NonNull ITmfAnalysisModuleWithStateSystems> stateSystemModules = new HashSet<ITmfAnalysisModuleWithStateSystems>();
        if (analysisIds.isEmpty()) {
            Iterables.addAll(stateSystemModules, (Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class));
        } else {
            for (String moduleId : analysisIds) {
                IAnalysisModule module = trace.getAnalysisModule(moduleId);
                if (!(module instanceof ITmfAnalysisModuleWithStateSystems)) continue;
                stateSystemModules.add((ITmfAnalysisModuleWithStateSystems)module);
            }
        }
        ArrayList<ITmfStateSystem> sss = new ArrayList<ITmfStateSystem>();
        for (ITmfAnalysisModuleWithStateSystems module : stateSystemModules) {
            if (!module.schedule().isOK() || !module.waitForInitialization()) continue;
            module.getStateSystems().forEach(sss::add);
        }
        return sss.isEmpty() ? null : new XmlTimeGraphDataProvider(trace, sss, entries);
    }

    private XmlTimeGraphDataProvider(@NonNull ITmfTrace trace, List<ITmfStateSystem> stateSystems, List<Element> entries) {
        super(trace);
        this.fSs = stateSystems;
        this.fEntries = entries;
        this.fCompilationData = new AnalysisCompilationData();
    }

    public TmfModelResponse<@NonNull List<XmlTimeGraphEntryModel>> fetchTree(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ArrayList<XmlTimeGraphEntryModel> entryList = new ArrayList<XmlTimeGraphEntryModel>();
        boolean isComplete = true;
        String traceName = String.valueOf(this.getTrace().getName());
        for (ITmfStateSystem ss : this.fSs) {
            isComplete &= ss.waitUntilBuilt(0L);
            if (ss.getNbAttributes() <= 0 || ss.getStartTime() == Long.MIN_VALUE) continue;
            long start = ss.getStartTime();
            long end = ss.getCurrentEndTime();
            long id = this.fBaseQuarkToId.row((Object)ss).computeIfAbsent(-1, s -> sfAtomicId.getAndIncrement());
            XmlTimeGraphEntryModel.Builder ssEntry = new XmlTimeGraphEntryModel.Builder(id, -1L, traceName, start, end, null, ss, -1, this.fCompilationData);
            entryList.add(ssEntry.build());
            for (Element entry : this.fEntries) {
                this.buildEntry(ss, entry, ssEntry, -1, "", end, entryList);
            }
        }
        ITmfResponse.Status status = isComplete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING;
        String msg = isComplete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING;
        return new TmfModelResponse(entryList, status, msg);
    }

    private void buildEntry(ITmfStateSystem ssq, Element entryElement, @NonNull XmlTimeGraphEntryModel.Builder parentEntry, int prevBaseQuark, @NonNull String prevRegex, long currentEnd, List<XmlTimeGraphEntryModel> entryList) {
        String attributePath;
        Pattern pattern;
        Matcher matcher;
        ITmfStateSystem parentSs;
        String path = entryElement.getAttribute("path");
        if (path.isEmpty()) {
            path = "*";
        }
        List<Element> displayElements = TmfXmlUtils.getChildElements(entryElement, "display");
        List<Element> entryElements = TmfXmlUtils.getChildElements(entryElement, "entry");
        if (displayElements.isEmpty() && entryElements.isEmpty()) {
            Activator.logWarning(String.format("XML view: entry for %s should have either a display element or entry elements", path));
            return;
        }
        String analysisId = entryElement.getAttribute("analysisId");
        ITmfStateSystem ss = parentSs = ssq;
        int baseQuark = prevBaseQuark;
        if (!analysisId.isEmpty()) {
            ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)this.getTrace(), (String)analysisId);
            baseQuark = -1;
            if (ss == null) {
                return;
            }
        }
        if ((matcher = (pattern = Pattern.compile(prevRegex)).matcher(attributePath = prevBaseQuark > 0 ? parentSs.getFullAttributePath(prevBaseQuark) : "")).find()) {
            path = matcher.replaceFirst(path);
        }
        String regexName = path.replaceAll("\\*", "(.*)");
        String[] paths = regexName.split(SPLIT_STRING);
        int i = 0;
        List<Integer> quarks = Collections.singletonList(baseQuark);
        while (i < paths.length) {
            LinkedList<Integer> subQuarks = new LinkedList<Integer>();
            String name = paths[i];
            for (int relativeQuark : quarks) {
                subQuarks.addAll(ss.getSubAttributes(relativeQuark, false, name));
            }
            quarks = subQuarks;
            ++i;
        }
        DataDrivenStateSystemPath displayPath = null;
        HashMap<String, XmlTimeGraphEntryModel.Builder> entryMap = new HashMap<String, XmlTimeGraphEntryModel.Builder>();
        if (!displayElements.isEmpty()) {
            Element displayElement = displayElements.get(0);
            TmfXmlStateSystemPathCu displayCu = TmfXmlStateSystemPathCu.compile(parentEntry.getAnalysisCompilationData(), Collections.singletonList(displayElement));
            if (displayCu != null) {
                displayPath = displayCu.generate();
            }
        }
        for (int quark : quarks) {
            XmlTimeGraphEntryModel.Builder currentEntry = parentEntry;
            if (displayPath != null) {
                currentEntry = this.processEntry(entryElement, displayPath, parentEntry, quark, ss, currentEnd);
                entryMap.put(currentEntry.getXmlId(), currentEntry);
            } else {
                long id = this.fBaseQuarkToId.row((Object)ss).computeIfAbsent(quark, s -> sfAtomicId.getAndIncrement());
                currentEntry = new XmlTimeGraphEntryModel.Builder(id, parentEntry.getId(), ss.getAttributeName(quark), ss.getStartTime(), ss.getCurrentEndTime(), null, ss, quark, this.fCompilationData);
                entryMap.put(currentEntry.getXmlId(), currentEntry);
            }
            for (Element subEntryEl : entryElements) {
                String regex = prevRegex.isEmpty() ? regexName : String.valueOf(prevRegex) + '/' + regexName;
                this.buildEntry(ss, subEntryEl, currentEntry, quark, regex, currentEnd, entryList);
            }
        }
        XmlTimeGraphDataProvider.buildTree(entryMap, parentEntry.getId());
        for (XmlTimeGraphEntryModel.Builder b : entryMap.values()) {
            entryList.add(b.build());
        }
    }

    private XmlTimeGraphEntryModel.Builder processEntry(@NonNull Element entryElement, DataDrivenStateSystemPath displayPath, @NonNull XmlTimeGraphEntryModel.Builder parentEntry, int quark, ITmfStateSystem ss, long currentEnd) {
        int displayQuark = displayPath.getQuark(quark, parentEntry);
        long id = this.fBaseQuarkToId.row((Object)ss).computeIfAbsent(quark, s -> sfAtomicId.getAndIncrement());
        if (displayQuark < 0) {
            return new XmlTimeGraphEntryModel.Builder(id, parentEntry.getId(), String.format("Unknown display quark for %s", ss.getAttributeName(quark)), ss.getStartTime(), ss.getCurrentEndTime(), null, ss, quark, this.fCompilationData);
        }
        this.fIDToDisplayQuark.put(id, (Pair<ITmfStateSystem, Integer>)new Pair((Object)ss, (Object)displayQuark));
        long entryStart = ss.getStartTime();
        long entryEnd = currentEnd;
        try {
            long ts;
            ITmfStateInterval oneInterval = ss.querySingleState(entryStart, displayQuark);
            while (oneInterval.getStateValue().isNull()) {
                ts = oneInterval.getEndTime() + 1L;
                if (ts > currentEnd) break;
                oneInterval = ss.querySingleState(ts, displayQuark);
            }
            entryStart = oneInterval.getStartTime();
            oneInterval = ss.querySingleState(entryEnd - 1L, displayQuark);
            while (oneInterval.getStateValue().isNull()) {
                ts = oneInterval.getStartTime() - 1L;
                if (ts < ss.getStartTime()) break;
                oneInterval = ss.querySingleState(ts, displayQuark);
            }
            entryEnd = Math.min(oneInterval.getEndTime() + 1L, currentEnd);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return new XmlTimeGraphEntryModel.Builder(id, parentEntry.getId(), ss.getAttributeName(quark), entryStart, entryEnd, entryElement, ss, quark, this.fCompilationData);
    }

    private static void buildTree(Map<String, XmlTimeGraphEntryModel.Builder> entryMap, long parentId) {
        for (XmlTimeGraphEntryModel.Builder entry : entryMap.values()) {
            XmlTimeGraphEntryModel.Builder parent;
            boolean root = true;
            if (!entry.getXmlParentId().isEmpty() && (parent = entryMap.get(entry.getXmlParentId())) != null && entry.getStartTime() <= parent.getEndTime() && entry.getEndTime() >= parent.getStartTime()) {
                entry.setParentId(parent.getId());
                root = false;
            }
            if (!root) continue;
            entry.setParentId(parentId);
        }
    }

    public @NonNull String getId() {
        return ID;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphRowModel>> fetchRowModel(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        HashBasedTable table = HashBasedTable.create();
        for (Long id : filter.getSelectedItems()) {
            Pair<ITmfStateSystem, Integer> pair = this.fIDToDisplayQuark.get(id);
            if (pair == null) continue;
            table.put((Object)((ITmfStateSystem)pair.getFirst()), (Object)((Integer)pair.getSecond()), (Object)id);
        }
        ArrayList<@NonNull ITimeGraphRowModel> allRows = new ArrayList<ITimeGraphRowModel>();
        try {
            for (Map.Entry ssEntry : table.rowMap().entrySet()) {
                Collection<@NonNull ITimeGraphRowModel> rows = this.createRows((ITmfStateSystem)ssEntry.getKey(), (Map)ssEntry.getValue(), filter.getTimesRequested(), filter, monitor);
                allRows.addAll(rows);
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        return new TmfModelResponse(allRows, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Collection<@NonNull ITimeGraphRowModel> createRows(ITmfStateSystem ss, Map<Integer, Long> idToDisplayQuark, long[] timesRequested, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        if (filter instanceof TimeGraphStateQueryFilter) {
            TimeGraphStateQueryFilter timeEventFilter = (TimeGraphStateQueryFilter)filter;
            predicates.putAll(this.computeRegexPredicate((IRegexQuery)timeEventFilter));
        }
        long currentEndTime = ss.getCurrentEndTime();
        HashMap<Integer, TimeGraphRowModel> quarkToRow = new HashMap<Integer, TimeGraphRowModel>(idToDisplayQuark.size());
        for (Map.Entry<Integer, Long> entry : idToDisplayQuark.entrySet()) {
            quarkToRow.put(entry.getKey(), new TimeGraphRowModel(entry.getValue().longValue(), new ArrayList()));
        }
        for (ITmfStateInterval interval : ss.query2D(idToDisplayQuark.keySet(), XmlTimeGraphDataProvider.getTimes(ss, timesRequested))) {
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ITimeGraphRowModel row = (ITimeGraphRowModel)quarkToRow.get(interval.getAttribute());
            if (row == null) continue;
            @NonNull List states = row.getStates();
            TimeGraphState timeGraphState = XmlTimeGraphDataProvider.getStateFromInterval(interval, currentEndTime);
            this.applyFilterAndAddState(states, (ITimeGraphState)timeGraphState, row.getEntryID(), predicates, monitor);
        }
        for (ITimeGraphRowModel model : quarkToRow.values()) {
            model.getStates().sort(Comparator.comparingLong(ITimeGraphState::getStartTime));
        }
        return quarkToRow.values();
    }

    private static @NonNull TimeGraphState getStateFromInterval(ITmfStateInterval statusInterval, long currentEndTime) {
        long time = statusInterval.getStartTime();
        long duration = Math.min(currentEndTime, statusInterval.getEndTime() + 1L) - time;
        Object o = statusInterval.getValue();
        if (o instanceof Integer) {
            return new TimeGraphState(time, duration, ((Integer)o).intValue(), String.valueOf(o));
        }
        if (o instanceof Long) {
            long l = (Long)o;
            return new TimeGraphState(time, duration, (int)l, "0x" + Long.toHexString(l));
        }
        if (o instanceof String) {
            return new TimeGraphState(time, duration, Integer.MIN_VALUE, (String)o);
        }
        if (o instanceof Double) {
            return new TimeGraphState(time, duration, ((Double)o).intValue());
        }
        return new TimeGraphState(time, duration, Integer.MIN_VALUE);
    }

    private static @NonNull Set<@NonNull Long> getTimes(ITmfStateSystem key, long[] timesRequested) {
        HashSet<@NonNull Long> times = new HashSet<Long>();
        long[] lArray = timesRequested;
        int n = timesRequested.length;
        int n2 = 0;
        while (n2 < n) {
            long t = lArray[n2];
            if (key.getStartTime() <= t && t <= key.getCurrentEndTime()) {
                times.add(t);
            }
            ++n2;
        }
        return times;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }
}

