/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.modelhandler;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.AbstractModelHandler;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;

class ModelHandlerRegistryReader {
    private HashMap allReadyCreateInstances = new HashMap();
    protected String ATT_ASSOCIATED_CONTENT_TYPE = "associatedContentTypeId";
    protected String ATT_CLASS = "class";
    protected String ATT_DEFAULT = "default";
    protected String ATT_ID = "id";
    IConfigurationElement[] elements;
    protected String EXTENSION_POINT_ID = "modelHandler";
    protected String PLUGIN_ID = "org.eclipse.wst.sse.core";
    protected String TAG_NAME = "modelHandler";

    ModelHandlerRegistryReader() {
    }

    String getAssociatedContentTypeId(IConfigurationElement element) {
        String value = element.getAttribute(this.ATT_ASSOCIATED_CONTENT_TYPE);
        return value;
    }

    String getId(IConfigurationElement element) {
        String idValue = element.getAttribute(this.ATT_ID);
        return idValue;
    }

    synchronized IModelHandler getInstance(IConfigurationElement element) {
        AbstractModelHandler modelHandler = (AbstractModelHandler)this.allReadyCreateInstances.get(this.getId(element));
        if (modelHandler == null) {
            try {
                modelHandler = (AbstractModelHandler)element.createExecutableExtension(this.ATT_CLASS);
                if (modelHandler != null) {
                    this.allReadyCreateInstances.put(this.getId(element), modelHandler);
                    String defaultValue = element.getAttribute(this.ATT_DEFAULT);
                    if (defaultValue != null && "true".equals(defaultValue)) {
                        modelHandler.setDefault(true);
                    } else {
                        modelHandler.setDefault(false);
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return modelHandler;
    }

    public boolean isElementDefault(IConfigurationElement element) {
        String defaultValue = element.getAttribute(this.ATT_DEFAULT);
        return defaultValue != null && "true".equals(defaultValue);
    }

    ModelHandlerRegistryReader readRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint(this.PLUGIN_ID, this.EXTENSION_POINT_ID);
        if (point != null) {
            this.elements = point.getConfigurationElements();
        }
        return this;
    }
}

