/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.preferences;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlAnalysisModuleSource;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.preferences.Messages;
import org.eclipse.tracecompass.tmf.ui.dialog.DirectoryDialogFactory;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class XMLAnalysesManagerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int BUTTON_CHECK_SELECTED_ID = 1024;
    private static final int BUTTON_UNCHECK_SELECTED_ID = 1025;
    private static final String XML_FILTER_EXTENSION = "*.xml";
    private Table fAnalysesTable;
    private Button fDeleteButton;
    private Button fExportButton;
    private Button fEditButton;
    private Label fStatusLabel;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ELEMENT_SEP = "-\t";
    private static final IPropertyListener SAVE_EDITOR_LISTENER = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)source;
                if (257 == propId && !editorPart.isDirty() && editorPart.getEditorInput() instanceof IURIEditorInput) {
                    File file = URIUtil.toFile((URI)((IURIEditorInput)editorPart.getEditorInput()).getURI());
                    boolean success = XMLAnalysesManagerPreferencePage.loadXmlFile(file, false);
                    if (success) {
                        XMLAnalysesManagerPreferencePage.enableAndDisableAnalyses(Collections.singletonList(file.getName()), Collections.emptyList());
                    } else {
                        XMLAnalysesManagerPreferencePage.enableAndDisableAnalyses(Collections.emptyList(), Collections.singletonList(file.getName()));
                    }
                }
            }
        }
    };

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.ManageXMLAnalysisDialog_ManageXmlAnalysesFiles);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        Composite tableContainer = new Composite(mainComposite, 0);
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.fillDefaults().applyTo(tableContainer);
        this.createTable(tableContainer);
        this.createLabels(tableContainer);
        this.createImportButtons(mainComposite);
        this.createSelectionButtons(mainComposite);
        this.fillAnalysesTable();
        this.getShell().setMinimumSize(300, 275);
        return mainComposite;
    }

    public boolean performOk() {
        this.handleChecks();
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private void createTable(Composite composite) {
        this.fAnalysesTable = new Table(composite, 2850);
        this.fAnalysesTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fAnalysesTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelectionCount() == 0) {
                    XMLAnalysesManagerPreferencePage.this.setButtonsEnabled(false);
                } else {
                    XMLAnalysesManagerPreferencePage.this.setButtonsEnabled(true);
                    XMLAnalysesManagerPreferencePage.this.handleSelection(XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection());
                }
            }
        });
    }

    private void createLabels(Composite composite) {
        this.fStatusLabel = new Label(composite, 0);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createImportButtons(Composite composite) {
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Button importButton = new Button(buttonContainer, 8);
        importButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        importButton.setText(Messages.ManageXMLAnalysisDialog_Import);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.importAnalysis();
            }
        });
        this.fExportButton = new Button(buttonContainer, 8);
        this.fExportButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fExportButton.setText(Messages.ManageXMLAnalysisDialog_Export);
        this.fExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.exportAnalysis();
            }
        });
        this.fEditButton = new Button(buttonContainer, 8);
        this.fEditButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fEditButton.setText(Messages.ManageXMLAnalysisDialog_Edit);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.editAnalysis();
            }
        });
        this.fDeleteButton = new Button(buttonContainer, 8);
        this.fDeleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fDeleteButton.setText(Messages.ManageXMLAnalysisDialog_Delete);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLAnalysesManagerPreferencePage.this.deleteAnalyses();
            }
        });
        this.setButtonsEnabled(false);
    }

    protected void createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(131072, 128, false, false);
        buttonComposite.setLayoutData((Object)data);
        Button checkSelectedButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 1024, Messages.ManageXMLAnalysisDialog_CHECK_SELECTED);
        Button checkAllButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 18, Messages.ManageXMLAnalysisDialog_CHECK_ALL);
        Button uncheckSelectedButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 1025, Messages.ManageXMLAnalysisDialog_UNCHECK_SELECTED);
        Button uncheckAllButton = XMLAnalysesManagerPreferencePage.createButton(buttonComposite, 19, Messages.ManageXMLAnalysisDialog_UNCHECK_ALL);
        checkSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(true);
                    ++n2;
                }
                XMLAnalysesManagerPreferencePage.this.handleSelection(XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection());
            }
        });
        checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(true);
                    ++n2;
                }
                XMLAnalysesManagerPreferencePage.this.handleSelection(XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection());
            }
        });
        uncheckSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(false);
                    ++n2;
                }
            }
        });
        uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = XMLAnalysesManagerPreferencePage.this.fAnalysesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem selectedItem = tableItemArray[n2];
                    selectedItem.setChecked(false);
                    ++n2;
                }
            }
        });
    }

    private static Button createButton(Composite parent, int id, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        GridData data = new GridData(4, 0x1000000, true, true);
        button.setLayoutData((Object)data);
        return button;
    }

    private void setButtonsEnabled(boolean enable) {
        this.fDeleteButton.setEnabled(enable);
        this.fExportButton.setEnabled(enable);
        this.fEditButton.setEnabled(enable);
    }

    private void handleSelection(TableItem[] selection) {
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem selectedItem = tableItemArray[n2];
            String xmlName = XmlUtils.createXmlFileString((String)selectedItem.getText());
            if (XMLAnalysesManagerPreferencePage.isFileValid(xmlName)) {
                if (selection.length == 1) {
                    if (XmlUtils.isAnalysisEnabled((String)xmlName)) {
                        this.fStatusLabel.setForeground(this.getShell().getDisplay().getSystemColor(6));
                        this.fStatusLabel.setText(Messages.ManageXMLAnalysisDialog_FileEnabled);
                    } else {
                        this.fStatusLabel.setText("");
                    }
                }
            } else {
                if (selection.length == 1) {
                    this.fStatusLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
                    this.fStatusLabel.setText(Messages.ManageXMLAnalysisDialog_FileValidationError);
                }
                if (XmlUtils.isAnalysisEnabled((String)xmlName)) {
                    XMLAnalysesManagerPreferencePage.enableAndDisableAnalyses(Collections.emptyList(), (Collection<String>)ImmutableList.of((Object)Objects.requireNonNull(xmlName)));
                }
                selectedItem.setChecked(false);
            }
            ++n2;
        }
        if (selection.length != 1) {
            this.fStatusLabel.setText("");
        }
    }

    private void fillAnalysesTable() {
        this.fAnalysesTable.removeAll();
        Map files = XmlUtils.listFiles();
        for (String file : files.keySet()) {
            Path path = new Path(file);
            TableItem item = new TableItem(this.fAnalysesTable, 0);
            item.setText(path.removeFileExtension().toString());
            item.setChecked(XmlUtils.isAnalysisEnabled((String)path.toString()));
        }
        this.setButtonsEnabled(false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void handleChecks() {
        @NonNull @NonNull Map listFiles = XmlUtils.listFiles();
        ArrayList filesToEnable = Lists.newArrayList();
        ArrayList filesToDisable = Lists.newArrayList();
        TableItem[] tableItemArray = this.fAnalysesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String xmlName = XmlUtils.createXmlFileString((String)item.getText());
            if (item.getChecked() && !XmlUtils.isAnalysisEnabled((String)xmlName)) {
                if (XMLAnalysesManagerPreferencePage.isFileValid(xmlName, listFiles)) {
                    filesToEnable.add(xmlName);
                } else {
                    item.setChecked(false);
                }
            } else if (!item.getChecked() && XmlUtils.isAnalysisEnabled((String)xmlName)) {
                filesToDisable.add(xmlName);
            }
            ++n2;
        }
        if (!filesToEnable.isEmpty() || !filesToDisable.isEmpty()) {
            XMLAnalysesManagerPreferencePage.enableAndDisableAnalyses(filesToEnable, filesToDisable);
        }
        this.handleSelection(this.fAnalysesTable.getSelection());
    }

    private static void enableAndDisableAnalyses(Collection<String> toEnable, Collection<String> toDisable) {
        ArrayList<String> toEnableOrDisable = new ArrayList<String>(toEnable.size() + toDisable.size());
        toEnableOrDisable.addAll(toEnable);
        toEnableOrDisable.addAll(toDisable);
        Collection<TmfCommonProjectElement> elements = XMLAnalysesManagerPreferencePage.deleteSupplementaryFiles(toEnableOrDisable);
        XmlUtils.enableFiles(toEnable);
        XmlUtils.disableFiles(toDisable);
        XmlAnalysisModuleSource.notifyModuleChange();
        XMLAnalysesManagerPreferencePage.refreshProject(elements);
    }

    private void importAnalysis() {
        FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)4098);
        dialog.setText(Messages.ManageXMLAnalysisDialog_SelectFilesImport);
        dialog.setFilterNames(new String[]{String.valueOf(Messages.ManageXMLAnalysisDialog_ImportXmlFile) + " (" + XML_FILTER_EXTENSION + ")"});
        dialog.setFilterExtensions(new String[]{XML_FILTER_EXTENSION});
        dialog.open();
        String directoryPath = dialog.getFilterPath();
        if (!directoryPath.isEmpty()) {
            File directory = new File(directoryPath);
            String[] files = dialog.getFileNames();
            ArrayList filesToProcess = Lists.newArrayList();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File file = new File(directory, fileName);
                if (XMLAnalysesManagerPreferencePage.loadXmlFile(file, true)) {
                    filesToProcess.add(file.getName());
                }
                ++n2;
            }
            if (!filesToProcess.isEmpty()) {
                this.fillAnalysesTable();
                Collection<TmfCommonProjectElement> elements = XMLAnalysesManagerPreferencePage.deleteSupplementaryFiles(filesToProcess);
                XmlAnalysisModuleSource.notifyModuleChange();
                XMLAnalysesManagerPreferencePage.refreshProject(elements);
            }
        }
    }

    private static boolean loadXmlFile(File file, boolean addFile) {
        IStatus status = XmlUtils.xmlValidate((File)file);
        if (status.isOK()) {
            if (addFile) {
                status = XmlUtils.addXmlFile((File)file);
            } else {
                XmlUtils.updateXmlFile((File)file);
            }
            if (status.isOK()) {
                return true;
            }
            Activator.logError(Messages.ManageXMLAnalysisDialog_ImportFileFailed);
            TraceUtils.displayErrorMsg((String)Messages.ManageXMLAnalysisDialog_ImportFileFailed, (String)status.getMessage());
        } else {
            Activator.logError(Messages.ManageXMLAnalysisDialog_ImportFileFailed);
            TraceUtils.displayErrorMsg((String)Messages.ManageXMLAnalysisDialog_ImportFileFailed, (String)status.getMessage());
        }
        return false;
    }

    private void exportAnalysis() {
        TableItem[] selection = this.fAnalysesTable.getSelection();
        DirectoryDialog dialog = DirectoryDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)8192);
        dialog.setText(NLS.bind((String)Messages.ManageXMLAnalysisDialog_SelectDirectoryExport, (Object)selection.length));
        String directoryPath = dialog.open();
        if (directoryPath != null) {
            File directory = new File(directoryPath);
            TableItem[] tableItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                TableItem item = tableItemArray[n2];
                String fileName = item.getText();
                String fileNameXml = XmlUtils.createXmlFileString((String)fileName);
                if (!XmlUtils.exportXmlFile((String)fileNameXml, (String)(path = new File(directory, fileNameXml).getAbsolutePath())).isOK()) {
                    Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToExport, (Object)fileNameXml));
                }
                ++n2;
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void editAnalysis() {
        @NonNull @NonNull Map listFiles = XmlUtils.listFiles();
        TableItem[] tableItemArray = this.fAnalysesTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String selection = XmlUtils.createXmlFileString((String)item.getText());
            @Nullable File file = (File)listFiles.get(selection);
            if (file == null) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
                TraceUtils.displayErrorMsg((String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection), (String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
                return;
            }
            try {
                IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
                editorPart.removePropertyListener(SAVE_EDITOR_LISTENER);
                editorPart.addPropertyListener(SAVE_EDITOR_LISTENER);
            }
            catch (CoreException e) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection));
                TraceUtils.displayErrorMsg((String)NLS.bind((String)Messages.ManageXMLAnalysisDialog_FailedToEdit, (Object)selection), (String)e.getMessage());
            }
            ++n2;
        }
    }

    private void deleteAnalyses() {
        TableItem[] selection = this.fAnalysesTable.getSelection();
        ArrayList filesToDeleteList = Lists.newArrayList();
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            filesToDeleteList.add(ELEMENT_SEP + item.getText());
            ++n2;
        }
        String filesToDelete = Joiner.on((String)LINE_SEP).join((Iterable)filesToDeleteList);
        boolean confirm = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ManageXMLAnalysisDialog_DeleteFile, (String)(String.valueOf(Messages.ManageXMLAnalysisDialog_DeleteConfirmation) + StringUtils.repeat((String)LINE_SEP, (int)2) + filesToDelete));
        if (confirm) {
            Set<IEditorReference> editorReferences = XMLAnalysesManagerPreferencePage.getEditorReferences();
            ArrayList toDeleteSupFiles = Lists.newArrayList();
            ArrayList toDeleteFiles = Lists.newArrayList();
            TableItem[] tableItemArray2 = selection;
            int n3 = selection.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray2[n4];
                String itemTitle = XmlUtils.createXmlFileString((String)item.getText());
                editorReferences.forEach(editorReference -> {
                    if (editorReference.getTitle().equals(itemTitle)) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(false), false);
                    }
                });
                if (XmlUtils.isAnalysisEnabled((String)itemTitle)) {
                    toDeleteSupFiles.add(itemTitle);
                }
                toDeleteFiles.add(itemTitle);
                ++n4;
            }
            Collection<TmfCommonProjectElement> elements = XMLAnalysesManagerPreferencePage.deleteSupplementaryFiles(toDeleteSupFiles);
            XmlUtils.deleteFiles((Collection)toDeleteFiles);
            this.fillAnalysesTable();
            this.handleSelection(this.fAnalysesTable.getSelection());
            XmlAnalysisModuleSource.notifyModuleChange();
            XMLAnalysesManagerPreferencePage.refreshProject(elements);
        }
    }

    private static Collection<TmfCommonProjectElement> deleteSupplementaryFiles(Collection<String> xmlFiles) {
        IProject[] projects;
        ArrayList<TmfCommonProjectElement> toReopen = new ArrayList<TmfCommonProjectElement>();
        ArrayList<IResource> resourceToDelete = new ArrayList<IResource>();
        HashSet ids = Sets.newHashSet();
        xmlFiles.forEach(xmlFile -> {
            boolean bl = ids.addAll(XmlUtils.getAnalysisIdsFromFile((String)xmlFile));
        });
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(0);
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            TmfProjectElement pElement = TmfProjectRegistry.getProject((IProject)project);
            if (pElement != null) {
                TmfExperimentFolder experimentsFolder;
                ArrayList tElements = new ArrayList();
                TmfTraceFolder tracesFolder = pElement.getTracesFolder();
                if (tracesFolder != null) {
                    tElements.addAll(tracesFolder.getTraces());
                }
                if ((experimentsFolder = pElement.getExperimentsFolder()) != null) {
                    tElements.addAll(experimentsFolder.getExperiments());
                }
                Set<IEditorReference> editorReferences = XMLAnalysesManagerPreferencePage.getEditorReferences();
                for (TmfCommonProjectElement tElement : tElements) {
                    IResource[] iResourceArray = tElement.getSupplementaryResources();
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        for (String id : ids) {
                            if (!resource.getName().startsWith(id)) continue;
                            resourceToDelete.add(resource);
                        }
                        ++n4;
                    }
                    IFile file = tElement.getBookmarksFile();
                    FileEditorInput input = new FileEditorInput(file);
                    boolean open = Iterables.any(editorReferences, editorReference -> {
                        try {
                            return editorReference.getEditorInput().equals(input);
                        }
                        catch (PartInitException e) {
                            Activator.logError("Failed to test the " + tElement.getName() + " editor", e);
                            return false;
                        }
                    });
                    if (open) {
                        toReopen.add(tElement);
                    }
                    tElement.closeEditors();
                }
            }
            ++n2;
        }
        for (IResource resource : resourceToDelete) {
            try {
                resource.delete(false, null);
            }
            catch (CoreException e) {
                Activator.logError(NLS.bind((String)Messages.ManageXMLAnalysisDialog_DeleteFileError, (Object)resource.getName()));
            }
        }
        return toReopen;
    }

    private static void refreshProject(Collection<TmfCommonProjectElement> elements) {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfProjectModelElement) {
            ((TmfProjectModelElement)element).getProject().refresh();
        }
        elements.forEach(TmfOpenTraceHelper::openTraceFromElement);
    }

    private static boolean isFileValid(String xmlName) {
        return XMLAnalysesManagerPreferencePage.isFileValid(xmlName, XmlUtils.listFiles());
    }

    private static boolean isFileValid(String xmlName, Map<@NonNull String, @NonNull File> listFiles) {
        File file = listFiles.get(xmlName);
        return file != null && XmlUtils.xmlValidate((File)file).isOK();
    }

    private static Set<IEditorReference> getEditorReferences() {
        HashSet<IEditorReference> editorReferences = new HashSet<IEditorReference>();
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = wb.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow wbWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = wbWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage wbPage = iWorkbenchPageArray[n4];
                editorReferences.addAll(Arrays.asList(wbPage.getEditorReferences()));
                ++n4;
            }
            ++n2;
        }
        return editorReferences;
    }
}

