/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IIUAnalyzer;

public class IUCounting
implements IIUAnalyzer {
    int totalIUs = 0;
    int totalGroups = 0;
    int totalFragments = 0;
    int totalCategories = 0;

    private boolean hasProperty(IInstallableUnit iu, String property) {
        return Boolean.parseBoolean(iu.getProperty(property));
    }

    public void analyzeIU(IInstallableUnit iu) {
        ++this.totalIUs;
        if (this.hasProperty(iu, "org.eclipse.equinox.p2.type.fragment")) {
            ++this.totalFragments;
        }
        if (this.hasProperty(iu, "org.eclipse.equinox.p2.type.group")) {
            ++this.totalGroups;
        }
        if (this.hasProperty(iu, "org.eclipse.equinox.p2.type.category")) {
            ++this.totalCategories;
        }
    }

    public IStatus postAnalysis() {
        System.out.println("Total IUs: " + this.totalIUs);
        System.out.println("  Total Groups: " + this.totalGroups);
        System.out.println("  Total Fragments: " + this.totalFragments);
        System.out.println("  Total Categories: " + this.totalCategories);
        return null;
    }

    public void preAnalysis(IMetadataRepository repo) {
        this.totalIUs = 0;
        this.totalGroups = 0;
        this.totalFragments = 0;
        this.totalCategories = 0;
    }
}

