/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.persistence;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FConstants;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2FWriter
extends XMLWriter
implements P2FConstants {
    public P2FWriter(OutputStream output, XMLWriter.ProcessingInstruction[] piElements) throws UnsupportedEncodingException {
        super(output, piElements);
    }

    public void write(List<IUDetail> ius) {
        this.start("p2f");
        this.attribute("version", CURRENT_VERSION);
        this.writeIUs(ius);
        this.end("p2f");
        this.flush();
    }

    private void writeIUs(List<IUDetail> ius) {
        this.start("ius");
        this.attributeOptional("size", String.valueOf(ius.size()));
        for (IUDetail iu : ius) {
            this.writeIU(iu);
        }
        this.end("ius");
    }

    private void writeIU(IUDetail iu) {
        IInstallableUnit unit = iu.getIU();
        this.start("iu");
        this.attribute("id", unit.getId());
        this.attribute("name", unit.getProperty("org.eclipse.equinox.p2.name", Locale.getDefault().toString()));
        this.attribute("version", unit.getVersion().toString());
        this.start("repositories");
        this.attribute("size", iu.getReferencedRepositories().size());
        for (URI uri : iu.getReferencedRepositories()) {
            this.start("repository");
            String unencoded = URIUtil.toUnencodedString((URI)uri);
            this.attribute("location", unencoded);
            this.end("repository");
        }
        this.end("repositories");
        this.end("iu");
    }
}

