/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;

@NonNullByDefault
public class TransientState {
    private static final Logger LOGGER = TraceCompassLog.getLogger(TransientState.class);
    private final IStateHistoryBackend fBackend;
    private final ReentrantReadWriteLock fRWLock = new ReentrantReadWriteLock(false);
    private volatile boolean fIsActive;
    private volatile long fLatestTime;
    private List<@Nullable Object> fOngoingStateInfo;
    private List<Long> fOngoingStateStartTimes;
    private List<@Nullable Class<?>> fStateValueTypes;

    public TransientState(IStateHistoryBackend backend) {
        this.fBackend = backend;
        this.fIsActive = true;
        this.fOngoingStateInfo = new ArrayList<Object>();
        this.fOngoingStateStartTimes = new ArrayList<Long>();
        this.fStateValueTypes = new ArrayList();
        this.fLatestTime = backend.getStartTime();
    }

    public long getLatestTime() {
        return this.fLatestTime;
    }

    public @Nullable Object getOngoingStateValue(int quark) {
        this.fRWLock.readLock().lock();
        try {
            Object object = this.fOngoingStateInfo.get(quark);
            return object;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public long getOngoingStartTime(int quark) {
        this.fRWLock.readLock().lock();
        try {
            long l = this.fOngoingStateStartTimes.get(quark);
            return l;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public void changeOngoingStateValue(int quark, @Nullable Object newValue) {
        this.fRWLock.writeLock().lock();
        try {
            this.fOngoingStateInfo.set(quark, newValue);
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public ITmfStateInterval getOngoingInterval(int quark) {
        this.fRWLock.readLock().lock();
        try {
            TmfStateInterval tmfStateInterval = new TmfStateInterval(this.fOngoingStateStartTimes.get(quark), this.fLatestTime, quark, this.fOngoingStateInfo.get(quark));
            return tmfStateInterval;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public @Nullable ITmfStateInterval getIntervalAt(long time, int quark) {
        this.fRWLock.readLock().lock();
        try {
            if (!this.isActive() || time < this.fOngoingStateStartTimes.get(quark)) {
                return null;
            }
            TmfStateInterval tmfStateInterval = new TmfStateInterval(this.fOngoingStateStartTimes.get(quark), this.fLatestTime, quark, this.fOngoingStateInfo.get(quark));
            return tmfStateInterval;
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    public void replaceOngoingState(List<ITmfStateInterval> newStateIntervals) {
        int size = newStateIntervals.size();
        this.fRWLock.writeLock().lock();
        try {
            this.fOngoingStateInfo = new ArrayList<Object>(size);
            this.fOngoingStateStartTimes = new ArrayList<Long>(size);
            this.fStateValueTypes = new ArrayList(size);
            for (ITmfStateInterval interval : newStateIntervals) {
                Object value = interval.getValue();
                this.fOngoingStateInfo.add(value);
                this.fOngoingStateStartTimes.add(interval.getStartTime());
                Class<?> objectClass = value != null ? value.getClass() : null;
                this.fStateValueTypes.add(objectClass);
            }
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public void addEmptyEntry() {
        this.fRWLock.writeLock().lock();
        try {
            this.fOngoingStateInfo.add(null);
            this.fStateValueTypes.add(null);
            this.fOngoingStateStartTimes.add(this.fBackend.getStartTime());
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public void processStateChange(long eventTime, @Nullable Object value, int quark) throws TimeRangeException, StateValueTypeException {
        if (!this.fIsActive) {
            return;
        }
        this.fRWLock.writeLock().lock();
        try {
            Class<?> expectedSvType = this.fStateValueTypes.get(quark);
            if (expectedSvType == null) {
                this.fStateValueTypes.set(quark, value != null ? value.getClass() : null);
            } else if (value != null && value.getClass() != expectedSvType) {
                throw new StateValueTypeException(String.valueOf(this.fBackend.getSSID()) + " Quark:" + quark + ", Type:" + value.getClass() + ", Expected:" + expectedSvType);
            }
            if (Objects.equals(this.fOngoingStateInfo.get(quark), value)) {
                return;
            }
            if (this.fOngoingStateStartTimes.get(quark) < eventTime) {
                this.fBackend.insertPastState(this.fOngoingStateStartTimes.get(quark), eventTime - 1L, quark, this.fOngoingStateInfo.get(quark));
                this.fOngoingStateStartTimes.set(quark, eventTime);
            }
            this.fOngoingStateInfo.set(quark, value);
            if (this.fLatestTime < eventTime) {
                this.fLatestTime = eventTime;
            }
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public void doQuery(List<@Nullable ITmfStateInterval> stateInfo, long t) {
        this.fRWLock.readLock().lock();
        try {
            if (!this.fIsActive) {
                return;
            }
            if (stateInfo.size() > this.fOngoingStateInfo.size()) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < stateInfo.size()) {
                ITmfStateInterval interval = this.getIntervalAt(t, i);
                if (interval != null) {
                    stateInfo.set(i, interval);
                }
                ++i;
            }
        }
        finally {
            this.fRWLock.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public Iterable<ITmfStateInterval> query2D(Collection<Integer> quarks, TimeRangeCondition timeCondition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closeTransientState(long endTime) {
        if (!this.fIsActive) {
            return;
        }
        this.fRWLock.writeLock().lock();
        try {
            int i = 0;
            while (i < this.fOngoingStateInfo.size()) {
                if (this.fOngoingStateStartTimes.get(i) <= endTime) {
                    try {
                        this.fBackend.insertPastState(this.fOngoingStateStartTimes.get(i), endTime, i, this.fOngoingStateInfo.get(i));
                    }
                    catch (TimeRangeException e) {
                        throw new IllegalStateException(e);
                    }
                }
                ++i;
            }
            this.fOngoingStateInfo.clear();
            this.fOngoingStateStartTimes.clear();
            this.fIsActive = false;
        }
        finally {
            this.fRWLock.writeLock().unlock();
        }
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public void setInactive() {
        this.fIsActive = false;
    }

    public void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Info stored in the Builder:");
        if (!this.fIsActive) {
            writer.println("Builder is currently inactive");
            writer.println('\n');
            return;
        }
        writer.println("\nAttribute\tStateValue\tValid since time");
        int i = 0;
        while (i < this.fOngoingStateInfo.size()) {
            writer.format("%d\t\t", i);
            writer.print(String.valueOf(String.valueOf(this.fOngoingStateInfo.get(i))) + "\t\t");
            writer.println(this.fOngoingStateStartTimes.get(i).toString());
            ++i;
        }
        writer.println('\n');
    }
}

