/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tracing.rcp.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.cli.CliParser;
import org.eclipse.tracecompass.internal.tracing.rcp.ui.cli.TracingRCPCliException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TracingRcpPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tracecompass.rcp.ui";
    public static final String WORKSPACE_NAME = ".tracecompass";
    private static TracingRcpPlugin fPlugin;
    private static CliParser fCli;

    public static TracingRcpPlugin getDefault() {
        return fPlugin;
    }

    public static String getWorkspaceRoot() {
        String workspaceRoot = System.getenv().get("TRACING_RCP_ROOT");
        if (workspaceRoot == null) {
            workspaceRoot = System.getProperty("user.home");
        }
        return workspaceRoot;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        fPlugin = this;
        String[] args = Platform.getCommandLineArgs();
        fCli = null;
        try {
            fCli = new CliParser(args);
        }
        catch (TracingRCPCliException e) {
            this.logError(e.getMessage());
        }
    }

    public void stop(BundleContext context) throws Exception {
        fPlugin = null;
        super.stop(context);
    }

    public CliParser getCli() {
        return fCli;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return TracingRcpPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void logError(String message) {
        TracingRcpPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public void logError(String message, Exception e) {
        TracingRcpPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, (Throwable)e));
    }

    public void logWarning(String message) {
        TracingRcpPlugin.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }
}

