/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.latency;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.latency.SystemCallLatencyScatterView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.ui.IViewPart;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.swtchart.Chart;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class SystemCallLatencyScatterChartViewTest
extends XYDataProviderBaseTest {
    private static final @NonNull String TITLE = "Duration vs Time";
    private static final @NonNull String SERIES1_NAME = "bug446190/clock_gettime";
    private static final @NonNull String SERIES2_NAME = "bug446190/ioctl";
    private static final String VIEW_ID = "org.eclipse.tracecompass.analysis.os.linux.views.latency.scatter";

    @Test
    public void testWithTrace() {
        SWTBotTreeItem[] items;
        WaitUtils.waitForJobs();
        IViewPart viewPart = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof SystemCallLatencyScatterView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)SystemCallLatencyScatterChartViewTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        SWTBotUtils.waitUntil(bot -> bot.tree().visibleRowCount() >= 25, (Object)this.getSWTBotView().bot(), (String)("Missing rows, expected 25, was " + this.getSWTBotView().bot().tree().visibleRowCount()));
        SWTBotTreeItem[] sWTBotTreeItemArray = items = this.getSWTBotView().bot().tree().getAllItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            item.check();
            ++n2;
        }
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 24, (Object)chart, (String)"No data available");
        this.verifyChartStyle();
        long noDataStart = 1412670961274443542L;
        long noDataEnd = 1412670961298823940L;
        TmfTimeRange windowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)noDataStart), TmfTimestamp.fromNanos((long)noDataEnd));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, windowRange));
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)windowRange));
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        items = this.getSWTBotView().bot().tree().getAllItems();
        Assert.assertEquals((long)1L, (long)items.length);
    }

    private void verifyChartStyle() {
        this.verifySeriesStyle(SERIES1_NAME, ISeries.SeriesType.LINE, null, LineStyle.NONE, false);
        this.verifySeriesStyle(SERIES2_NAME, ISeries.SeriesType.LINE, null, LineStyle.NONE, false);
    }

    protected @NonNull String getMainSeriesName() {
        return SERIES2_NAME;
    }

    protected @NonNull String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return VIEW_ID;
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
    }

    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
    }
}

