/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DataDrivenXYDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeXYDataProvider<ITmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider";
    private static final String TITLE = Objects.requireNonNull(Messages.XmlDataProvider_DefaultXYTitle);
    private static final AtomicLong ENTRY_IDS = new AtomicLong();
    private final Table<ITmfStateSystem, Integer, Long> fBaseQuarkToId = HashBasedTable.create();
    private final Map<Long, DisplayElement> fIDToDisplayQuark = new HashMap<Long, DisplayElement>();
    private final Map<Long, String> fIdToTitle = new HashMap<Long, String>();
    private final DataDrivenOutputEntry.IdGetter fIdGenerator = (ss, quark) -> this.fBaseQuarkToId.row((Object)ss).computeIfAbsent(quark, s -> ENTRY_IDS.getAndIncrement());
    private final DataDrivenOutputEntry.QuarkCallback fQuarkCallback = (id, ss, quark, displayType) -> {
        DisplayElement displayElement = this.fIDToDisplayQuark.put(id, new DisplayElement(ss, quark, displayType));
    };
    private final List<ITmfStateSystem> fSs;
    private final List<DataDrivenOutputEntry> fEntries;
    private final String fId;
    private @Nullable TmfModelResponse<List<ITmfTreeDataModel>> fCached;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock(false);

    public DataDrivenXYDataProvider(ITmfTrace trace, List<ITmfStateSystem> stateSystems, List<DataDrivenOutputEntry> entries, @Nullable String id2) {
        super(trace);
        this.fSs = stateSystems;
        this.fEntries = entries;
        this.fId = id2 == null ? ID : id2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public TmfModelResponse<ITmfXyModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        long[] xValues = filter.getTimesRequested();
        if (!(filter instanceof SelectionTimeQueryFilter)) {
            return TmfXyResponseFactory.create((String)TITLE, (long[])xValues, Collections.emptyMap(), (boolean)true);
        }
        Map<DisplayElement, IYModel> map = this.initSeries(filter);
        if (map.isEmpty()) {
            return TmfXyResponseFactory.create((String)TITLE, (long[])xValues, Collections.emptyMap(), (boolean)true);
        }
        ITmfStateSystem ss = null;
        for (DisplayElement de : map.keySet()) {
            ss = de.fStateSystem;
        }
        if (ss == null) {
            return TmfXyResponseFactory.create((String)TITLE, (long[])xValues, Collections.emptyMap(), (boolean)true);
        }
        long currentEnd = ss.getCurrentEndTime();
        try {
            int i = 0;
            while (i < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfXyResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i];
                if (time > currentEnd) break;
                if (ss.getStartTime() <= time) {
                    @NonNull List full = ss.queryFullState(time);
                    for (Map.Entry<DisplayElement, IYModel> series : map.entrySet()) {
                        int attributeQuark = series.getKey().fQuark;
                        if (attributeQuark < 0 || attributeQuark >= full.size()) continue;
                        Object value = ((ITmfStateInterval)full.get(attributeQuark)).getValue();
                        series.getValue().getData()[i] = DataDrivenXYDataProvider.extractValue(value);
                    }
                }
                ++i;
            }
            for (Map.Entry<DisplayElement, IYModel> series : map.entrySet()) {
                if (!series.getKey().fDisplayType.equals((Object)DisplayType.DELTA)) continue;
                DataDrivenXYDataProvider.getSeriesDelta(series.getValue().getData());
            }
        }
        catch (StateSystemDisposedException e) {
            return TmfXyResponseFactory.createFailedResponse((String)e.getMessage());
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfXyResponseFactory.create((String)TITLE, (long[])xValues, (Map)Maps.uniqueIndex(map.values(), IYModel::getName), (boolean)complete);
    }

    private static void getSeriesDelta(double[] data) {
        double prevData = data[0];
        data[0] = 0.0;
        int i = 1;
        while (i < data.length) {
            double current = data[i];
            data[i] = current - prevData;
            prevData = current;
            ++i;
        }
        data[0] = data[1];
    }

    private Map<DisplayElement, IYModel> initSeries(TimeQueryFilter filter) {
        if (!(filter instanceof SelectionTimeQueryFilter)) {
            return Collections.emptyMap();
        }
        this.fLock.readLock().lock();
        try {
            HashMap<DisplayElement, IYModel> map = new HashMap<DisplayElement, IYModel>();
            int length = filter.getTimesRequested().length;
            for (Long id : ((SelectionTimeQueryFilter)filter).getSelectedItems()) {
                DisplayElement displayElement = this.fIDToDisplayQuark.get(id);
                if (displayElement == null) continue;
                String name = String.valueOf(this.fIdToTitle.get(id));
                map.put(displayElement, (IYModel)new YModel(id.longValue(), name, new double[length]));
            }
            HashMap<DisplayElement, IYModel> hashMap = map;
            return hashMap;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    private static double extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return 0.0;
    }

    public TmfModelResponse<List<ITmfTreeDataModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        this.fLock.readLock().lock();
        try {
            if (this.fCached != null) {
                TmfModelResponse<List<ITmfTreeDataModel>> tmfModelResponse = this.fCached;
                return tmfModelResponse;
            }
        }
        finally {
            this.fLock.readLock().unlock();
        }
        ArrayList<TimeGraphEntryModel> entryList = new ArrayList<TimeGraphEntryModel>();
        boolean isComplete = true;
        String traceName = String.valueOf(this.getTrace().getName());
        this.fLock.writeLock().lock();
        try {
            for (ITmfStateSystem ss : this.fSs) {
                isComplete &= ss.waitUntilBuilt(0L);
                if (ss.getNbAttributes() <= 0 || ss.getStartTime() == Long.MIN_VALUE) continue;
                long start = ss.getStartTime();
                long end = ss.getCurrentEndTime();
                long id = this.fBaseQuarkToId.row((Object)ss).computeIfAbsent(-1, s -> ENTRY_IDS.getAndIncrement());
                TimeGraphEntryModel ssEntry = new TimeGraphEntryModel(id, -1L, traceName, start, end);
                entryList.add(ssEntry);
                for (DataDrivenOutputEntry entry : this.fEntries) {
                    entryList.addAll(entry.buildEntries(ss, ssEntry.getId(), this.getTrace(), -1, "", end, this.fIdGenerator, this.fQuarkCallback));
                }
            }
            this.fIdToTitle.clear();
            entryList.forEach(e -> {
                String string = this.fIdToTitle.put(e.getId(), e.getName());
            });
            if (isComplete) {
                TmfModelResponse tmfModelResponse;
                this.fCached = tmfModelResponse = new TmfModelResponse(entryList, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                TmfModelResponse tmfModelResponse2 = tmfModelResponse;
                return tmfModelResponse2;
            }
            TmfModelResponse tmfModelResponse = new TmfModelResponse(entryList, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
            return tmfModelResponse;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public String getId() {
        return this.fId;
    }

    private static class DisplayElement {
        private final ITmfStateSystem fStateSystem;
        private final int fQuark;
        private final DisplayType fDisplayType;

        public DisplayElement(ITmfStateSystem stateSystem, int quark, DisplayType displayType) {
            this.fStateSystem = stateSystem;
            this.fQuark = quark;
            this.fDisplayType = displayType;
        }
    }

    public static enum DisplayType {
        ABSOLUTE,
        DELTA;

    }
}

