/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenPresentationState;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.IRegexQuery;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.TimeGraphStateQueryFilter;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class DataDrivenTimeGraphDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<TimeGraphEntryModel> {
    public static final String ID = "org.eclipse.tracecompass.tmf.analysis.xml.core.output.DataDrivenTimeGraphDataProvider";
    private static final AtomicLong sfAtomicId = new AtomicLong();
    private final List<ITmfStateSystem> fSs;
    private final List<DataDrivenOutputEntry> fEntries;
    private final List<DataDrivenPresentationState> fValues;
    private final Table<ITmfStateSystem, Integer, Long> fBaseQuarkToId = HashBasedTable.create();
    private final Map<Long, Pair<ITmfStateSystem, Integer>> fIDToDisplayQuark = new HashMap<Long, Pair<ITmfStateSystem, Integer>>();
    private final DataDrivenOutputEntry.IdGetter fIdGenerator = (ss, quark) -> this.fBaseQuarkToId.row((Object)ss).computeIfAbsent(quark, s -> sfAtomicId.getAndIncrement());
    private final DataDrivenOutputEntry.QuarkCallback fQuarkCallback = (id, ss, quark, dt) -> {
        Pair<ITmfStateSystem, Integer> pair = this.fIDToDisplayQuark.put(id, (Pair<ITmfStateSystem, Integer>)new Pair((Object)ss, (Object)quark));
    };
    private final String fId;

    public DataDrivenTimeGraphDataProvider(ITmfTrace trace, List<ITmfStateSystem> stateSystems, List<DataDrivenOutputEntry> entries, List<DataDrivenPresentationState> values, @Nullable String id2) {
        super(trace);
        this.fSs = stateSystems;
        this.fEntries = entries;
        this.fValues = values;
        this.fId = id2 == null ? ID : id2;
    }

    public TmfModelResponse<@NonNull List<TimeGraphEntryModel>> fetchTree(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        ArrayList<TimeGraphEntryModel> entryList = new ArrayList<TimeGraphEntryModel>();
        boolean isComplete = true;
        String traceName = String.valueOf(this.getTrace().getName());
        for (ITmfStateSystem ss : this.fSs) {
            isComplete &= ss.waitUntilBuilt(0L);
            if (ss.getNbAttributes() <= 0 || ss.getStartTime() == Long.MIN_VALUE) continue;
            long start = ss.getStartTime();
            long end = ss.getCurrentEndTime();
            long id = this.fBaseQuarkToId.row((Object)ss).computeIfAbsent(-1, s -> sfAtomicId.getAndIncrement());
            TimeGraphEntryModel ssEntry = new TimeGraphEntryModel(id, -1L, traceName, start, end);
            entryList.add(ssEntry);
            for (DataDrivenOutputEntry entry : this.fEntries) {
                entryList.addAll(entry.buildEntries(ss, ssEntry.getId(), this.getTrace(), -1, "", end, this.fIdGenerator, this.fQuarkCallback));
            }
        }
        ITmfResponse.Status status = isComplete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING;
        String msg = isComplete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING;
        return new TmfModelResponse(entryList, status, msg);
    }

    public @NonNull String getId() {
        return this.fId;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphRowModel>> fetchRowModel(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        HashBasedTable table = HashBasedTable.create();
        for (Long id : filter.getSelectedItems()) {
            Pair<ITmfStateSystem, Integer> pair = this.fIDToDisplayQuark.get(id);
            if (pair == null) continue;
            table.put((Object)((ITmfStateSystem)pair.getFirst()), (Object)((Integer)pair.getSecond()), (Object)id);
        }
        ArrayList<@NonNull ITimeGraphRowModel> allRows = new ArrayList<ITimeGraphRowModel>();
        try {
            for (Map.Entry ssEntry : table.rowMap().entrySet()) {
                Collection<@NonNull ITimeGraphRowModel> rows = this.createRows((ITmfStateSystem)ssEntry.getKey(), (Map)ssEntry.getValue(), filter.getTimesRequested(), filter, monitor);
                allRows.addAll(rows);
            }
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        return new TmfModelResponse(allRows, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Collection<ITimeGraphRowModel> createRows(ITmfStateSystem ss, Map<Integer, Long> idToDisplayQuark, long[] timesRequested, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        if (filter instanceof TimeGraphStateQueryFilter) {
            TimeGraphStateQueryFilter timeEventFilter = (TimeGraphStateQueryFilter)filter;
            predicates.putAll(this.computeRegexPredicate((IRegexQuery)timeEventFilter));
        }
        long currentEndTime = ss.getCurrentEndTime();
        HashMap<Integer, TimeGraphRowModel> quarkToRow = new HashMap<Integer, TimeGraphRowModel>(idToDisplayQuark.size());
        for (Map.Entry<Integer, Long> entry : idToDisplayQuark.entrySet()) {
            quarkToRow.put(entry.getKey(), new TimeGraphRowModel(entry.getValue().longValue(), new ArrayList()));
        }
        for (ITmfStateInterval interval : ss.query2D(idToDisplayQuark.keySet(), DataDrivenTimeGraphDataProvider.getTimes(ss, timesRequested))) {
            if (monitor != null && monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ITimeGraphRowModel row = (ITimeGraphRowModel)quarkToRow.get(interval.getAttribute());
            if (row == null) continue;
            @NonNull List states = row.getStates();
            TimeGraphState timeGraphState = DataDrivenTimeGraphDataProvider.getStateFromInterval(interval, currentEndTime);
            this.applyFilterAndAddState(states, (ITimeGraphState)timeGraphState, row.getEntryID(), predicates, monitor);
        }
        for (ITimeGraphRowModel model : quarkToRow.values()) {
            model.getStates().sort(Comparator.comparingLong(ITimeGraphState::getStartTime));
        }
        return quarkToRow.values();
    }

    private static TimeGraphState getStateFromInterval(ITmfStateInterval statusInterval, long currentEndTime) {
        long time = statusInterval.getStartTime();
        long duration = Math.min(currentEndTime, statusInterval.getEndTime() + 1L) - time;
        Object o = statusInterval.getValue();
        if (o instanceof Integer) {
            return new TimeGraphState(time, duration, ((Integer)o).intValue(), String.valueOf(o));
        }
        if (o instanceof Long) {
            long l = (Long)o;
            return new TimeGraphState(time, duration, (int)l, "0x" + Long.toHexString(l));
        }
        if (o instanceof String) {
            return new TimeGraphState(time, duration, Integer.MIN_VALUE, (String)o);
        }
        if (o instanceof Double) {
            return new TimeGraphState(time, duration, ((Double)o).intValue());
        }
        return new TimeGraphState(time, duration, Integer.MIN_VALUE);
    }

    private static Set<Long> getTimes(ITmfStateSystem key, long[] timesRequested) {
        HashSet<@NonNull Long> times = new HashSet<Long>();
        long[] lArray = timesRequested;
        int n = timesRequested.length;
        int n2 = 0;
        while (n2 < n) {
            long t = lArray[n2];
            if (key.getStartTime() <= t && t <= key.getCurrentEndTime()) {
                times.add(t);
            }
            ++n2;
        }
        return times;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    protected List<DataDrivenPresentationState> getValues() {
        return this.fValues;
    }
}

