/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.analysis;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.IViewDescriptor;

public class TmfAnalysisViewOutput
implements IAnalysisOutput,
IExecutableExtension {
    private String fViewId;
    private final @Nullable String fSecondaryId;
    private final Map<String, String> fProperties = new HashMap<String, String>();

    public TmfAnalysisViewOutput() {
        this.fSecondaryId = null;
    }

    public TmfAnalysisViewOutput(String viewid) {
        this.fViewId = viewid;
        this.fSecondaryId = null;
    }

    public TmfAnalysisViewOutput(String viewid, String secondaryId) {
        this.fViewId = viewid;
        this.fSecondaryId = secondaryId;
    }

    public String getViewId() {
        return this.fViewId;
    }

    public String getName() {
        IViewDescriptor descr = PlatformUI.getWorkbench().getViewRegistry().find(this.fViewId);
        String viewName = descr != null ? descr.getLabel() : String.valueOf(this.fViewId) + Messages.TmfAnalysisViewOutput_ViewUnavailable;
        return viewName;
    }

    protected IViewPart openView() throws PartInitException {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        String viewId = this.fViewId;
        String secondaryId = this.fSecondaryId;
        if (secondaryId != null) {
            viewId = String.valueOf(viewId) + ':' + secondaryId;
        }
        return activePage.showView(viewId);
    }

    public void requestOutput() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewPart view = TmfAnalysisViewOutput.this.openView();
                    if (!TmfAnalysisViewOutput.this.fProperties.isEmpty() && view instanceof WorkbenchPart) {
                        WorkbenchPart wbPart = (WorkbenchPart)view;
                        for (String key : TmfAnalysisViewOutput.this.fProperties.keySet()) {
                            wbPart.setPartProperty(key, (String)TmfAnalysisViewOutput.this.fProperties.get(key));
                        }
                    }
                }
                catch (PartInitException e) {
                    TraceUtils.displayErrorMsg(Messages.TmfAnalysisViewOutput_Title, "Error opening view " + TmfAnalysisViewOutput.this.getName() + e.getMessage());
                    Activator.getDefault().logError("Error opening view " + TmfAnalysisViewOutput.this.getName(), e);
                }
            }
        });
    }

    public void setOutputProperty(@NonNull String key, String value, boolean immediate) {
        if (value == null) {
            this.fProperties.remove(key);
        } else {
            IWorkbench wb;
            IWorkbenchPage activePage;
            IViewPart view;
            this.fProperties.put(key, value);
            if (immediate && (view = (activePage = (wb = PlatformUI.getWorkbench()).getActiveWorkbenchWindow().getActivePage()).findView(this.fViewId)) instanceof WorkbenchPart) {
                ((WorkbenchPart)view).setPartProperty(key, value);
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fViewId = config.getAttribute("id");
    }
}

