/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics;

import com.google.common.collect.ImmutableList;
import java.text.Format;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.statistics.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public abstract class AbstractSegmentsStatisticsViewer
extends AbstractTmfTreeViewer {
    private static final Format FORMATTER = new SubSecondTimeWithUnitFormat();
    private @Nullable TmfAbstractAnalysisModule fModule;
    private MenuManager fTablePopupMenuManager;
    private @Nullable String fProviderId;

    public AbstractSegmentsStatisticsViewer(Composite parent, @Nullable String dataProviderId) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new SegmentStoreStatisticsLabelProvider());
        this.fTablePopupMenuManager = new MenuManager();
        this.fTablePopupMenuManager.setRemoveAllWhenShown(true);
        this.fTablePopupMenuManager.addMenuListener(manager -> {
            TreeViewer viewer = this.getTreeViewer();
            ISelection selection = viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (manager != null) {
                    this.appendToTablePopupMenu(manager, sel);
                }
            }
        });
        Menu tablePopup = this.fTablePopupMenuManager.createContextMenu((Control)this.getTreeViewer().getTree());
        Tree tree = this.getTreeViewer().getTree();
        tree.setMenu(tablePopup);
        tree.addDisposeListener(e -> {
            if (this.fModule != null) {
                this.fModule.dispose();
            }
        });
        this.fProviderId = dataProviderId;
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> ImmutableList.of((Object)AbstractSegmentsStatisticsViewer.createTmfTreeColumnData(Messages.SegmentStoreStatistics_LevelLabel, Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)AbstractSegmentsStatisticsViewer.createTmfTreeColumnData(Messages.SegmentStoreStatistics_Statistics_MinLabel, Comparator.comparing(AbstractSegmentsStatisticsViewer.keyExtractor(SegmentStoreStatisticsModel::getMin))), (Object)AbstractSegmentsStatisticsViewer.createTmfTreeColumnData(Messages.SegmentStoreStatistics_MaxLabel, Comparator.comparing(AbstractSegmentsStatisticsViewer.keyExtractor(SegmentStoreStatisticsModel::getMax))), (Object)AbstractSegmentsStatisticsViewer.createTmfTreeColumnData(Messages.SegmentStoreStatistics_AverageLabel, Comparator.comparing(AbstractSegmentsStatisticsViewer.keyExtractor(SegmentStoreStatisticsModel::getMean))), (Object)AbstractSegmentsStatisticsViewer.createTmfTreeColumnData(Messages.SegmentStoreStatisticsViewer_StandardDeviation, Comparator.comparing(AbstractSegmentsStatisticsViewer.keyExtractor(SegmentStoreStatisticsModel::getStdDev))), (Object)AbstractSegmentsStatisticsViewer.createTmfTreeColumnData(Messages.SegmentStoreStatisticsViewer_Count, Comparator.comparing(AbstractSegmentsStatisticsViewer.keyExtractor(SegmentStoreStatisticsModel::getNbElements))), (Object)AbstractSegmentsStatisticsViewer.createTmfTreeColumnData(Messages.SegmentStoreStatisticsViewer_Total, Comparator.comparing(AbstractSegmentsStatisticsViewer.keyExtractor(SegmentStoreStatisticsModel::getTotal))), (Object)new TmfTreeColumnData(""));
    }

    private static TmfTreeColumnData createTmfTreeColumnData(@Nullable String name, final Comparator<TmfTreeViewerEntry> comparator) {
        TmfTreeColumnData column = new TmfTreeColumnData(name);
        column.setAlignment(131072);
        column.setComparator(new ViewerComparator(){

            public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                if (e1 == null || e2 == null) {
                    return 0;
                }
                TmfTreeViewerEntry n1 = (TmfTreeViewerEntry)e1;
                TmfTreeViewerEntry n2 = (TmfTreeViewerEntry)e2;
                return comparator.compare(n1, n2);
            }
        });
        return column;
    }

    private static <E extends Comparable<E>, M extends SegmentStoreStatisticsModel> Function<TmfTreeViewerEntry, E> keyExtractor(final Function<M, E> modelExtractor) {
        return new Function<TmfTreeViewerEntry, E>(){

            @Override
            public E apply(TmfTreeViewerEntry entry) {
                if (entry instanceof TmfGenericTreeEntry) {
                    return (Comparable)modelExtractor.apply((SegmentStoreStatisticsModel)((TmfGenericTreeEntry)entry).getModel());
                }
                return (Comparable<Comparable>)o -> 0;
            }
        };
    }

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
        final Object element = sel.getFirstElement();
        if (element instanceof TmfGenericTreeEntry) {
            Action gotoStartTime = new Action(Messages.SegmentStoreStatisticsViewer_GotoMinAction){

                public void run() {
                    if (!(element instanceof TmfGenericTreeEntry)) {
                        return;
                    }
                    SegmentStoreStatisticsModel model = (SegmentStoreStatisticsModel)((TmfGenericTreeEntry)element).getModel();
                    long start = model.getMinStart();
                    long end = model.getMinEnd();
                    AbstractSegmentsStatisticsViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentsStatisticsViewer.this, TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end), AbstractSegmentsStatisticsViewer.this.getTrace()));
                    AbstractSegmentsStatisticsViewer.this.updateContent(start, end, true);
                }
            };
            Action gotoEndTime = new Action(Messages.SegmentStoreStatisticsViewer_GotoMaxAction){

                public void run() {
                    if (!(element instanceof TmfGenericTreeEntry)) {
                        return;
                    }
                    SegmentStoreStatisticsModel model = (SegmentStoreStatisticsModel)((TmfGenericTreeEntry)element).getModel();
                    long start = model.getMaxStart();
                    long end = model.getMaxEnd();
                    AbstractSegmentsStatisticsViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentsStatisticsViewer.this, TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end), AbstractSegmentsStatisticsViewer.this.getTrace()));
                    AbstractSegmentsStatisticsViewer.this.updateContent(start, end, true);
                }
            };
            manager.add((IAction)gotoStartTime);
            manager.add((IAction)gotoEndTime);
        }
    }

    protected static String toFormattedString(double value) {
        return String.format("%s", FORMATTER.format(value));
    }

    protected @Nullable ITmfTreeViewerEntry updateElements(ITmfTrace trace, long start, long end, boolean isSelection) {
        ITmfTreeDataProvider provider = null;
        String providerId = this.fProviderId;
        if (providerId != null) {
            provider = DataProviderManager.getInstance().getDataProvider(trace, this.fProviderId, ITmfTreeDataProvider.class);
        }
        TmfAbstractAnalysisModule analysisModule = this.fModule;
        if (provider == null && analysisModule instanceof AbstractSegmentStatisticsAnalysis && trace.equals(analysisModule.getTrace())) {
            AbstractSegmentStatisticsAnalysis module = (AbstractSegmentStatisticsAnalysis)analysisModule;
            provider = SegmentStoreStatisticsDataProvider.getOrCreate((ITmfTrace)trace, (AbstractSegmentStatisticsAnalysis)module);
        }
        if (provider == null) {
            return null;
        }
        FilterTimeQueryFilter filter = new FilterTimeQueryFilter(start, end, 2, isSelection);
        TmfModelResponse response = provider.fetchTree((TimeQueryFilter)filter, null);
        List model = (List)response.getModel();
        if (model == null) {
            return null;
        }
        return AbstractSegmentsStatisticsViewer.modelToTree(trace.getName(), model);
    }

    private static @Nullable TmfTreeViewerEntry modelToTree(String traceName, List<SegmentStoreStatisticsModel> model) {
        TmfTreeViewerEntry root = new TmfTreeViewerEntry(traceName);
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        map.put(-1L, root);
        for (TmfTreeDataModel tmfTreeDataModel : model) {
            Object viewerEntry = tmfTreeDataModel.getParentId() != -1L ? new TmfGenericTreeEntry((ITmfTreeDataModel)tmfTreeDataModel) : new TmfTreeViewerEntry(tmfTreeDataModel.getName());
            map.put(tmfTreeDataModel.getId(), viewerEntry);
            TmfTreeViewerEntry parent = (TmfTreeViewerEntry)map.get(tmfTreeDataModel.getParentId());
            if (parent == null || parent.getChildren().contains(viewerEntry)) continue;
            parent.addChild((TmfTreeViewerEntry)viewerEntry);
        }
        return root;
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
    }

    protected void setSelectionRange(long selectionBeginTime, long selectionEndTime) {
        super.setSelectionRange(selectionBeginTime, selectionEndTime);
        this.updateContent(selectionBeginTime, selectionEndTime, true);
    }

    protected String getTypeLabel() {
        return Objects.requireNonNull(Messages.AbstractSegmentStoreStatisticsViewer_types);
    }

    protected String getTotalLabel() {
        return Objects.requireNonNull(Messages.AbstractSegmentStoreStatisticsViewer_total);
    }

    protected String getSelectionLabel() {
        return Objects.requireNonNull(Messages.AbstractSegmentStoreStatisticsViewer_selection);
    }

    public void setProviderId(String newProviderId) {
        this.fProviderId = newProviderId;
    }

    protected static class SegmentStoreStatisticsLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected SegmentStoreStatisticsLabelProvider() {
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof TmfTreeViewerEntry) {
                return String.valueOf(((TmfTreeViewerEntry)element).getName());
            }
            if (element instanceof TmfGenericTreeEntry) {
                SegmentStoreStatisticsModel model = (SegmentStoreStatisticsModel)((TmfGenericTreeEntry)element).getModel();
                if (model.getNbElements() == 0L) {
                    return "";
                }
                if (columnIndex == 1) {
                    return AbstractSegmentsStatisticsViewer.toFormattedString(model.getMin());
                }
                if (columnIndex == 2) {
                    return String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(model.getMax()));
                }
                if (columnIndex == 3) {
                    return String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(model.getMean()));
                }
                if (columnIndex == 4) {
                    return String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(model.getStdDev()));
                }
                if (columnIndex == 5) {
                    return String.valueOf(model.getNbElements());
                }
                if (columnIndex == 6) {
                    return String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(model.getTotal()));
                }
            }
            return "";
        }
    }
}

