/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.segmentstore.core.IContentSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;

public interface ISegmentStoreProvider {
    public void addListener(IAnalysisProgressListener var1);

    public void removeListener(IAnalysisProgressListener var1);

    public Iterable<ISegmentAspect> getSegmentAspects();

    public @Nullable ISegmentStore<ISegment> getSegmentStore();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Multimap<String, String> getFilterInput(ISegmentStoreProvider provider, ISegment segment) {
        HashMultimap map = HashMultimap.create();
        for (ISegmentAspect aspect : provider.getSegmentAspects()) {
            Object resolve = aspect.resolve(segment);
            if (resolve == null) continue;
            map.put((Object)aspect.getName(), (Object)String.valueOf(resolve));
        }
        if (segment instanceof IContentSegment) {
            @NonNull Map content = ((IContentSegment)segment).getContent();
            for (Map.Entry val : content.entrySet()) {
                map.put((Object)((String)val.getKey()), (Object)String.valueOf(val.getValue()));
            }
        }
        return map;
    }
}

