/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackEntryModel;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.IRegexQuery;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.TimeGraphStateQueryFilter;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class CallStackDataProvider
extends AbstractTimeGraphDataProvider<CallStackAnalysis, CallStackEntryModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.analysis.profiling.callstack.provider.CallStackDataProvider";
    private static final int UNKNOWN_TID = -1;
    private final Map<Integer, Integer> fQuarkToPid = new HashMap<Integer, Integer>();
    private final @NonNull Collection<@NonNull ISymbolProvider> fProviders = new ArrayList<ISymbolProvider>();
    private final LoadingCache<Pair<Integer, ITmfStateInterval>, @Nullable String> fTimeEventNames = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Pair<Integer, ITmfStateInterval>, String>(){

        public @Nullable String load(Pair<Integer, ITmfStateInterval> pidInterval) {
            Integer pid = (Integer)pidInterval.getFirst();
            ITmfStateInterval interval = (ITmfStateInterval)pidInterval.getSecond();
            Object nameValue = interval.getValue();
            Long address = null;
            String name = null;
            if (nameValue instanceof String) {
                name = (String)nameValue;
                try {
                    address = Long.parseLong(name, 16);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (nameValue instanceof Integer) {
                Integer intValue = (Integer)nameValue;
                name = "0x" + Integer.toUnsignedString(intValue, 16);
                address = intValue.longValue();
            } else if (nameValue instanceof Long) {
                address = (long)((Long)nameValue);
                name = "0x" + Long.toUnsignedString(address, 16);
            }
            if (address != null) {
                name = SymbolProviderUtils.getSymbolText((Collection)CallStackDataProvider.this.fProviders, (int)pid, (long)interval.getStartTime(), (long)address);
            }
            return name;
        }
    });

    public CallStackDataProvider(@NonNull ITmfTrace trace, @NonNull CallStackAnalysis module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected List<CallStackEntryModel> getTree(ITmfStateSystem ss, TimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        ImmutableList.Builder builder = ImmutableList.builder();
        long traceId = this.getId(-1);
        builder.add((Object)new CallStackEntryModel(traceId, -1L, this.getTrace().getName(), start, end, -2, -1));
        List processQuarks = ss.getQuarks(((CallStackAnalysis)this.getAnalysisModule()).getProcessesPattern());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#fetchTree", (int)processQuarks.size());
        @NonNull List fullStart = ss.queryFullState(start);
        @NonNull List fullEnd = ss.queryFullState(end);
        Iterator iterator = processQuarks.iterator();
        while (iterator.hasNext()) {
            int processQuark = (Integer)iterator.next();
            long threadParentId = traceId;
            int pid = -1;
            if (processQuark != -1) {
                threadParentId = this.getId(processQuark);
                String processName = ss.getAttributeName(processQuark);
                Object processValue = ((ITmfStateInterval)fullEnd.get(processQuark)).getValue();
                pid = CallStackDataProvider.getThreadProcessId(processName, processValue);
                builder.add((Object)new CallStackEntryModel(threadParentId, traceId, processName, start, end, -1, pid));
            }
            List threadQuarks = ss.getQuarks(processQuark, ((CallStackAnalysis)this.getAnalysisModule()).getThreadsPattern());
            Iterator iterator2 = threadQuarks.iterator();
            while (iterator2.hasNext()) {
                int threadQuark = (Integer)iterator2.next();
                int callStackQuark = ss.optQuarkRelative(threadQuark, new String[]{"CallStack"});
                if (callStackQuark == -2) continue;
                String threadName = ss.getAttributeName(threadQuark);
                long callStackParent = threadParentId;
                if (threadQuark != processQuark) {
                    CallStackEntryModel thread = this.createThread(ss, start, end, threadQuark, threadParentId, callStackQuark, fullStart, fullEnd);
                    callStackParent = thread.getId();
                    builder.add((Object)thread);
                }
                List callStackAttributes = ss.getSubAttributes(callStackQuark, false);
                this.createStackEntries(callStackAttributes, start, end, pid, threadName, callStackParent, (ImmutableList.Builder<CallStackEntryModel>)builder);
            }
            subMonitor.worked(1);
        }
        return builder.build();
    }

    private CallStackEntryModel createThread(ITmfStateSystem ss, long start, long end, int threadQuark, long processId, int callStackQuark, List<ITmfStateInterval> fullStart, List<ITmfStateInterval> fullEnd) {
        String threadName = ss.getAttributeName(threadQuark);
        long threadEnd = end + 1L;
        ITmfStateInterval endInterval = fullEnd.get(callStackQuark);
        if (endInterval.getValue() == null && endInterval.getStartTime() != ss.getStartTime()) {
            threadEnd = endInterval.getStartTime();
        }
        Object threadStateValue = fullEnd.get(threadQuark).getValue();
        int threadId = CallStackDataProvider.getThreadProcessId(threadName, threadStateValue);
        ITmfStateInterval startInterval = fullStart.get(callStackQuark);
        long threadStart = startInterval.getValue() == null ? Long.min(startInterval.getEndTime() + 1L, end) : start;
        return new CallStackEntryModel(this.getId(threadQuark), processId, threadName, threadStart, threadEnd, 0, threadId);
    }

    private void createStackEntries(List<Integer> callStackAttributes, long start, long end, int pid, String threadName, long callStackParent, ImmutableList.Builder<CallStackEntryModel> builder) {
        int level = 1;
        for (int stackLevelQuark : callStackAttributes) {
            long id = this.getId(stackLevelQuark);
            builder.add((Object)new CallStackEntryModel(id, callStackParent, threadName, start, end, level, pid));
            this.fQuarkToPid.put(stackLevelQuark, pid);
            ++level;
        }
    }

    private static int getThreadProcessId(String name, @Nullable Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected List<ITimeGraphRowModel> getRowModel(ITmfStateSystem ss, SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        if (entries.size() == 1 && filter.getTimesRequested().length == 2) {
            Map.Entry<@NonNull Long, @NonNull Integer> entry = entries.entrySet().iterator().next();
            if (filter.getStart() == Long.MIN_VALUE) {
                return CallStackDataProvider.getFollowEvent(ss, entry, filter.getEnd(), false);
            }
            if (filter.getEnd() == Long.MAX_VALUE) {
                return CallStackDataProvider.getFollowEvent(ss, entry, filter.getStart(), true);
            }
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#fetchRowModel", (int)2);
        ArrayListMultimap intervals = ArrayListMultimap.create();
        Collection times = CallStackDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (subMonitor.isCanceled()) {
                return null;
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        subMonitor.worked(1);
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        if (filter instanceof TimeGraphStateQueryFilter) {
            TimeGraphStateQueryFilter timeEventFilter = (TimeGraphStateQueryFilter)filter;
            predicates.putAll(this.computeRegexPredicate((IRegexQuery)timeEventFilter));
        }
        ArrayList<ITimeGraphRowModel> rows = new ArrayList<ITimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (subMonitor.isCanceled()) {
                return null;
            }
            List states = intervals.get((Object)((Integer)entry.getValue()));
            Long key = Objects.requireNonNull((Long)entry.getKey());
            ArrayList<ITimeGraphState> eventList = new ArrayList<ITimeGraphState>(states.size());
            states.forEach(state -> {
                ITimeGraphState timeGraphState = this.createTimeGraphState((ITmfStateInterval)state);
                this.applyFilterAndAddState(eventList, timeGraphState, key, predicates, monitor);
            });
            eventList.sort(Comparator.comparingLong(ITimeGraphState::getStartTime));
            rows.add((ITimeGraphRowModel)new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        subMonitor.worked(1);
        return rows;
    }

    private ITimeGraphState createTimeGraphState(ITmfStateInterval interval) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        Object value = interval.getValue();
        Integer pid = this.fQuarkToPid.get(interval.getAttribute());
        if (value != null && pid != null) {
            String name = (String)this.fTimeEventNames.getUnchecked((Object)new Pair((Object)pid, (Object)interval));
            return new TimeGraphState(startTime, duration, value.hashCode(), name);
        }
        return new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public String getId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public void resetFunctionNames(@Nullable IProgressMonitor monitor) {
        this.fTimeEventNames.invalidateAll();
        Collection<ISymbolProvider> collection = this.fProviders;
        synchronized (collection) {
            @NonNull Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(this.getTrace());
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#resetFunctionNames", (int)symbolProviders.size());
            this.fProviders.clear();
            for (ISymbolProvider symbolProvider : symbolProviders) {
                this.fProviders.add(symbolProvider);
                symbolProvider.loadConfiguration((IProgressMonitor)sub);
                sub.worked(1);
            }
        }
    }

    private static List<ITimeGraphRowModel> getFollowEvent(ITmfStateSystem ss, Map.Entry<Long, Integer> entry, long time, boolean forward) throws StateSystemDisposedException {
        Object object;
        int parentQuark = ss.getParentAttributeQuark(entry.getValue().intValue());
        ITmfStateInterval current = ss.querySingleState(Long.max(ss.getStartTime(), Long.min(time, ss.getCurrentEndTime())), parentQuark);
        ITmfStateInterval interval = null;
        if (forward && current.getEndTime() + 1L <= ss.getCurrentEndTime()) {
            interval = ss.querySingleState(current.getEndTime() + 1L, parentQuark);
        } else if (!forward && current.getStartTime() - 1L >= ss.getStartTime()) {
            interval = ss.querySingleState(current.getStartTime() - 1L, parentQuark);
        }
        if (interval != null && interval.getValue() instanceof Number && (object = interval.getValue()) instanceof Number) {
            int value = ((Number)object).intValue();
            TimeGraphState state = new TimeGraphState(interval.getStartTime(), interval.getEndTime() - interval.getStartTime(), value);
            TimeGraphRowModel row = new TimeGraphRowModel(entry.getKey().longValue(), Collections.singletonList(state));
            return Collections.singletonList(row);
        }
        return null;
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(SelectionTimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(Collections.emptyMap(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    protected boolean isCacheable() {
        return true;
    }
}

