/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.tests.io.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnumDeclarationTest {
    private EnumDeclaration fixture;

    @Before
    public void setUp() {
        this.fixture = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L));
    }

    @Test
    public void testEnumDeclaration() {
        IntegerDeclaration containerType = IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L);
        EnumDeclaration result = new EnumDeclaration(containerType);
        Assert.assertNotNull((Object)result);
        String left = "[declaration] enum[";
        Assert.assertEquals((Object)left, (Object)result.toString().substring(0, left.length()));
    }

    @Test
    public void testAdd() {
        long low = 1L;
        long high = 1L;
        String label = "";
        Assert.assertTrue((boolean)this.fixture.add(low, high, label));
        Assert.assertEquals((Object)"", (Object)this.fixture.query(1L));
    }

    @Test
    public void testAddMany() {
        Assert.assertTrue((boolean)this.fixture.add(0L, 1L, "fork"));
        Assert.assertTrue((boolean)this.fixture.add(2L, 3L, "tork"));
        Assert.assertTrue((boolean)this.fixture.add(4L, 7L, "mork"));
        Assert.assertTrue((boolean)this.fixture.add(10L, 20L, "zork"));
        Assert.assertTrue((boolean)this.fixture.add(22L, 27L, "york"));
        Assert.assertTrue((boolean)this.fixture.add(21L, 21L, "bork"));
        Assert.assertTrue((boolean)this.fixture.add(28L, 50L, "dork"));
        Assert.assertEquals((Object)"fork", (Object)this.fixture.query(0L));
        Assert.assertEquals((Object)"fork", (Object)this.fixture.query(1L));
        Assert.assertEquals((Object)"tork", (Object)this.fixture.query(2L));
        Assert.assertEquals((Object)"tork", (Object)this.fixture.query(3L));
        Assert.assertEquals((Object)"mork", (Object)this.fixture.query(4L));
        Assert.assertEquals((Object)"mork", (Object)this.fixture.query(5L));
        Assert.assertEquals((Object)"mork", (Object)this.fixture.query(6L));
        Assert.assertEquals((Object)"zork", (Object)this.fixture.query(10L));
        Assert.assertEquals((Object)"zork", (Object)this.fixture.query(19L));
        Assert.assertEquals((Object)"bork", (Object)this.fixture.query(21L));
        Assert.assertEquals((Object)"york", (Object)this.fixture.query(22L));
    }

    @Test
    public void testDubs() {
        Assert.assertTrue((boolean)this.fixture.add(0L, 1L, "fork"));
        Assert.assertTrue((boolean)this.fixture.add(2L, 3L, "fork"));
        Assert.assertNull((Object)this.fixture.query(-1L));
        Assert.assertEquals((Object)"fork", (Object)this.fixture.query(0L));
        Assert.assertEquals((Object)"fork", (Object)this.fixture.query(1L));
        Assert.assertEquals((Object)"fork", (Object)this.fixture.query(2L));
        Assert.assertEquals((Object)"fork", (Object)this.fixture.query(3L));
        Assert.assertNull((Object)this.fixture.query(5L));
    }

    @Test
    public void testOverlap1() {
        Assert.assertTrue((boolean)this.fixture.add(0L, 1L, "fork"));
        Assert.assertFalse((boolean)this.fixture.add(1L, 3L, "zork"));
    }

    @Test
    public void testOverlap2() {
        Assert.assertTrue((boolean)this.fixture.add(0L, 2L, "fork"));
        Assert.assertFalse((boolean)this.fixture.add(1L, 3L, "zork"));
    }

    @Test
    public void testOverlap3() {
        Assert.assertTrue((boolean)this.fixture.add(0L, 3L, "fork"));
        Assert.assertFalse((boolean)this.fixture.add(1L, 2L, "zork"));
    }

    @Test
    public void testOverlap4() {
        Assert.assertTrue((boolean)this.fixture.add(1L, 3L, "fork"));
        Assert.assertFalse((boolean)this.fixture.add(0L, 2L, "zork"));
    }

    @Test
    public void testCreateDefinition() throws CTFException {
        IDefinitionScope definitionScope = null;
        String fieldName = "";
        byte[] byArray = new byte[10];
        byArray[0] = 116;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 116;
        byArray[5] = 116;
        byArray[6] = 104;
        byArray[7] = 105;
        byArray[8] = 115;
        byte[] array = byArray;
        BitBuffer bb = new BitBuffer(Util.testMemory(ByteBuffer.wrap(array)));
        EnumDefinition result = this.fixture.createDefinition(definitionScope, fieldName, bb);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testQuery() {
        long value = 0L;
        String result = this.fixture.query(value);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        String left = "[declaration] enum[";
        Assert.assertEquals((Object)left, (Object)result.substring(0, left.length()));
    }

    @Test
    public void hashcodeTest() {
        EnumDeclaration b = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L));
        Assert.assertEquals((long)b.hashCode(), (long)this.fixture.hashCode());
        this.fixture.add(0L, 1L, "hello");
        this.fixture.add(2L, 3L, "kitty");
        b.add(0L, 1L, "hello");
        b.add(2L, 3L, "kitty");
        Assert.assertEquals((long)this.fixture.hashCode(), (long)b.hashCode());
    }

    @Test
    public void equalsTest() {
        EnumDeclaration a = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        EnumDeclaration b = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        b.add(2L, 19L, "hi");
        EnumDeclaration c = new EnumDeclaration(IntegerDeclaration.INT_32B_DECL);
        EnumDeclaration d = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertNotEquals((Object)b, (Object)c);
        Assert.assertEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)b);
        Assert.assertEquals((Object)d, (Object)a);
        a.add(2L, 19L, "hi");
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)d, (Object)a);
        d.add(2L, 22L, "hi");
        Assert.assertNotEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)d, (Object)a);
    }

    @Test
    public void binaryEquivalentTest() {
        EnumDeclaration a = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        EnumDeclaration b = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        b.add(2L, 19L, "hi");
        EnumDeclaration c = new EnumDeclaration(IntegerDeclaration.INT_32B_DECL);
        EnumDeclaration d = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        Assert.assertFalse((boolean)a.isBinaryEquivalent(null));
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)IntegerDeclaration.INT_32B_DECL));
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)b));
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)c));
        Assert.assertFalse((boolean)b.isBinaryEquivalent((IDeclaration)c));
        Assert.assertTrue((boolean)a.isBinaryEquivalent((IDeclaration)d));
        Assert.assertFalse((boolean)b.isBinaryEquivalent((IDeclaration)a));
        Assert.assertFalse((boolean)c.isBinaryEquivalent((IDeclaration)a));
        Assert.assertFalse((boolean)c.isBinaryEquivalent((IDeclaration)b));
        Assert.assertTrue((boolean)d.isBinaryEquivalent((IDeclaration)a));
        a.add(2L, 19L, "hi");
        Assert.assertTrue((boolean)a.isBinaryEquivalent((IDeclaration)a));
        Assert.assertTrue((boolean)a.isBinaryEquivalent((IDeclaration)b));
        Assert.assertTrue((boolean)b.isBinaryEquivalent((IDeclaration)a));
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)d));
        Assert.assertFalse((boolean)d.isBinaryEquivalent((IDeclaration)a));
        d.add(2L, 22L, "hi");
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)d));
        Assert.assertFalse((boolean)d.isBinaryEquivalent((IDeclaration)a));
    }
}

