/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTwoPhaseBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPFunctionSet
implements ICPPTwoPhaseBinding {
    private final ICPPFunction[] fBindings;
    private final IASTName fName;
    private final ICPPTemplateArgument[] fTemplateArguments;

    public CPPFunctionSet(ICPPFunction[] bindingList, ICPPTemplateArgument[] args, IASTName name) {
        this.fBindings = ArrayUtil.removeNulls(bindingList);
        this.fTemplateArguments = args;
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fBindings[0].getName();
    }

    @Override
    public char[] getNameCharArray() {
        return this.fBindings[0].getNameCharArray();
    }

    @Override
    public IScope getScope() throws DOMException {
        return this.fBindings[0].getScope();
    }

    @Override
    public IBinding getOwner() {
        return this.fBindings[0].getOwner();
    }

    public ICPPFunction[] getBindings() {
        return this.fBindings;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding resolveFinalBinding(CPPASTNameBase astName) {
        return CPPSemantics.resolveTargetedFunction(astName, this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.fTemplateArguments;
    }

    public void applySelectedFunction(ICPPFunction selectedFunction) {
        if (selectedFunction != null && this.fName != null) {
            this.fName.setBinding(selectedFunction);
        }
    }

    public void setToUnknown() {
        if (this.fName != null) {
            this.fName.setBinding(new CPPDeferredFunction(null, this.fName.toCharArray(), this.fBindings));
        }
    }

    public String toString() {
        if (this.fName != null) {
            return this.fName.toString();
        }
        try {
            return String.join((CharSequence)"::", this.fBindings[0].getQualifiedName());
        }
        catch (DOMException e) {
            return super.toString();
        }
    }
}

