/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.cpu;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageEntryModel;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfBenchmarkTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.CpuUsageDataProvider;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class CPUAnalysisBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#CPU usage analysis#";
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final String TEST_ANALYSIS_EXECUTION = "Execution";
    private static final String TEST_ANALYSIS_QUERY = "Query CPU Usage";
    private static final int LOOP_COUNT = 25;

    @Test
    public void testOSEvents() throws TmfTraceException {
        this.runTest(CtfBenchmarkTrace.ALL_OS_ANALYSES.getTracePath().toString(), "OS Events", 25);
    }

    @Test
    public void testManyThreads() throws TmfTraceException, IOException {
        try {
            this.runTest(FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.MANY_THREADS.getTraceURL())).getAbsolutePath(), "ManyThreads", 7);
        }
        finally {
            CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.MANY_THREADS);
        }
    }

    @Test
    public void testDjangoHttpd() throws TmfTraceException, IOException {
        try {
            this.runTest(FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.DJANGO_HTTPD.getTraceURL())).getAbsolutePath(), "Django HTTPD", 25);
        }
        finally {
            CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.MANY_THREADS);
        }
    }

    private void initializeTrace(@NonNull String path, @NonNull LttngKernelTrace trace) throws TmfTraceException {
        trace.initTrace(null, path, CtfTmfEvent.class);
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        IAnalysisModule module = trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        module = trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        Assert.assertNotNull((Object)module);
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
    }

    private static KernelCpuUsageAnalysis getModule(@NonNull LttngKernelTrace trace) throws TmfAnalysisException {
        KernelCpuUsageAnalysis module = new KernelCpuUsageAnalysis();
        try {
            module.setId("test");
            module.setTrace((ITmfTrace)trace);
            return module;
        }
        catch (TmfAnalysisException e) {
            module.dispose();
            throw e;
        }
    }

    private static void deleteSupplementaryFiles(@NonNull ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private void runTest(String testTrace, String testName, int loopCount) throws TmfTraceException {
        Assert.assertNotNull((Object)testTrace);
        LttngKernelTrace trace = new LttngKernelTrace();
        try {
            try {
                CPUAnalysisBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
                this.initializeTrace(testTrace, trace);
                CPUAnalysisBenchmark.benchmarkCPUModule(testName, trace, loopCount);
                CPUAnalysisBenchmark.deleteSupplementaryFiles((ITmfTrace)trace);
            }
            catch (TmfAnalysisException e) {
                Assert.fail((String)e.getMessage());
                trace.dispose();
            }
        }
        finally {
            trace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void benchmarkCPUModule(String testName, @NonNull LttngKernelTrace trace, int loopCount) throws TmfAnalysisException {
        Performance perf = Performance.getDefault();
        PerformanceMeter pmAnalysisExecution = perf.createPerformanceMeter(TEST_ID + testName + ": " + TEST_ANALYSIS_EXECUTION);
        perf.tagAsSummary(pmAnalysisExecution, "Execution(" + testName + ')', Dimension.CPU_TIME);
        PerformanceMeter pmQueryUsage = perf.createPerformanceMeter(TEST_ID + testName + ": " + TEST_ANALYSIS_QUERY);
        perf.tagAsSummary(pmQueryUsage, "Query CPU Usage(" + testName + ')', Dimension.CPU_TIME);
        int i = 0;
        while (i < loopCount) {
            KernelCpuUsageAnalysis module = CPUAnalysisBenchmark.getModule(trace);
            try {
                pmAnalysisExecution.start();
                TmfTestHelper.executeAnalysis((IAnalysisModule)module);
                pmAnalysisExecution.stop();
                CpuUsageDataProvider dataProvider = CpuUsageDataProvider.create((ITmfTrace)trace);
                Assert.assertNotNull((Object)dataProvider);
                int resolution = 1500;
                long startTime = trace.getStartTime().toNanos();
                long endTime = trace.getEndTime().toNanos();
                pmQueryUsage.start();
                int j = 0;
                while (j < 10) {
                    SelectedCpuQueryFilter filter = new SelectedCpuQueryFilter(startTime, endTime, 2, Collections.emptyList(), Collections.emptySet());
                    TmfModelResponse response = dataProvider.fetchTree((TimeQueryFilter)filter, NULL_MONITOR);
                    List model = (List)response.getModel();
                    Assert.assertNotNull((Object)model);
                    ArrayList<Long> selected = new ArrayList<Long>();
                    for (CpuUsageEntryModel entry : model) {
                        selected.add(entry.getId());
                    }
                    filter = new SelectedCpuQueryFilter(startTime, endTime, resolution, selected, Collections.emptySet());
                    @NonNull TmfModelResponse fetchXY = dataProvider.fetchXY((TimeQueryFilter)filter, NULL_MONITOR);
                    ITmfXyModel model2 = (ITmfXyModel)fetchXY.getModel();
                    Assert.assertNotNull((Object)model2);
                    long step = (endTime - startTime) / 20L;
                    startTime += step;
                    endTime -= step;
                    ++j;
                }
                pmQueryUsage.stop();
            }
            finally {
                module.dispose();
            }
            ++i;
        }
        pmAnalysisExecution.commit();
        pmQueryUsage.commit();
    }
}

