/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.inputoutput;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.KernelEventLayoutStub;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;

public class AbstractTestInputOutput {
    private static final String IO_FILE_PATH = "testfiles/io_analysis/";
    private static final @NonNull IKernelAnalysisEventLayout EVENT_LAYOUT = new IOKernelEventLayout();
    private ITmfTrace fTrace;

    private static void deleteSuppFiles(ITmfTrace trace) {
        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
        File[] fileArray = suppDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    protected void deleteTrace() {
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            AbstractTestInputOutput.deleteSuppFiles(this.fTrace);
            this.fTrace.dispose();
        }
    }

    protected @NonNull InputOutputAnalysisModule setUp(String fileName) {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        trace.addEventAspect((ITmfEventAspect)KernelTidAspect.INSTANCE);
        trace.setKernelEventLayout(EVENT_LAYOUT);
        IPath filePath = Activator.getAbsoluteFilePath(IO_FILE_PATH + fileName);
        IStatus status = trace.validate(null, filePath.toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e) {
            Assert.fail((String)e.getMessage());
        }
        AbstractTestInputOutput.deleteSuppFiles((ITmfTrace)trace);
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.fTrace = trace;
        KernelAnalysisModule kernelMod = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        Assert.assertNotNull((Object)kernelMod);
        kernelMod.schedule();
        kernelMod.waitForCompletion();
        InputOutputAnalysisModule module = (InputOutputAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, InputOutputAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.inputoutput");
        Assert.assertNotNull((Object)module);
        return module;
    }

    private static class IOKernelEventLayout
    extends KernelEventLayoutStub {
        private IOKernelEventLayout() {
        }

        public @NonNull String eventBlockRqMerge() {
            return "addons_elv_merge_requests";
        }

        public @Nullable String eventStatedumpBlockDevice() {
            return "statedump_block_device";
        }

        public @NonNull String eventSyscallEntryPrefix() {
            return "syscall_entry_";
        }

        public @NonNull String eventCompatSyscallEntryPrefix() {
            return "syscall_compat_entry_";
        }

        public @NonNull String eventSyscallExitPrefix() {
            return "syscall_exit_";
        }

        public @NonNull String eventCompatSyscallExitPrefix() {
            return "syscall_compat_exit_";
        }
    }
}

