/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.model.OutputElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;

public class TimeGraphState
extends OutputElement
implements ITimeGraphState {
    private final long fStartTime;
    private final long fDuration;
    private final int fValue;
    private final @Nullable String fLabel;

    public TimeGraphState(long time, long duration, int value) {
        super(null);
        this.fStartTime = time;
        this.fDuration = duration;
        this.fValue = value;
        this.fLabel = null;
    }

    public TimeGraphState(long time, long duration, int value, String label) {
        super(null);
        this.fStartTime = time;
        this.fDuration = duration;
        this.fValue = value;
        this.fLabel = label;
    }

    public TimeGraphState(long time, long duration, @Nullable String label, @Nullable OutputElementStyle style) {
        super(style);
        this.fStartTime = time;
        this.fDuration = duration;
        this.fValue = Integer.MIN_VALUE;
        this.fLabel = label;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getDuration() {
        return this.fDuration;
    }

    @Override
    public int getValue() {
        return this.fValue;
    }

    @Override
    public @Nullable String getLabel() {
        return this.fLabel;
    }

    @Override
    public synchronized Multimap<String, Object> getMetadata() {
        Multimap<String, Object> metadata = super.getMetadata();
        String label = this.getLabel();
        if (label != null) {
            metadata.put((Object)"label", (Object)label);
        }
        metadata.put((Object)TmfStrings.startTime(), (Object)this.fStartTime);
        metadata.put((Object)TmfStrings.endTime(), (Object)(this.fStartTime + this.fDuration));
        metadata.put((Object)TmfStrings.duration(), (Object)this.fDuration);
        return metadata;
    }

    @Override
    @Deprecated
    public Map<String, String> computeData() {
        HashMap<String, String> toTest = new HashMap<String, String>();
        String label = this.getLabel();
        if (label != null) {
            toTest.put("label", label);
        }
        return toTest;
    }
}

