/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.Longs;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.actions.OpenSourceCodeAction;

public abstract class TmfAbstractToolTipHandler {
    private static Format sNumberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
    private static final int MAX_SHELL_WIDTH = 750;
    private static final int MAX_SHELL_HEIGHT = 700;
    private static final int MOUSE_DEADZONE = 5;
    private static final String TIME_HYPERLINK = "<a href=time://%d>%s</a>";
    private static final String SOURCE_HYPERLINK = "<a href=" + TmfStrings.source() + "://%s\\\">%s</a>";
    private static final Pattern TIME_PATTERN = Pattern.compile("\\s*time\\:\\/\\/(\\d+).*");
    private static final Pattern SOURCE_PATTERN = Pattern.compile(String.valueOf(TmfStrings.source().toLowerCase()) + "\\:\\/\\/(.*):(\\d+).*");
    private static final ToolTipString UNCATEGORIZED = ToolTipString.fromString("");
    private static final int OFFSET = 16;
    private static Point fScrollBarSize = null;
    private Composite fTipComposite;
    private Shell fTipShell;
    private Rectangle fInitialDeadzone;
    private MouseTrackAdapter fMouseTrackAdapter;
    private Table<ToolTipString, ToolTipString, ToolTipString> fModel = HashBasedTable.create();
    private final Listener fListener = this::disposeIfExited;
    private final Listener fFocusLostListener = event -> {
        Shell tipShell = this.fTipShell;
        if (tipShell != null && event.display.getActiveShell() != tipShell) {
            tipShell.dispose();
        }
    };

    private static synchronized boolean isBrowserAvailable(Composite parent) {
        boolean isBrowserAvailable = Activator.getDefault().getPreferenceStore().getBoolean("USE_HTML_TOOLTIPS");
        if (isBrowserAvailable) {
            try {
                TmfAbstractToolTipHandler.getScrollbarSize(parent);
                Browser browser = new Browser(parent, 0);
                browser.dispose();
                isBrowserAvailable = true;
            }
            catch (SWTError er) {
                isBrowserAvailable = false;
            }
        }
        return isBrowserAvailable;
    }

    private static synchronized Point getScrollbarSize(Composite parent) {
        if (fScrollBarSize == null) {
            Slider sliderV = new Slider(parent, 512);
            Slider sliderH = new Slider(parent, 256);
            int width = sliderV.computeSize((int)-1, (int)-1).x;
            int height = sliderH.computeSize((int)-1, (int)-1).y;
            Point scrollBarSize = new Point(width, height);
            sliderV.dispose();
            sliderH.dispose();
            fScrollBarSize = scrollBarSize;
        }
        return fScrollBarSize;
    }

    private void disposeIfExited(Event e) {
        if (!(e.widget instanceof Control)) {
            return;
        }
        Control control = (Control)e.widget;
        if (control != null && !control.isDisposed()) {
            Point pt = control.toDisplay(e.x, e.y);
            Shell tipShell = this.fTipShell;
            if (tipShell != null && !tipShell.isDisposed()) {
                Rectangle bounds = TmfAbstractToolTipHandler.getBounds(tipShell);
                bounds.x -= 16;
                bounds.y -= 16;
                bounds.height += 32;
                bounds.width += 32;
                if (!bounds.contains(pt) && !this.fInitialDeadzone.contains(pt)) {
                    tipShell.dispose();
                }
            }
        }
    }

    public void activateHoverHelp(final Control control) {
        MouseTrackAdapter adapter = this.fMouseTrackAdapter;
        if (adapter == null) {
            adapter = new MouseTrackAdapter(){

                public void mouseHover(MouseEvent event) {
                    if (Display.getDefault().getFocusControl() == null || (event.stateMask & SWT.BUTTON_MASK) != 0 || (event.stateMask & 0x100FFFF) != 0) {
                        return;
                    }
                    Point pt = new Point(event.x, event.y);
                    Control timeGraphControl = (Control)event.widget;
                    Point ptInDisplay = control.toDisplay(event.x, event.y);
                    TmfAbstractToolTipHandler.this.fInitialDeadzone = new Rectangle(ptInDisplay.x - 5, ptInDisplay.y - 5, 10, 10);
                    TmfAbstractToolTipHandler.this.createTooltipShell(timeGraphControl.getShell(), control, event, pt);
                    if (TmfAbstractToolTipHandler.this.fTipShell == null || TmfAbstractToolTipHandler.this.fTipShell.isDisposed()) {
                        return;
                    }
                    Point tipPosition = control.toDisplay(pt);
                    TmfAbstractToolTipHandler.setHoverLocation(TmfAbstractToolTipHandler.this.fTipShell, tipPosition);
                    TmfAbstractToolTipHandler.this.fTipShell.setVisible(true);
                    Display display = Display.getDefault();
                    display.addFilter(5, TmfAbstractToolTipHandler.this.fListener);
                    display.addFilter(16, TmfAbstractToolTipHandler.this.fFocusLostListener);
                }
            };
            control.addMouseTrackListener((MouseTrackListener)adapter);
            this.fMouseTrackAdapter = adapter;
        }
    }

    public void deactivateHoverHelp(Control control) {
        MouseTrackAdapter adapter = this.fMouseTrackAdapter;
        if (adapter != null) {
            control.removeMouseTrackListener((MouseTrackListener)adapter);
            this.fMouseTrackAdapter = null;
        }
    }

    private void createTooltipShell(Shell parent, Control control, MouseEvent event, Point pt) {
        Display display = parent.getDisplay();
        if (this.fTipShell != null && !this.fTipShell.isDisposed()) {
            this.fTipShell.dispose();
        }
        this.fModel.clear();
        this.fTipShell = new Shell(parent, 16404);
        this.fTipShell.addDisposeListener(e -> e.display.removeFilter(5, this.fListener));
        this.fTipShell.addDisposeListener(e -> e.display.removeFilter(16, this.fFocusLostListener));
        this.fTipShell.addListener(27, e -> {
            if (!this.fTipShell.isDisposed()) {
                this.fTipShell.dispose();
            }
        });
        this.fTipShell.setLayout((Layout)new FillLayout());
        this.fTipShell.setBackground(display.getSystemColor(29));
        this.fTipComposite = new Composite((Composite)this.fTipShell, 524288);
        this.fTipComposite.setLayout((Layout)new FillLayout());
        this.fill(control, event, pt);
        AbstractContent content = null;
        content = TmfAbstractToolTipHandler.isBrowserAvailable(this.fTipComposite) ? new BrowserContent(this.fTipComposite) : new DefaultContent(this.fTipComposite);
        content.setInput(this.fModel);
        Point preferredSize = content.create();
        if (preferredSize == null) {
            this.fTipShell.dispose();
            return;
        }
        Rectangle trim = this.fTipShell.computeTrim(0, 0, preferredSize.x, preferredSize.y);
        this.fTipShell.setSize(Math.min(trim.width, 750), Math.min(trim.height, 700));
    }

    private static void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = TmfAbstractToolTipHandler.getBounds(shell);
        shellBounds.x = position.x + shellBounds.width + 16 > displayBounds.width && position.x - shellBounds.width - 16 >= 0 ? position.x - shellBounds.width - 16 : Math.max(Math.min(position.x + 16, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = position.y + shellBounds.height + 16 > displayBounds.height && position.y - shellBounds.height - 16 >= 0 ? position.y - shellBounds.height - 16 : Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }

    private static Rectangle getBounds(Shell shell) {
        Rectangle bounds = shell.getBounds();
        if (SWT.getVersion() < 4902 && SWT.getPlatform().equals("gtk")) {
            bounds = shell.computeTrim(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        return bounds;
    }

    protected Composite getTipComposite() {
        return this.fTipComposite;
    }

    protected void addItem(String name, String value) {
        this.addItem(null, ToolTipString.fromString(Objects.requireNonNull(name)), ToolTipString.fromString(Objects.requireNonNull(value)));
    }

    protected void addItem(@Nullable String category, @NonNull String name, @NonNull String value) {
        if (Objects.equals(TmfStrings.source(), name)) {
            this.addItem(category == null ? null : ToolTipString.fromString(category), ToolTipString.fromString(name), ToolTipString.fromHtml(String.format(SOURCE_HYPERLINK, value, value)));
        } else {
            this.addItem(category == null ? null : ToolTipString.fromString(category), ToolTipString.fromString(name), ToolTipString.fromString(value));
        }
    }

    protected void addItem(ToolTipString category, @NonNull ToolTipString name, @NonNull ToolTipString value) {
        this.fModel.put((Object)(category == null ? UNCATEGORIZED : category), (Object)name, (Object)value);
    }

    protected abstract void fill(Control var1, MouseEvent var2, Point var3);

    private abstract class AbstractContent
    implements ITooltipContent {
        private Composite fParent = null;
        private Table<ToolTipString, ToolTipString, ToolTipString> fContentModel = null;

        public AbstractContent(Composite parent) {
            this.fParent = parent;
        }

        @Override
        public void setInput(Table<ToolTipString, ToolTipString, ToolTipString> model) {
            this.fContentModel = model;
        }

        protected @NonNull Table<ToolTipString, ToolTipString, ToolTipString> getModel() {
            HashBasedTable model = this.fContentModel;
            if (model == null) {
                model = HashBasedTable.create();
            }
            return model;
        }

        protected Composite getParent() {
            return this.fParent;
        }
    }

    private class BrowserContent
    extends AbstractContent {
        private static final int BODY_MARGIN = 3;
        private static final int CONTENT_MARGIN = 1;
        private static final int CELL_PADDING = 10;

        public BrowserContent(Composite parent) {
            super(parent);
        }

        @Override
        public Point create() {
            Composite parent = this.getParent();
            Table<ToolTipString, ToolTipString, ToolTipString> model = this.getModel();
            if (parent == null || model.size() == 0) {
                return null;
            }
            this.setupControl((Control)parent);
            ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 256);
            scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
            Browser browser = new Browser((Composite)scrolledComposite, 0);
            browser.setJavascriptEnabled(false);
            browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent ev) {
                    String locationValue = ev.location;
                    Matcher matcher = TIME_PATTERN.matcher(locationValue);
                    if (matcher.find()) {
                        String time = matcher.group(1);
                        Long val = Longs.tryParse((String)time);
                        if (val != null) {
                            TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal(ev.getSource(), TmfTimestamp.fromNanos((long)val)));
                        }
                        ev.doit = false;
                    } else {
                        Matcher sMatcher = SOURCE_PATTERN.matcher(locationValue);
                        if (sMatcher.matches()) {
                            new OpenSourceCodeAction("", (ITmfCallsite)new TmfCallsite(sMatcher.group(1), Long.valueOf(Long.parseLong(sMatcher.group(2)))), BrowserContent.this.getParent().getShell()).run();
                            ev.doit = false;
                        }
                    }
                }

                public void changed(LocationEvent ev) {
                }
            });
            this.setupControl((Control)browser);
            String toolTipHtml = this.toHtml();
            browser.setText(toolTipHtml);
            scrolledComposite.setContent((Control)browser);
            Point preferredSize = this.computePreferredSize();
            scrolledComposite.setMinSize(preferredSize.x, 0);
            return preferredSize;
        }

        @Override
        public Point computePreferredSize() {
            Table<ToolTipString, ToolTipString, ToolTipString> model = this.getModel();
            int widestCat = 0;
            int widestKey = 0;
            int widestVal = 0;
            int totalHeight = 0;
            Set rowKeySet = model.rowKeySet();
            GC gc = new GC((Drawable)Display.getDefault());
            for (ToolTipString row : rowKeySet) {
                if (!row.equals(UNCATEGORIZED)) {
                    Point catExtent = gc.textExtent(row.toString());
                    widestCat = Math.max(widestCat, catExtent.x);
                    totalHeight += catExtent.y + 8;
                }
                Set entrySet = model.row((Object)row).entrySet();
                for (Map.Entry entry : entrySet) {
                    Point keyExtent = gc.textExtent(((ToolTipString)entry.getKey()).toString());
                    Point valExtent = gc.textExtent(((ToolTipString)entry.getValue()).toString());
                    widestKey = Math.max(widestKey, keyExtent.x);
                    widestVal = Math.max(widestVal, valExtent.x);
                    totalHeight += Math.max(keyExtent.y, valExtent.y) + 4;
                }
            }
            gc.dispose();
            int w = Math.max(widestCat, widestKey + 10 + widestVal) + 2 + 6;
            int h = totalHeight + 2 + 6;
            Point scrollBarSize = TmfAbstractToolTipHandler.getScrollbarSize(this.getParent());
            return new Point(w + scrollBarSize.x, h);
        }

        private String toHtml() {
            GC gc = new GC((Drawable)Display.getDefault());
            FontData fontData = gc.getFont().getFontData()[0];
            String fontName = fontData.getName();
            String fontHeight = String.valueOf(fontData.getHeight()) + "pt";
            gc.dispose();
            Table<ToolTipString, ToolTipString, ToolTipString> model = this.getModel();
            StringBuilder toolTipContent = new StringBuilder();
            toolTipContent.append("<head>\n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n<style>\n.collapsible {\n  background-color: #777;\n  color: white;\n  padding: 0px;\n  width: 100%;\n  border: none;\n  text-align: left;\n  outline: none;\n  font-family: " + fontName + ";\n" + "  font-size: " + fontHeight + ";\n" + "}\n" + "\n" + ".active, .collapsible:hover {\n" + "  background-color: #555;\n" + "}\n" + "\n" + ".content {\n" + "  padding: 0px 0px;\n" + "  display: block;\n" + "  overflow: hidden;\n" + "  background-color: #f1f1f1;\n" + "}\n" + ".tab {\n" + "  padding:0px;\n" + "  font-family: " + fontName + ";\n" + "  font-size: " + fontHeight + ";\n" + "}\n" + ".leftPadding {\n" + "  padding:0px 0px 0px " + 10 + "px;\n" + "}\n" + ".bodystyle {\n" + "  margin:" + 3 + "px;\n" + "  padding:0px 0px;\n" + "}\n" + "</style>\n" + "</head>");
            toolTipContent.append("<body class=\"bodystyle\">");
            toolTipContent.append("<div class=\"content\">");
            toolTipContent.append("<table class=\"tab\">");
            Set rowKeySet = model.rowKeySet();
            for (ToolTipString row : rowKeySet) {
                if (!row.equals(UNCATEGORIZED)) {
                    toolTipContent.append("<tr><th colspan=\"2\"><button class=\"collapsible\">").append(row.toHtmlString()).append("</button></th></tr>");
                }
                Set entrySet = model.row((Object)row).entrySet();
                for (Map.Entry entry : entrySet) {
                    toolTipContent.append("<tr>");
                    toolTipContent.append("<td>");
                    toolTipContent.append(((ToolTipString)entry.getKey()).toHtmlString());
                    toolTipContent.append("</td>");
                    toolTipContent.append("<td class=\"leftPadding\">");
                    toolTipContent.append(((ToolTipString)entry.getValue()).toHtmlString());
                    toolTipContent.append("</td>");
                    toolTipContent.append("</tr>");
                }
            }
            toolTipContent.append("</table></div>");
            toolTipContent.append("</body>");
            return toolTipContent.toString();
        }
    }

    private class DefaultContent
    extends AbstractContent {
        private Composite fComposite;

        public DefaultContent(Composite parent) {
            super(parent);
        }

        @Override
        public Point create() {
            Composite composite;
            Composite parent = this.getParent();
            Table<ToolTipString, ToolTipString, ToolTipString> model = this.getModel();
            if (parent == null || model.size() == 0) {
                return null;
            }
            this.setupControl((Control)parent);
            ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
            this.setupControl((Control)scrolledComposite);
            this.fComposite = composite = new Composite((Composite)scrolledComposite, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            this.setupControl((Control)composite);
            Set rowKeySet = model.rowKeySet();
            for (ToolTipString row : rowKeySet) {
                Set entrySet = model.row((Object)row).entrySet();
                for (Map.Entry entry : entrySet) {
                    Label nameLabel = new Label(composite, 524288);
                    nameLabel.setText(((ToolTipString)entry.getKey()).toString());
                    this.setupControl((Control)nameLabel);
                    Label separator = new Label(composite, 524802);
                    GridData gd = new GridData(0x1000000, 0x1000000, false, false);
                    gd.heightHint = nameLabel.computeSize((int)-1, (int)-1).y;
                    separator.setLayoutData((Object)gd);
                    this.setupControl((Control)separator);
                    Label valueLabel = new Label(composite, 524288);
                    valueLabel.setText(((ToolTipString)entry.getValue()).toString());
                    this.setupControl((Control)valueLabel);
                }
            }
            scrolledComposite.setContent((Control)composite);
            Point preferredSize = this.computePreferredSize();
            scrolledComposite.setMinSize(preferredSize.x, preferredSize.y);
            return preferredSize;
        }

        @Override
        public Point computePreferredSize() {
            return this.fComposite.computeSize(-1, -1);
        }
    }

    private static interface ITooltipContent {
        public Point create();

        public void setInput(Table<ToolTipString, ToolTipString, ToolTipString> var1);

        public Point computePreferredSize();

        default public void setupControl(Control control) {
            control.setForeground(control.getDisplay().getSystemColor(24));
            control.setBackground(control.getDisplay().getSystemColor(25));
        }
    }

    @NonNullByDefault
    public static class ToolTipString {
        private final String fText;
        private final String fHtmlString;

        private ToolTipString(String text, String htmlString) {
            this.fText = text;
            this.fHtmlString = htmlString;
        }

        public String toHtmlString() {
            return this.fHtmlString;
        }

        public String toString() {
            return this.fText;
        }

        public static ToolTipString fromString(String text) {
            return new ToolTipString(text, ToolTipString.toHtmlString(text));
        }

        public static ToolTipString fromHtml(String htmlString) {
            return new ToolTipString(ToolTipString.toText(htmlString), htmlString);
        }

        public static ToolTipString fromDecimal(Number decimal) {
            Format format = sNumberFormat;
            if (format == null) {
                format = NumberFormat.getInstance(Locale.getDefault());
                if (format == null) {
                    format = new DecimalUnitFormat();
                }
                sNumberFormat = format;
            }
            String number = Objects.requireNonNull(format.format(decimal));
            return new ToolTipString(number, ToolTipString.toHtmlString(number));
        }

        public static ToolTipString fromTimestamp(String text, long timestamp) {
            return new ToolTipString(text, Objects.requireNonNull(String.format(TmfAbstractToolTipHandler.TIME_HYPERLINK, timestamp, ToolTipString.toHtmlString(text))));
        }

        private static String toHtmlString(String text) {
            return Objects.requireNonNull(StringEscapeUtils.escapeHtml4((String)text).replaceAll("[ \\t]", "&nbsp;").replaceAll("\\r?\\n", "<br>"));
        }

        private static String toText(String htmlString) {
            return Objects.requireNonNull(StringEscapeUtils.unescapeHtml4((String)htmlString.replaceAll("\\<[^>]*>", "")));
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ToolTipString other = (ToolTipString)obj;
            return Objects.equals(this.fText, other.fText) && Objects.equals(this.fHtmlString, other.fHtmlString);
        }

        public int hashCode() {
            return Objects.hash(this.fText, this.fHtmlString);
        }
    }
}

