/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph;

import com.google.common.collect.ImmutableMap;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.FlameGraphView;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.Messages;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;

public class FlameGraphPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 360;
    private static final Format FORMATTER = SubSecondTimeWithUnitFormat.getInstance();
    private final StateItem[] fStateTable;
    private FlameGraphView fView;
    private IPaletteProvider fPalette = new RotatingPaletteProvider.Builder().setNbColors(360).build();

    public FlameGraphPresentationProvider() {
        this.fStateTable = new StateItem[361];
        this.fStateTable[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        int i = 1;
        for (RGBAColor color : this.fPalette.get()) {
            this.fStateTable[i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, color.toString());
            ++i;
        }
    }

    public StateItem[] getStateTable() {
        return this.fStateTable;
    }

    public boolean displayTimesInTooltip() {
        return false;
    }

    public String getStateTypeName() {
        return Messages.FlameGraph_Depth;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        AggregatedCalledFunctionStatistics statistics = ((FlamegraphEvent)event).getStatistics();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)Messages.FlameGraph_NbCalls, (Object)NumberFormat.getIntegerInstance().format(statistics.getDurationStatistics().getNbElements()));
        builder.put((Object)String.valueOf(Messages.FlameGraph_Durations), (Object)"");
        builder.put((Object)("\t" + Messages.FlameGraph_Duration), (Object)FORMATTER.format(event.getDuration()));
        builder.put((Object)("\t" + Messages.FlameGraph_AverageDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMean()));
        builder.put((Object)("\t" + Messages.FlameGraph_MaxDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMax()));
        builder.put((Object)("\t" + Messages.FlameGraph_MinDuration), (Object)FORMATTER.format(statistics.getDurationStatistics().getMin()));
        builder.put((Object)("\t" + Messages.FlameGraph_Deviation), (Object)FORMATTER.format(statistics.getDurationStatistics().getStdDev()));
        builder.put((Object)Messages.FlameGraph_SelfTimes, (Object)"");
        builder.put((Object)("\t" + Messages.FlameGraph_SelfTime), (Object)FORMATTER.format(((FlamegraphEvent)event).getSelfTime()));
        builder.put((Object)("\t" + Messages.FlameGraph_AverageSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMean()));
        builder.put((Object)("\t" + Messages.FlameGraph_MaxSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMax()));
        builder.put((Object)("\t" + Messages.FlameGraph_MinSelfTime), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getMin()));
        builder.put((Object)("\t" + Messages.FlameGraph_SelfTimeDeviation), (Object)FORMATTER.format(statistics.getSelfTimeStatistics().getStdDev()));
        return builder.build();
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof FlamegraphEvent) {
            FlamegraphEvent flameGraphEvent = (FlamegraphEvent)event;
            return Math.floorMod(flameGraphEvent.getValue(), this.fPalette.get().size()) + 1;
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return State.MULTIPLE.ordinal();
    }

    public FlameGraphView getView() {
        return this.fView;
    }

    public void setView(FlameGraphView view) {
        this.fView = view;
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

