/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MacroFileEntry
extends APathEntry
implements IMacroFileEntry {
    IPath macroFilePath;

    public MacroFileEntry(IPath resourcePath, IPath basePath, IPath baseRef, IPath macroFilePath, IPath[] exclusionPatterns, boolean isExported) {
        super(512, basePath, baseRef, resourcePath, exclusionPatterns, isExported);
        this.macroFilePath = macroFilePath == null ? Path.EMPTY : PathUtil.getCanonicalPathWindows(macroFilePath);
    }

    @Override
    public IPath getMacroFilePath() {
        return this.macroFilePath;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.macroFilePath == null ? 0 : this.macroFilePath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IMacroFileEntry) {
            IMacroFileEntry otherEntry = (IMacroFileEntry)obj;
            if (!super.equals(otherEntry)) {
                return false;
            }
            if (this.path == null ? otherEntry.getPath() != null : !this.path.toString().equals(otherEntry.getPath().toString())) {
                return false;
            }
            return !(this.macroFilePath == null ? otherEntry.getMacroFilePath() != null : !this.macroFilePath.toString().equals(otherEntry.getMacroFilePath().toString()));
        }
        return super.equals(obj);
    }

    @Override
    public IPath getFullMacroFilePath() {
        IPath inc = this.getMacroFilePath();
        if (!this.basePath.isEmpty()) {
            IResource res;
            IPath loc = this.basePath;
            if (!loc.isAbsolute() && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(loc)) != null) {
                loc = res.getLocation();
            }
            IPath p = loc.append(inc);
            return p;
        }
        IPath p = inc;
        if (!p.isAbsolute()) {
            IPath resPath = this.getPath();
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resPath);
            if (res != null) {
                IPath location;
                if (res.getType() == 1) {
                    res = res.getParent();
                }
                if ((location = res.getLocation()) != null) {
                    p = location.append(p);
                }
            }
        }
        return p;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.macroFilePath != null && !this.macroFilePath.isEmpty()) {
            sb.append(" macroFilePath:").append(this.macroFilePath);
        }
        return sb.toString();
    }
}

