/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;

public class TmfSimpleTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener {
    private TmfAbstractToolTipHandler fTooltipHandler = new XYToolTipHandler();

    public TmfSimpleTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.fTooltipHandler.activateHoverHelp((Control)this.getChart().getPlotArea());
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.fTooltipHandler.deactivateHoverHelp((Control)this.getChart().getPlotArea());
        }
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    private final class XYToolTipHandler
    extends TmfAbstractToolTipHandler {
        private XYToolTipHandler() {
        }

        @Override
        public void fill(Control control, MouseEvent event, Point pt) {
            Chart chart = TmfSimpleTooltipProvider.this.getChart();
            IAxisSet axisSet = chart.getAxisSet();
            IAxis xAxis = axisSet.getXAxis(0);
            IAxis yAxis = axisSet.getYAxis(0);
            double xCoordinate = xAxis.getDataCoordinate(pt.x);
            double yCoordinate = yAxis.getDataCoordinate(pt.y);
            ITmfChartTimeProvider viewer = TmfSimpleTooltipProvider.this.getChartViewer();
            ITmfTimestamp time = TmfTimestamp.fromNanos((long)((long)xCoordinate + viewer.getTimeOffset()));
            this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString("x"), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(time.toString(), time.toNanos()));
            this.addItem(null, "y", Double.toString(yCoordinate));
        }
    }
}

