/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.mapping.ResourceMergeActionHandler;
import org.eclipse.team.internal.ui.mapping.ResourceModelProviderOperation;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ResourceMarkAsMergedHandler
extends ResourceMergeActionHandler {
    private ResourceModelProviderOperation operation;

    public ResourceMarkAsMergedHandler(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected synchronized SynchronizationOperation getOperation() {
        if (this.operation == null) {
            this.operation = new ResourceModelProviderOperation(this.getConfiguration(), this.getStructuredSelection()){

                @Override
                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        final IMergeContext context = (IMergeContext)this.getContext();
                        final IDiff[] deltas = this.getTargetDiffs();
                        ISchedulingRule rule = this.getMergeRule(context, deltas);
                        context.run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                this.markAsMerged(deltas, context, monitor);
                            }
                        }, rule, 0, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }

                private ISchedulingRule getMergeRule(IMergeContext context, IDiff[] deltas) {
                    ISchedulingRule result = null;
                    int i = 0;
                    while (i < deltas.length) {
                        IDiff node = deltas[i];
                        ISchedulingRule rule = context.getMergeRule(node);
                        result = result == null ? rule : MultiRule.combine((ISchedulingRule)result, (ISchedulingRule)rule);
                        ++i;
                    }
                    return result;
                }

                private void markAsMerged(IDiff[] deltas, IMergeContext context, IProgressMonitor monitor) throws CoreException {
                    context.markAsMerged(deltas, false, monitor);
                }

                @Override
                protected FastDiffFilter getDiffFilter() {
                    return new FastDiffFilter(){

                        public boolean select(IDiff node) {
                            IThreeWayDiff twd;
                            return node instanceof IThreeWayDiff && ((twd = (IThreeWayDiff)node).getDirection() == 768 || twd.getDirection() == 512);
                        }
                    };
                }

                @Override
                protected String getJobName() {
                    IDiff[] diffs = this.getTargetDiffs();
                    if (diffs.length == 1) {
                        return TeamUIMessages.ResourceMarkAsMergedHandler_0;
                    }
                    return NLS.bind((String)TeamUIMessages.ResourceMarkAsMergedHandler_1, (Object)new Integer(diffs.length).toString());
                }
            };
        }
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEnablement(IStructuredSelection selection) {
        ResourceMarkAsMergedHandler resourceMarkAsMergedHandler = this;
        synchronized (resourceMarkAsMergedHandler) {
            this.operation = null;
        }
        super.updateEnablement(selection);
        int mode = this.getConfiguration().getMode();
        if (mode == 2 && this.getSynchronizationContext().getDiffTree().countFor(768, 768) == 0L || this.getSynchronizationContext().getDiffTree().countFor(768, 768) == 0L && this.getSynchronizationContext().getDiffTree().countFor(512, 768) == 0L) {
            this.setEnabled(false);
            return;
        }
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.saveDirtyEditors()) {
            return super.execute(event);
        }
        return null;
    }
}

