/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecIncomplete;

public class CPPASTDeclarator
extends CPPASTAttributeOwner
implements ICPPASTDeclarator,
IASTImplicitNameOwner,
ICPPExecutionOwner {
    private IASTInitializer initializer;
    private IASTName name;
    private IASTImplicitName[] implicitNames;
    private IASTDeclarator nested;
    private IASTPointerOperator[] pointerOps;
    private boolean isPackExpansion;

    public CPPASTDeclarator() {
    }

    public CPPASTDeclarator(IASTName name) {
        this.setName(name);
    }

    public CPPASTDeclarator(IASTName name, IASTInitializer initializer) {
        this(name);
        this.setInitializer(initializer);
    }

    @Override
    public CPPASTDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTDeclarator copy(IASTNode.CopyStyle style) {
        CPPASTDeclarator copy = new CPPASTDeclarator();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CPPASTDeclarator> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setName(this.name == null ? null : this.name.copy(style));
        copy.setInitializer(this.initializer == null ? null : this.initializer.copy(style));
        copy.setNestedDeclarator(this.nested == null ? null : this.nested.copy(style));
        copy.isPackExpansion = this.isPackExpansion;
        IASTPointerOperator[] iASTPointerOperatorArray = this.getPointerOperators();
        int n = iASTPointerOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
            copy.addPointerOperator(pointer.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public boolean declaresParameterPack() {
        return this.isPackExpansion;
    }

    @Override
    public IASTPointerOperator[] getPointerOperators() {
        if (this.pointerOps == null) {
            return IASTPointerOperator.EMPTY_ARRAY;
        }
        this.pointerOps = ArrayUtil.trim(IASTPointerOperator.class, this.pointerOps);
        return this.pointerOps;
    }

    @Override
    public IASTDeclarator getNestedDeclarator() {
        return this.nested;
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        this.initializer = initializer;
        if (initializer != null) {
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public void addPointerOperator(IASTPointerOperator operator) {
        this.assertNotFrozen();
        if (operator != null) {
            operator.setParent(this);
            operator.setPropertyInParent(POINTER_OPERATOR);
            this.pointerOps = ArrayUtil.append(IASTPointerOperator.class, this.pointerOps, operator);
        }
    }

    @Override
    public void setNestedDeclarator(IASTDeclarator nested) {
        this.assertNotFrozen();
        this.nested = nested;
        if (nested != null) {
            nested.setParent(this);
            nested.setPropertyInParent(NESTED_DECLARATOR);
        }
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(DECLARATOR_NAME);
        }
    }

    @Override
    public void setDeclaresParameterPack(boolean val) {
        this.assertNotFrozen();
        this.isPackExpansion = val;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTDeclarator outermost;
        int n;
        if (action.shouldVisitDeclarators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.pointerOps != null) {
            IASTPointerOperator[] iASTPointerOperatorArray = this.pointerOps;
            n = this.pointerOps.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator op = iASTPointerOperatorArray[n2];
                if (op == null) break;
                if (!op.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.nested == null && this.name != null && (outermost = ASTQueries.findOutermostDeclarator(this)).getPropertyInParent() != IASTTypeId.ABSTRACT_DECLARATOR) {
            if (!this.name.accept(action)) {
                return false;
            }
            if (action.shouldVisitImplicitNames) {
                IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
                int n3 = iASTImplicitNameArray.length;
                n = 0;
                while (n < n3) {
                    IASTImplicitName implicitName = iASTImplicitNameArray[n];
                    if (!implicitName.accept(action)) {
                        return false;
                    }
                    ++n;
                }
            }
        }
        if (this.nested != null && !this.nested.accept(action)) {
            return false;
        }
        if (!this.postAccept(action)) {
            return false;
        }
        return !action.shouldVisitDeclarators || action.leave(this) != 2;
    }

    protected boolean postAccept(ASTVisitor action) {
        return this.initializer == null || this.initializer.accept(action);
    }

    @Override
    public int getRoleForName(IASTName n) {
        IASTNode parent = ASTQueries.findOutermostDeclarator(this).getParent();
        if (parent instanceof IASTDeclaration) {
            if (parent instanceof IASTFunctionDefinition) {
                return 2;
            }
            if (parent instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)parent;
                if (this instanceof IASTFunctionDeclarator) {
                    return 0;
                }
                int storage = sdecl.getDeclSpecifier().getStorageClass();
                if (this.getInitializer() == null && (storage == 2 || this.isSimpleLinkageSpec(sdecl))) {
                    return 0;
                }
                if (storage == 3 && CPPVisitor.getContainingScope(parent) instanceof ICPPClassScope) {
                    return 0;
                }
                if (storage == 1) {
                    return 2;
                }
            }
            return 2;
        }
        if (parent instanceof IASTTypeId) {
            return 1;
        }
        if (parent instanceof IASTParameterDeclaration) {
            return n.getLookupKey().length > 0 ? 2 : 0;
        }
        return 3;
    }

    private boolean isSimpleLinkageSpec(IASTSimpleDeclaration sdecl) {
        ICPPASTLinkageSpecification spec;
        IASTNode parent = sdecl.getParent();
        return parent instanceof ICPPASTLinkageSpecification && (spec = (ICPPASTLinkageSpecification)parent).getDeclarations().length == 1;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            IBinding ctor = CPPSemantics.findImplicitlyCalledConstructor(this);
            if (ctor == null) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName ctorName = new CPPASTImplicitName(ctor.getNameCharArray(), (IASTNode)this);
                ctorName.setBinding(ctor);
                IASTName id = this.name;
                if (id instanceof ICPPASTQualifiedName) {
                    id = id.getLastName();
                }
                ctorName.setOffsetAndLength((ASTNode)((Object)id));
                this.implicitNames = new IASTImplicitName[]{ctorName};
            }
        }
        return this.implicitNames;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.nested) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.nested = (IASTDeclarator)other;
            return;
        }
        super.replace(child, other);
    }

    @Override
    public ICPPExecution getExecution() {
        IBinding binding = this.getName().resolveBinding();
        if (!(binding instanceof ICPPBinding)) {
            return ExecIncomplete.INSTANCE;
        }
        ICPPEvaluation initializerEval = null;
        if (binding instanceof CPPVariable) {
            CPPVariable variable = (CPPVariable)binding;
            initializerEval = variable.getInitializerEvaluation();
        }
        if (initializerEval == EvalFixed.INCOMPLETE) {
            return ExecIncomplete.INSTANCE;
        }
        return new ExecDeclarator((ICPPBinding)binding, initializerEval);
    }
}

