/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class MarkerFilter
implements Cloneable {
    static final String TAG_ENABLED = "enabled";
    public static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_SELECTED_TYPES = "selectedType";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_TYPES_DELIMITER = ":";
    public static final String TAG_SELECTION_STATUS = "selectionStatus";
    public static final String SELECTED_FALSE = "false";
    private static final String SELECTED_TRUE = "true";
    public static final int ON_ANY = 0;
    public static final int ON_SELECTED_ONLY = 1;
    public static final int ON_SELECTED_AND_CHILDREN = 2;
    public static final int ON_ANY_IN_SAME_CONTAINER = 3;
    public static final int ON_WORKING_SET = 4;
    static final int DEFAULT_ON_RESOURCE = 0;
    static final boolean DEFAULT_ACTIVATION_STATUS = true;
    protected List<MarkerType> rootTypes = new ArrayList<MarkerType>();
    protected List<MarkerType> selectedTypes = new ArrayList<MarkerType>();
    protected IWorkingSet workingSet;
    protected int onResource;
    protected boolean enabled;
    private IResource[] focusResources;
    private Set<String> cachedWorkingSet;
    private String name;

    MarkerFilter(String filterName, String[] rootTypes) {
        this.name = filterName;
        String[] stringArray = rootTypes;
        int n = rootTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String rootType = stringArray[n2];
            MarkerType type = MarkerTypesModel.getInstance().getType(rootType);
            if (!this.rootTypes.contains(type)) {
                this.rootTypes.add(type);
            }
            ++n2;
        }
        this.resetState();
    }

    public void addAllSubTypes(List<MarkerType> types) {
        int i = 0;
        while (i < this.rootTypes.size()) {
            MarkerType rootType = this.rootTypes.get(i);
            this.addAllSubTypes(types, rootType);
            ++i;
        }
    }

    private void addAllSubTypes(List<MarkerType> types, MarkerType type) {
        if (type == null) {
            return;
        }
        if (!types.contains(type)) {
            types.add(type);
        }
        MarkerType[] markerTypeArray = type.getSubtypes();
        int n = markerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType subType = markerTypeArray[n2];
            this.addAllSubTypes(types, subType);
            ++n2;
        }
    }

    protected boolean selectMarker(ConcreteMarker marker) {
        return true;
    }

    IResource[] getResourcesInWorkingSet() {
        if (this.workingSet == null) {
            return new IResource[0];
        }
        if (this.workingSet.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] elements = this.workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>(elements.length);
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            IResource next = (IResource)Adapters.adapt((Object)adaptable, IResource.class);
            if (next != null) {
                result.add(next);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private Set<String> getWorkingSetAsSetOfPaths() {
        if (this.cachedWorkingSet == null) {
            HashSet<String> result = new HashSet<String>();
            this.addResourcesAndChildren(result, this.getResourcesInWorkingSet());
            this.cachedWorkingSet = result;
        }
        return this.cachedWorkingSet;
    }

    private void addResourcesAndChildren(HashSet<String> result, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource currentResource = iResourceArray[n2];
            result.add(currentResource.getFullPath().toString());
            if (currentResource instanceof IContainer) {
                IContainer cont = (IContainer)currentResource;
                try {
                    this.addResourcesAndChildren(result, cont.members());
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    static IProject[] getProjects(IResource[] resources) {
        if (resources == null) {
            return new IProject[0];
        }
        Collection<IProject> projects = MarkerFilter.getProjectsAsCollection(resources);
        return projects.toArray(new IProject[projects.size()]);
    }

    static Collection<IProject> getProjectsAsCollection(Object[] elements) {
        HashSet<IProject> projects = new HashSet<IProject>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                projects.add(((IResource)element).getProject());
            } else {
                IProject[] mappingProjects;
                IProject[] iProjectArray = mappingProjects = ((ResourceMapping)element).getProjects();
                int n3 = mappingProjects.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject mappingProject = iProjectArray[n4];
                    projects.add(mappingProject);
                    ++n4;
                }
            }
            ++n2;
        }
        return projects;
    }

    public boolean select(ConcreteMarker marker) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.selectByType(marker) && this.selectBySelection(marker) && this.selectMarker(marker);
    }

    private boolean selectByType(ConcreteMarker marker) {
        return this.selectedTypes.contains(MarkerTypesModel.getInstance().getType(marker.getType()));
    }

    private boolean selectBySelection(ConcreteMarker marker) {
        block12: {
            IResource resource;
            block14: {
                block13: {
                    block11: {
                        if (this.onResource == 0 || marker == null) {
                            return true;
                        }
                        if (this.focusResources == null) {
                            return true;
                        }
                        resource = marker.getResource();
                        if (this.onResource != 4) break block11;
                        if (resource != null) {
                            return this.isEnclosed(resource);
                        }
                        break block12;
                    }
                    if (this.onResource != 3) break block13;
                    IProject project = resource.getProject();
                    if (project == null) {
                        return false;
                    }
                    IResource[] iResourceArray = this.focusResources;
                    int n = this.focusResources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource focusResource = iResourceArray[n2];
                        IProject selectedProject = focusResource.getProject();
                        if (selectedProject != null && project.equals((Object)selectedProject)) {
                            return true;
                        }
                        ++n2;
                    }
                    break block12;
                }
                if (this.onResource != 1) break block14;
                IResource[] iResourceArray = this.focusResources;
                int n = this.focusResources.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource focusResource = iResourceArray[n3];
                    if (resource.equals((Object)focusResource)) {
                        return true;
                    }
                    ++n3;
                }
                break block12;
            }
            if (this.onResource != 2) break block12;
            IResource[] iResourceArray = this.focusResources;
            int n = this.focusResources.length;
            int n4 = 0;
            while (n4 < n) {
                IResource focusResource = iResourceArray[n4];
                IResource parentResource = resource;
                while (parentResource != null) {
                    if (parentResource.equals((Object)focusResource)) {
                        return true;
                    }
                    parentResource = parentResource.getParent();
                }
                ++n4;
            }
        }
        return false;
    }

    private boolean isEnclosed(IResource element) {
        if (this.workingSet == null) {
            return false;
        }
        if (this.workingSet.isEmpty()) {
            return true;
        }
        Set<String> workingSetPaths = this.getWorkingSetAsSetOfPaths();
        return workingSetPaths.contains(element.getFullPath().toString());
    }

    public int getOnResource() {
        return this.onResource;
    }

    void setOnResource(int onResource) {
        if (onResource >= 0 && onResource <= 4) {
            this.onResource = onResource;
        }
    }

    IResource[] getFocusResource() {
        return this.focusResources;
    }

    public void setFocusResource(IResource[] resources) {
        this.focusResources = resources;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<MarkerType> getRootTypes() {
        return this.rootTypes;
    }

    public List<MarkerType> getSelectedTypes() {
        return this.selectedTypes;
    }

    public MarkerType getMarkerType(String id) {
        return MarkerTypesModel.getInstance().getType(id);
    }

    IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        this.cachedWorkingSet = null;
    }

    void resetState() {
        this.enabled = true;
        this.onResource = 0;
        this.selectedTypes.clear();
        this.addAllSubTypes(this.selectedTypes);
        this.setWorkingSet(null);
    }

    public final void restoreState(IMemento memento) {
        this.resetState();
        this.restoreFilterSettings(memento);
    }

    public void restoreFilterSettings(IDialogSettings settings) {
        this.resetState();
        String setting = settings.get(TAG_ENABLED);
        if (setting != null) {
            this.enabled = Boolean.valueOf(setting);
        }
        if ((setting = settings.get(TAG_ON_RESOURCE)) != null) {
            try {
                this.onResource = Integer.parseInt(setting);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((setting = settings.get(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList<MarkerType> newTypes = new ArrayList<MarkerType>();
            this.addAllSubTypes(newTypes);
            StringTokenizer stringTokenizer = new StringTokenizer(setting);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String id = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String status = null;
                if (stringTokenizer.hasMoreTokens()) {
                    status = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(id)) == null) continue;
                newTypes.remove(markerType);
                if (SELECTED_FALSE.equals(status) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int i = 0;
            while (i < newTypes.size()) {
                this.selectedTypes.add((MarkerType)newTypes.get(i));
                ++i;
            }
        } else {
            setting = settings.get(TAG_SELECTED_TYPES);
            if (setting != null) {
                this.generateSelectedTypes(setting);
            }
        }
        setting = settings.get(TAG_WORKING_SET);
        if (setting != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setting));
        }
    }

    void generateSelectedTypes(String selectedTypesValue) {
        this.selectedTypes.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(selectedTypesValue);
        while (stringTokenizer.hasMoreTokens()) {
            MarkerType markerType = this.getMarkerType(stringTokenizer.nextToken(TAG_TYPES_DELIMITER));
            if (markerType == null || this.selectedTypes.contains(markerType)) continue;
            this.selectedTypes.add(markerType);
        }
    }

    MarkerType findMarkerType(String typeName) {
        return MarkerTypesModel.getInstance().getType(typeName);
    }

    protected void restoreFilterSettings(IMemento memento) {
        Integer resourceSetting;
        String setting = memento.getString(TAG_ENABLED);
        if (setting != null) {
            this.enabled = Boolean.valueOf(setting);
        }
        if ((resourceSetting = memento.getInteger(TAG_ON_RESOURCE)) != null) {
            this.onResource = resourceSetting;
        }
        if ((setting = memento.getString(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList<MarkerType> newTypes = new ArrayList<MarkerType>();
            this.addAllSubTypes(newTypes);
            StringTokenizer stringTokenizer = new StringTokenizer(setting);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String id = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String status = null;
                if (stringTokenizer.hasMoreTokens()) {
                    status = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(id)) == null) continue;
                newTypes.remove(markerType);
                if (SELECTED_FALSE.equals(status) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int i = 0;
            while (i < newTypes.size()) {
                this.selectedTypes.add((MarkerType)newTypes.get(i));
                ++i;
            }
        } else {
            setting = memento.getString(TAG_SELECTED_TYPES);
            if (setting != null) {
                this.generateSelectedTypes(setting);
            }
        }
        setting = memento.getString(TAG_WORKING_SET);
        if (setting != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setting));
        }
    }

    public void saveFilterSettings(IMemento settings) {
        settings.putString(TAG_ENABLED, String.valueOf(this.enabled));
        settings.putInteger(TAG_ON_RESOURCE, this.onResource);
        String markerTypeIds = "";
        ArrayList<MarkerType> includedTypes = new ArrayList<MarkerType>();
        this.addAllSubTypes(includedTypes);
        int i = 0;
        while (i < includedTypes.size()) {
            MarkerType markerType = (MarkerType)includedTypes.get(i);
            markerTypeIds = String.valueOf(markerTypeIds) + markerType.getId() + TAG_TYPES_DELIMITER;
            markerTypeIds = this.selectedTypes.contains(markerType) ? String.valueOf(markerTypeIds) + "true:" : String.valueOf(markerTypeIds) + "false:";
            ++i;
        }
        settings.putString(TAG_SELECTION_STATUS, markerTypeIds);
        if (this.workingSet != null) {
            settings.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public MarkerFilter makeClone() throws CloneNotSupportedException {
        return (MarkerFilter)this.clone();
    }

    public void setSelectedTypes(List<MarkerType> selectedTypes) {
        this.selectedTypes = selectedTypes;
    }
}

