/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.signal.TmfUiSignalThrottler;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.histogram.FullTraceHistogram;
import org.eclipse.tracecompass.tmf.ui.views.histogram.Histogram;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramRequest;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramSelectionEndControl;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramSelectionStartControl;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramTextControl;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramTimeRangeControl;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramZoom;
import org.eclipse.tracecompass.tmf.ui.views.histogram.Messages;
import org.eclipse.tracecompass.tmf.ui.views.histogram.TimeRangeHistogram;
import org.eclipse.ui.IActionBars;

public class HistogramView
extends TmfView
implements ITmfTimeAligned {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.ui.views.histogram";
    private static final Image LINK_IMG = Activator.getDefault().getImageFromPath("icons/elcl16/link_obj.png");
    private static final int[] DEFAULT_WEIGHTS = new int[]{1, 3};
    private ITmfTrace fTrace;
    private long fTraceStartTime;
    private long fTraceEndTime;
    private long fWindowStartTime;
    private long fWindowEndTime;
    private long fWindowSpan;
    private long fSelectionBeginTime;
    private long fSelectionEndTime;
    private SashForm fSashForm;
    private ScrolledComposite fScrollComposite;
    private Composite fTimeControlsComposite;
    private Composite fTimeRangeComposite;
    private Listener fSashDragListener;
    private HistogramTextControl fSelectionStartControl;
    private HistogramTextControl fSelectionEndControl;
    private HistogramTextControl fTimeSpanControl;
    private Label fLinkButton;
    private boolean fLinkState;
    private FullTraceHistogram fFullTraceHistogram;
    private HistogramRequest fFullTraceRequest;
    private TimeRangeHistogram fTimeRangeHistogram;
    private HistogramRequest fTimeRangeRequest;
    private Composite fLegendArea;
    private Image[] fLegendImages;
    private final TmfUiSignalThrottler fTimeSyncThrottle = new TmfUiSignalThrottler(this, 200L);
    private final TmfUiSignalThrottler fTimeRangeSyncThrottle = new TmfUiSignalThrottler(this, 200L);
    private Action hideLostEventsAction;
    private Action showTraceAction;

    public HistogramView() {
        super(ID);
    }

    @Override
    public void dispose() {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        this.fFullTraceHistogram.dispose();
        this.fTimeRangeHistogram.dispose();
        this.fSelectionStartControl.dispose();
        this.fSelectionEndControl.dispose();
        this.fTimeSpanControl.dispose();
        this.disposeLegendImages();
        super.dispose();
    }

    private void disposeLegendImages() {
        if (this.fLegendImages != null) {
            Image[] imageArray = this.fLegendImages;
            int n = this.fLegendImages.length;
            int n2 = 0;
            while (n2 < n) {
                Image i = imageArray[n2];
                i.dispose();
                ++n2;
            }
        }
        this.fLegendImages = null;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        String selectionStartLabel = Messages.HistogramView_selectionStartLabel;
        String selectionEndLabel = Messages.HistogramView_selectionEndLabel;
        String windowSpanLabel = Messages.HistogramView_windowSpanLabel;
        Composite viewComposite = new Composite(this.getParentComposite(), 4);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        viewComposite.setLayout((Layout)gridLayout);
        this.fSashForm = new SashForm(viewComposite, 0){

            public Point computeSize(int wHint, int hHint) {
                Point computedSize = super.computeSize(wHint, hHint);
                if (wHint == -1) {
                    return new Point(1, computedSize.y);
                }
                return computedSize;
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point computedSize = super.computeSize(wHint, hHint, changed);
                if (wHint == -1) {
                    return new Point(1, computedSize.y);
                }
                return computedSize;
            }
        };
        GridData gridData = new GridData(4, 4, false, true);
        this.fSashForm.setLayoutData((Object)gridData);
        this.fScrollComposite = new PackedScrolledComposite((Composite)this.fSashForm, 768);
        this.fTimeControlsComposite = new Composite((Composite)this.fScrollComposite, 0);
        this.fScrollComposite.setContent((Control)this.fTimeControlsComposite);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fScrollComposite.setLayout((Layout)gridLayout);
        this.fScrollComposite.setExpandHorizontal(true);
        this.fScrollComposite.setExpandVertical(true);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fTimeControlsComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 2, false, true);
        this.fTimeControlsComposite.setLayoutData((Object)gridData);
        Composite innerComp = new Composite(this.fTimeControlsComposite, 0);
        gridLayout = new GridLayout(2, false);
        innerComp.setLayout((Layout)gridLayout);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 1;
        gridData = new GridData(4, 2, false, true);
        innerComp.setLayoutData((Object)gridData);
        Composite selectionGroup = new Composite(innerComp, 2048);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        selectionGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(1, 2, false, false);
        selectionGroup.setLayoutData((Object)gridData);
        gridData = new GridData(4, 2, false, false);
        this.fSelectionStartControl = new HistogramSelectionStartControl(this, selectionGroup, selectionStartLabel, 0L);
        this.fSelectionStartControl.setLayoutData(gridData);
        this.fSelectionStartControl.setValue(Long.MIN_VALUE);
        gridData = new GridData(4, 2, false, false);
        this.fSelectionEndControl = new HistogramSelectionEndControl(this, selectionGroup, selectionEndLabel, 0L);
        this.fSelectionEndControl.setLayoutData(gridData);
        this.fSelectionEndControl.setValue(Long.MIN_VALUE);
        gridData = new GridData(1, 2, false, false);
        this.fLinkButton = new Label(innerComp, 0);
        this.fLinkButton.setImage(LINK_IMG);
        this.fLinkButton.setLayoutData((Object)gridData);
        this.addLinkButtonListeners();
        gridData = new GridData(4, 2, false, false);
        this.fTimeSpanControl = new HistogramTimeRangeControl(this, innerComp, windowSpanLabel, 0L);
        this.fTimeSpanControl.setLayoutData(gridData);
        this.fTimeSpanControl.setValue(Long.MIN_VALUE);
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fTimeRangeComposite = new Composite((Composite)this.fSashForm, 0);
        gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        this.fTimeRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        this.fTimeRangeComposite.setLayoutData((Object)gridData);
        this.fTimeRangeHistogram = new TimeRangeHistogram(this, this.fTimeRangeComposite, true);
        this.fTimeRangeHistogram.setStatusLineManager(statusLineManager);
        Composite fullRangeComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout(1, true);
        fullRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true, 2, 1);
        fullRangeComposite.setLayoutData((Object)gridData);
        this.fFullTraceHistogram = new FullTraceHistogram(this, fullRangeComposite);
        this.fFullTraceHistogram.setStatusLineManager(statusLineManager);
        this.fLegendArea = new Composite(viewComposite, 4);
        this.fLegendArea.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        this.fLegendArea.setLayout((Layout)new RowLayout());
        HistogramZoom listener = this.fFullTraceHistogram.getZoom();
        this.fTimeSpanControl.addMouseWheelListener(listener);
        this.contributeToActionBars();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.fSashForm.setVisible(true);
        this.fSashForm.setWeights(DEFAULT_WEIGHTS);
        this.fTimeControlsComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (HistogramView.this.fSashDragListener == null) {
                    Control[] controlArray = HistogramView.this.fSashForm.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Sash) {
                            HistogramView.this.fSashDragListener = event -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(HistogramView.this.fSashForm, HistogramView.this.getTimeViewAlignmentInfo()));
                            control.removePaintListener((PaintListener)this);
                            control.addListener(13, HistogramView.this.fSashDragListener);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.fFullTraceHistogram.fCanvas.setFocus();
    }

    void refresh() {
        this.getParentComposite().layout(true);
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fSashForm == null) {
            return null;
        }
        return new TmfTimeViewAlignmentInfo(this.fSashForm.getShell(), this.fSashForm.toDisplay(0, 0), this.getTimeAxisOffset());
    }

    private int getTimeAxisOffset() {
        return this.fScrollComposite.getSize().x + this.fSashForm.getSashWidth() + this.fTimeRangeHistogram.getPointAreaOffset();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        int pointAreaWidth = this.fTimeRangeHistogram.getPointAreaWidth();
        int curTimeAxisOffset = this.getTimeAxisOffset();
        if (pointAreaWidth <= 0) {
            pointAreaWidth = this.fSashForm.getBounds().width - curTimeAxisOffset;
        }
        int endOffset = curTimeAxisOffset + pointAreaWidth;
        GridLayout layout = (GridLayout)this.fTimeRangeComposite.getLayout();
        int endOffsetWithoutMargin = endOffset + layout.marginRight;
        int availableWidth = endOffsetWithoutMargin - requestedOffset;
        availableWidth = Math.min(this.fSashForm.getBounds().width, Math.max(0, availableWidth));
        return availableWidth;
    }

    @Override
    public void performAlign(int offset, int width) {
        int total = this.fSashForm.getBounds().width;
        int plotAreaOffset = this.fTimeRangeHistogram.getPointAreaOffset();
        int width1 = Math.max(0, offset - plotAreaOffset - this.fSashForm.getSashWidth());
        int width2 = Math.max(0, total - width1 - this.fSashForm.getSashWidth());
        if (width1 >= 0 && width2 > 0 || width1 > 0 && width2 >= 0) {
            this.fSashForm.setWeights(new int[]{width1, width2});
            this.fSashForm.layout();
        }
        GridLayout layout = (GridLayout)this.fTimeRangeComposite.getLayout();
        int timeBasedControlsWidth = this.fTimeRangeComposite.getSize().x;
        int marginSize = timeBasedControlsWidth - width - plotAreaOffset;
        layout.marginRight = Math.max(0, marginSize);
        this.fTimeRangeComposite.layout();
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(TmfTimestamp.fromNanos((long)this.fWindowStartTime), TmfTimestamp.fromNanos((long)this.fWindowEndTime));
    }

    public Action getShowLostEventsAction() {
        if (this.hideLostEventsAction == null) {
            this.hideLostEventsAction = new Action(Messages.HistogramView_hideLostEvents, 2){

                public void run() {
                    HistogramScaledData.hideLostEvents = HistogramView.this.hideLostEventsAction.isChecked();
                    long maxNbEvents = HistogramScaledData.hideLostEvents ? ((HistogramView)HistogramView.this).fFullTraceHistogram.fScaledData.fMaxValue : ((HistogramView)HistogramView.this).fFullTraceHistogram.fScaledData.fMaxCombinedValue;
                    HistogramView.this.fFullTraceHistogram.setMaxNbEvents(maxNbEvents);
                    maxNbEvents = HistogramScaledData.hideLostEvents ? ((HistogramView)HistogramView.this).fTimeRangeHistogram.fScaledData.fMaxValue : ((HistogramView)HistogramView.this).fTimeRangeHistogram.fScaledData.fMaxCombinedValue;
                    HistogramView.this.fTimeRangeHistogram.setMaxNbEvents(maxNbEvents);
                }
            };
            this.hideLostEventsAction.setText(Messages.HistogramView_hideLostEvents);
            this.hideLostEventsAction.setToolTipText(Messages.HistogramView_hideLostEvents);
            this.hideLostEventsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/hide_lost_events.gif"));
        }
        return this.hideLostEventsAction;
    }

    public Action getShowTraceAction() {
        if (this.showTraceAction == null) {
            this.showTraceAction = new Action(Messages.HistogramView_showTraces, 2){

                public void run() {
                    Histogram.showTraces = HistogramView.this.showTraceAction.isChecked();
                    ((HistogramView)HistogramView.this).fFullTraceHistogram.fCanvas.redraw();
                    ((HistogramView)HistogramView.this).fTimeRangeHistogram.fCanvas.redraw();
                    HistogramView.this.updateLegendArea();
                }
            };
            this.showTraceAction.setChecked(true);
            this.showTraceAction.setText(Messages.HistogramView_showTraces);
            this.showTraceAction.setToolTipText(Messages.HistogramView_showTraces);
            this.showTraceAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/show_hist_traces.gif"));
        }
        return this.showTraceAction;
    }

    void updateSelectionTime(long beginTime, long endTime) {
        this.updateDisplayedSelectionTime(beginTime, endTime);
        ITmfTimestamp beginTs = TmfTimestamp.fromNanos((long)beginTime);
        ITmfTimestamp endTs = TmfTimestamp.fromNanos((long)endTime);
        TmfSelectionRangeUpdatedSignal signal = new TmfSelectionRangeUpdatedSignal((Object)this, beginTs, endTs, this.fTrace);
        this.fTimeSyncThrottle.queue((TmfSignal)signal);
    }

    long getSelectionBegin() {
        return this.fSelectionBeginTime;
    }

    long getSelectionEnd() {
        return this.fSelectionEndTime;
    }

    boolean getLinkState() {
        return this.fLinkState;
    }

    void updateTimeRange(long startTime, long endTime) {
        if (this.fTrace != null) {
            TmfTimeRange timeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
            this.fTimeSpanControl.setValue(endTime - startTime);
            this.updateDisplayedTimeRange(startTime, endTime);
            TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, timeRange, this.fTrace);
            this.fTimeRangeSyncThrottle.queue((TmfSignal)signal);
        }
    }

    public synchronized void updateTimeRange(long newDuration) {
        if (this.fTrace != null) {
            long delta = newDuration - this.fWindowSpan;
            long newStartTime = this.fWindowStartTime - delta / 2L;
            this.setNewRange(newStartTime, newDuration);
        }
    }

    private void setNewRange(long startTime, long duration) {
        long endTime;
        long realStart = startTime;
        if (realStart < this.fTraceStartTime) {
            realStart = this.fTraceStartTime;
        }
        if ((endTime = realStart + duration) > this.fTraceEndTime) {
            endTime = this.fTraceEndTime;
            realStart = endTime - duration > this.fTraceStartTime ? endTime - duration : this.fTraceStartTime;
        }
        this.updateTimeRange(realStart, endTime);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = Objects.requireNonNull(signal).getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (this.fTrace != Objects.requireNonNull(signal).getTrace()) {
            this.fTrace = signal.getTrace();
            this.loadTrace();
        }
    }

    private void loadTrace() {
        this.initializeHistograms();
        this.getParentComposite().redraw();
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        this.fTrace = null;
        this.fTraceStartTime = 0L;
        this.fTraceEndTime = 0L;
        this.fWindowStartTime = 0L;
        this.fWindowEndTime = 0L;
        this.fWindowSpan = 0L;
        this.fSelectionBeginTime = 0L;
        this.fSelectionEndTime = 0L;
        this.fFullTraceHistogram.clear();
        this.fFullTraceHistogram.fDataModel.setTrace(null);
        this.fTimeRangeHistogram.clear();
        this.fTimeRangeHistogram.fDataModel.setTrace(null);
        this.fSelectionStartControl.setValue(Long.MIN_VALUE);
        this.fSelectionEndControl.setValue(Long.MIN_VALUE);
        this.fTimeSpanControl.setValue(Long.MIN_VALUE);
        Control[] controlArray = this.fLegendArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.disposeLegendImages();
        this.fLegendArea.layout();
        this.fLegendArea.getParent().layout();
    }

    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getRange();
        this.fTraceStartTime = fullRange.getStartTime().toNanos();
        this.fTraceEndTime = fullRange.getEndTime().toNanos();
        this.fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.sendFullRangeRequest(fullRange);
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getTrace().getTimeRange();
        this.fTraceStartTime = fullRange.getStartTime().toNanos();
        this.fTraceEndTime = fullRange.getEndTime().toNanos();
        this.fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        if (this.fFullTraceRequest != null && this.fFullTraceRequest.getRange().getEndTime().compareTo(signal.getRange().getEndTime()) < 0) {
            this.sendFullRangeRequest(fullRange);
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(() -> {
                if (this.getParentComposite().isDisposed()) {
                    return;
                }
                this.selectionRangeUpdated(signal);
            });
            return;
        }
        long beginTime = signal.getBeginTime().toNanos();
        long endTime = signal.getEndTime().toNanos();
        this.updateDisplayedSelectionTime(beginTime, endTime);
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(() -> {
                if (this.getParentComposite().isDisposed()) {
                    return;
                }
                this.windowRangeUpdated(signal);
            });
            return;
        }
        if (this.fTrace != null) {
            TmfTimeRange range = signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange());
            if (range == null) {
                return;
            }
            this.updateDisplayedTimeRange(range.getStartTime().toNanos(), range.getEndTime().toNanos());
            this.sendTimeRangeRequest(this.fWindowStartTime, this.fWindowEndTime);
            this.fTimeSpanControl.setValue(this.fWindowSpan);
        }
    }

    private void initializeHistograms() {
        TmfTimeRange fullRange = this.updateTraceTimeRange();
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        long selectionBeginTime = ctx.getSelectionRange().getStartTime().toNanos();
        long selectionEndTime = ctx.getSelectionRange().getEndTime().toNanos();
        long startTime = ctx.getWindowRange().getStartTime().toNanos();
        long duration = ctx.getWindowRange().getEndTime().toNanos() - startTime;
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        this.fTimeRangeHistogram.clear();
        this.fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.fTimeRangeHistogram.setTimeRange(startTime, duration);
        this.fTimeRangeHistogram.setSelection(selectionBeginTime, selectionEndTime);
        this.fTimeRangeHistogram.fDataModel.setTrace(this.fTrace);
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        this.fFullTraceHistogram.clear();
        this.fFullTraceHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.fFullTraceHistogram.setTimeRange(startTime, duration);
        this.fFullTraceHistogram.setSelection(selectionBeginTime, selectionEndTime);
        this.fFullTraceHistogram.fDataModel.setTrace(this.fTrace);
        this.fWindowStartTime = startTime;
        this.fWindowSpan = duration;
        this.fWindowEndTime = startTime + duration;
        this.fSelectionBeginTime = selectionBeginTime;
        this.fSelectionEndTime = selectionEndTime;
        this.fSelectionStartControl.setValue(this.fSelectionBeginTime);
        this.fSelectionEndControl.setValue(this.fSelectionEndTime);
        this.fScrollComposite.setMinSize(this.fTimeControlsComposite.computeSize(-1, -1));
        this.fTimeSpanControl.setValue(duration);
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
        if (!traces.isEmpty()) {
            this.showTraceAction.setEnabled(traces.size() < this.fFullTraceHistogram.getMaxNbTraces());
        }
        this.updateLegendArea();
        if (!fullRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
            this.sendTimeRangeRequest(startTime, startTime + duration);
            this.sendFullRangeRequest(fullRange);
        }
    }

    private void updateLegendArea() {
        Control[] controlArray = this.fLegendArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.disposeLegendImages();
        if (this.fFullTraceHistogram.showTraces()) {
            Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
            this.fLegendImages = new Image[traces.size()];
            int traceIndex = 0;
            for (ITmfTrace trace : traces) {
                this.fLegendImages[traceIndex] = new Image((Device)this.fLegendArea.getDisplay(), 16, 16);
                GC gc = new GC((Drawable)this.fLegendImages[traceIndex]);
                gc.setBackground(this.fFullTraceHistogram.getTraceColor(traceIndex));
                gc.fillRectangle(0, 0, 15, 15);
                gc.setForeground(this.fLegendArea.getDisplay().getSystemColor(2));
                gc.drawRectangle(0, 0, 15, 15);
                gc.dispose();
                CLabel label = new CLabel(this.fLegendArea, 0);
                label.setText(trace.getName());
                label.setImage(this.fLegendImages[traceIndex]);
                ++traceIndex;
            }
        }
        this.fLegendArea.layout();
        this.fLegendArea.getParent().layout();
    }

    private void updateDisplayedSelectionTime(long beginTime, long endTime) {
        this.fSelectionBeginTime = beginTime;
        this.fSelectionEndTime = endTime;
        this.fFullTraceHistogram.setSelection(this.fSelectionBeginTime, this.fSelectionEndTime);
        this.fTimeRangeHistogram.setSelection(this.fSelectionBeginTime, this.fSelectionEndTime);
        this.fSelectionStartControl.setValue(this.fSelectionBeginTime);
        this.fSelectionEndControl.setValue(this.fSelectionEndTime);
    }

    private void updateDisplayedTimeRange(long start, long end) {
        this.fWindowStartTime = start;
        this.fWindowEndTime = end;
        this.fWindowSpan = this.fWindowEndTime - this.fWindowStartTime;
        this.fFullTraceHistogram.setTimeRange(this.fWindowStartTime, this.fWindowSpan);
    }

    private TmfTimeRange updateTraceTimeRange() {
        this.fTraceStartTime = 0L;
        this.fTraceEndTime = 0L;
        TmfTimeRange timeRange = this.fTrace.getTimeRange();
        if (!timeRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
            this.fTraceStartTime = timeRange.getStartTime().toNanos();
            this.fTraceEndTime = timeRange.getEndTime().toNanos();
        }
        return timeRange;
    }

    private void sendTimeRangeRequest(long startTime, long endTime) {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        ITmfTimestamp startTS = TmfTimestamp.fromNanos((long)startTime);
        ITmfTimestamp endTS = TmfTimestamp.fromNanos((long)endTime);
        TmfTimeRange timeRange = new TmfTimeRange(startTS, endTS);
        this.fTimeRangeHistogram.clear();
        this.fTimeRangeHistogram.setFullRange(this.fTraceStartTime, this.fTraceEndTime);
        this.fTimeRangeHistogram.setTimeRange(startTime, endTime - startTime);
        int cacheSize = this.fTrace.getCacheSize();
        this.fTimeRangeRequest = new HistogramRequest(this.fTimeRangeHistogram.getDataModel(), timeRange, 0, Integer.MAX_VALUE, cacheSize, ITmfEventRequest.ExecutionType.FOREGROUND, false);
        this.fTrace.sendRequest((ITmfEventRequest)this.fTimeRangeRequest);
    }

    private void sendFullRangeRequest(TmfTimeRange fullRange) {
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        int cacheSize = this.fTrace.getCacheSize();
        this.fFullTraceRequest = new HistogramRequest(this.fFullTraceHistogram.getDataModel(), fullRange, (int)this.fFullTraceHistogram.fDataModel.getNbEvents(), Integer.MAX_VALUE, cacheSize, ITmfEventRequest.ExecutionType.BACKGROUND, true);
        this.fTrace.sendRequest((ITmfEventRequest)this.fFullTraceRequest);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.getShowLostEventsAction());
        bars.getToolBarManager().add((IAction)this.getShowTraceAction());
        bars.getToolBarManager().add((IContributionItem)new Separator());
    }

    private void addLinkButtonListeners() {
        this.fLinkButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                HistogramView.this.fSelectionEndControl.setEnabled(HistogramView.this.fLinkState);
                HistogramView.this.fLinkState = !HistogramView.this.fLinkState;
                HistogramView.this.fLinkButton.redraw();
            }
        });
        this.fLinkButton.addPaintListener(e -> {
            if (this.fLinkState) {
                Rectangle r = this.fLinkButton.getBounds();
                r.x = -1;
                r.y = -1;
                e.gc.setForeground(e.display.getSystemColor(18));
                e.gc.drawRectangle(r);
                r.x = 0;
                r.y = 0;
                e.gc.setForeground(e.display.getSystemColor(16));
                e.gc.drawRectangle(r);
            }
        });
    }

    private static class PackedScrolledComposite
    extends ScrolledComposite {
        Point fScrollBarSize;

        public PackedScrolledComposite(Composite parent, int style) {
            super(parent, style);
            Composite composite = new Composite(parent, 768);
            composite.setSize(1, 1);
            this.fScrollBarSize = composite.computeSize(0, 0);
            composite.dispose();
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Point point = super.computeSize(wHint, hHint, changed);
            point.x = point.x + ((this.getStyle() & 0x200) != 0 ? -this.fScrollBarSize.x : 0);
            point.y = point.y + ((this.getStyle() & 0x100) != 0 ? -this.fScrollBarSize.y : 0);
            return point;
        }
    }
}

