/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.LamiConfigUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisFactoryException;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisFactoryFromConfigFile;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.AddAnalysisDialog;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.HandlerUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.OnDemandAnalysisManager;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOnDemandAnalysesElement;
import org.eclipse.ui.PlatformUI;

public class AddAnalysisHandler
extends AbstractHandler {
    private static final IInputValidator NAME_INPUT_VALIDATOR = text -> {
        if (text.trim().isEmpty()) {
            return Messages.AddAnalysisDialog_NameEmptyErrorMessage;
        }
        return null;
    };
    private static final IInputValidator COMMAND_INPUT_VALIDATOR = text -> {
        if (text.trim().isEmpty()) {
            return Messages.AddAnalysisDialog_CommandEmptyErrorMessage;
        }
        return null;
    };

    private static void showErrorBox(@Nullable Shell shell, Throwable e) {
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.AddAnalysisDialog_ErrorBoxTitle, (String)(String.valueOf(Messages.AddAnalysisDialog_ErrorBoxMessage) + ":\n" + e.toString())));
    }

    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        Path configFilePath;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        AddAnalysisDialog dialog = new AddAnalysisDialog(shell, Messages.AddAnalysisDialog_Title, NAME_INPUT_VALIDATOR, COMMAND_INPUT_VALIDATOR);
        if (dialog.open() != 0) {
            return null;
        }
        try {
            configFilePath = LamiConfigUtils.createConfigFile((String)((String)NonNullUtils.checkNotNull((Object)dialog.getName().trim())), (String)((String)NonNullUtils.checkNotNull((Object)dialog.getCommand().trim())));
        }
        catch (IOException e) {
            AddAnalysisHandler.showErrorBox(shell, e);
            return null;
        }
        try {
            LamiAnalysis analysis = LamiAnalysisFactoryFromConfigFile.buildFromConfigFile((Path)configFilePath, (boolean)true, trace -> true);
            OnDemandAnalysisManager.getInstance().registerAnalysis((IOnDemandAnalysis)analysis);
        }
        catch (LamiAnalysisFactoryException e) {
            AddAnalysisHandler.showErrorBox(shell, e);
            return null;
        }
        Object elem = HandlerUtils.getSelectedModelElement();
        if (elem != null && elem instanceof TmfOnDemandAnalysesElement) {
            TmfOnDemandAnalysesElement analysesElem = (TmfOnDemandAnalysesElement)elem;
            analysesElem.refresh();
        }
        return null;
    }
}

