/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.document.CharacterDataImpl;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class CommentImpl
extends CharacterDataImpl
implements Comment {
    private boolean isJSPTag = false;

    protected CommentImpl() {
    }

    protected CommentImpl(CommentImpl that) {
        super(that);
        if (that != null) {
            this.isJSPTag = that.isJSPTag;
        }
    }

    public Node cloneNode(boolean deep) {
        CommentImpl cloned = new CommentImpl(this);
        this.notifyUserDataHandlers((short)1, cloned);
        return cloned;
    }

    public String getData() throws DOMException {
        char[] data = this.getCharacterData();
        if (data == null) {
            String sdata = this.getData(this.getStructuredDocumentRegion());
            if (sdata != null) {
                return sdata;
            }
            return "";
        }
        return new String(data);
    }

    private String getData(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return null;
        }
        ITextRegion contentRegion = null;
        StringBuffer buffer = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (regionType == "XML_COMMENT_OPEN" || regionType == "XML_COMMENT_CLOSE" || this.isNestedCommentOpenClose(regionType)) continue;
            if (contentRegion == null) {
                contentRegion = region;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(flatNode.getText(contentRegion));
            }
            buffer.append(flatNode.getText(region));
        }
        if (buffer != null) {
            return buffer.toString();
        }
        if (contentRegion != null) {
            return flatNode.getText(contentRegion);
        }
        return null;
    }

    public String getNodeName() {
        return "#comment";
    }

    public short getNodeType() {
        return 8;
    }

    public boolean isClosed() {
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return true;
        }
        String regionType = StructuredDocumentRegionUtil.getLastRegionType(flatNode);
        return regionType == "XML_COMMENT_CLOSE" || this.isNestedCommentClose(regionType);
    }

    protected boolean isNestedCommentClose(String regionType) {
        boolean result = false;
        return result;
    }

    protected boolean isNestedCommentOpenClose(String regionType) {
        boolean result = false;
        return result;
    }

    public boolean isJSPTag() {
        return this.isJSPTag;
    }

    public void setJSPTag(boolean isJSPTag) {
        if (isJSPTag == this.isJSPTag) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        DocumentImpl document = (DocumentImpl)this.getOwnerDocument();
        if (isJSPTag && (document == null || !document.isJSPType())) {
            return;
        }
        this.isJSPTag = isJSPTag;
        if (this.getContainerDocument() != null) {
            this.setData(this.getData());
        }
    }
}

