/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency;

import java.lang.reflect.Field;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBotAssert;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency.PatternDensityView;
import org.eclipse.tracecompass.tmf.analysis.xml.ui.swtbot.tests.latency.PatternLatencyViewTestBase;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.swtchart.Chart;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class PatternDensityViewTest
extends PatternLatencyViewTestBase {
    private static final String COLUMN_HEADER = "Name";
    private static final String SYSTEM_CALL_PREFIX = "sys_";
    private static final String VIEW_ID = "org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.density";
    private static final String VIEW_TITLE = "Latency vs Count";
    private AbstractSegmentStoreDensityView fDensityView;
    private AbstractSegmentStoreTableViewer fDensityViewer;
    private Chart fDensityChart;

    public void setDensityViewer() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        SWTBotView viewBot = fBot.viewById(VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertNotNull((Object)viewPart);
        if (!(viewPart instanceof PatternDensityView)) {
            Assert.fail((String)"Could not instanciate view");
        }
        this.fDensityView = (PatternDensityView)viewPart;
        Field field = AbstractSegmentStoreDensityView.class.getDeclaredField("fTableViewer");
        field.setAccessible(true);
        this.fDensityViewer = (AbstractSegmentStoreTableViewer)field.get(this.fDensityView);
        this.fDensityChart = (Chart)viewBot.bot().widget(WidgetOfType.widgetOfType(Chart.class));
        Assert.assertNotNull((Object)this.fDensityViewer);
    }

    @Test
    public void testWithTrace() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.setDensityViewer();
        WaitUtils.waitForJobs();
        SWTBotTable tableBot = new SWTBotTable(this.fDensityViewer.getTableViewer().getTable());
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)SYSTEM_CALL_PREFIX, (int)0, (int)3));
        tableBot.header(COLUMN_HEADER).click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)SYSTEM_CALL_PREFIX, (int)0, (int)3));
        tableBot.header(COLUMN_HEADER).click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)SYSTEM_CALL_PREFIX, (int)0, (int)3));
        Chart densityChart = this.fDensityChart;
        Assert.assertNotNull((Object)densityChart);
        fBot.waitUntil(ConditionHelpers.numberOfSeries((Chart)densityChart, (int)1));
        SWTBotChart chartBot = new SWTBotChart(densityChart);
        SWTBotAssert.assertVisible((AbstractSWTBot)chartBot);
        ISeriesSet seriesSet = this.fDensityChart.getSeriesSet();
        Assert.assertNotNull((Object)seriesSet);
        ISeries[] series = seriesSet.getSeries();
        Assert.assertNotNull((Object)series);
        Assert.assertEquals((long)1L, (long)series.length);
        Assert.assertTrue((series[0].getXSeries().length > 0 ? 1 : 0) != 0);
    }

    @Override
    protected String getViewId() {
        return VIEW_ID;
    }

    @Override
    protected String getViewTitle() {
        return VIEW_TITLE;
    }

    private static class SWTBotChart
    extends AbstractSWTBotControl<Chart> {
        public SWTBotChart(Chart w) throws WidgetNotFoundException {
            super((Control)w);
        }
    }
}

