/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.mapping.IStorageMerger;
import org.eclipse.team.internal.ui.TeamUIPlugin;

public class StorageStreamMerger
implements IStorageMerger {
    private IStreamMerger merger;

    public StorageStreamMerger(IStreamMerger merger) {
        this.merger = merger;
    }

    public IStatus merge(OutputStream output, String outputEncoding, IStorage ancestorStorage, IStorage targetStorage, IStorage otherStorage, IProgressMonitor monitor) throws CoreException {
        IStatus status;
        InputStream targetStream;
        InputStream remoteStream;
        BufferedInputStream ancestorStream;
        block41: {
            block40: {
                IStatus iStatus;
                ancestorStream = null;
                remoteStream = null;
                targetStream = null;
                try {
                    ancestorStream = new BufferedInputStream(ancestorStorage.getContents());
                    remoteStream = new BufferedInputStream(otherStorage.getContents());
                    targetStream = new BufferedInputStream(targetStorage.getContents());
                    status = this.merger.merge(output, outputEncoding, (InputStream)ancestorStream, this.getEncoding(ancestorStorage, outputEncoding), targetStream, this.getEncoding(targetStorage, outputEncoding), remoteStream, this.getEncoding(otherStorage, outputEncoding), monitor);
                    if (!status.isOK()) break block40;
                    iStatus = status;
                }
                catch (Throwable throwable) {
                    try {
                        if (ancestorStream != null) {
                            ((InputStream)ancestorStream).close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (remoteStream != null) {
                            remoteStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (targetStream != null) {
                            targetStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (ancestorStream != null) {
                        ((InputStream)ancestorStream).close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (remoteStream != null) {
                        remoteStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (targetStream != null) {
                        targetStream.close();
                    }
                }
                catch (IOException iOException) {}
                return iStatus;
            }
            if (status.getCode() != 1) break block41;
            Status status2 = new Status(status.getSeverity(), status.getPlugin(), 1, status.getMessage(), status.getException());
            try {
                if (ancestorStream != null) {
                    ((InputStream)ancestorStream).close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (remoteStream != null) {
                    remoteStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (targetStream != null) {
                    targetStream.close();
                }
            }
            catch (IOException iOException) {}
            return status2;
        }
        IStatus iStatus = status;
        try {
            if (ancestorStream != null) {
                ((InputStream)ancestorStream).close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (remoteStream != null) {
                remoteStream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (targetStream != null) {
                targetStream.close();
            }
        }
        catch (IOException iOException) {}
        return iStatus;
    }

    private String getEncoding(IStorage ancestorStorage, String outputEncoding) {
        if (ancestorStorage instanceof IEncodedStorage) {
            IEncodedStorage es = (IEncodedStorage)ancestorStorage;
            try {
                String charSet = es.getCharset();
                if (charSet != null) {
                    return charSet;
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return outputEncoding;
    }

    public boolean canMergeWithoutAncestor() {
        return false;
    }
}

