/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.PartSite;

public class ShowPartPaneMenuHandler
extends AbstractEvaluationHandler {
    private Expression enabledWhen;

    public ShowPartPaneMenuHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MPart model;
        Composite partContainer;
        IWorkbenchPartSite site;
        IWorkbenchPart part = HandlerUtil.getActivePart(event);
        if (part != null && (site = part.getSite()) instanceof PartSite && (partContainer = (Composite)(model = ((PartSite)site).getModel()).getWidget()) != null) {
            Composite parent = partContainer.getParent();
            while (parent != null) {
                if (parent instanceof CTabFolder) {
                    CTabFolder ctf = (CTabFolder)parent;
                    CTabItem item = ctf.getSelection();
                    if (item != null) {
                        Display disp = item.getDisplay();
                        Rectangle bounds = item.getBounds();
                        Rectangle info = disp.map((Control)ctf, null, bounds);
                        Event sevent = new Event();
                        sevent.type = 35;
                        sevent.widget = ctf;
                        sevent.x = info.x;
                        sevent.y = info.y + info.height - 1;
                        sevent.doit = true;
                        ctf.notifyListeners(35, sevent);
                    }
                    return null;
                }
                parent = parent.getParent();
            }
        }
        return null;
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    IWorkbenchPart part = InternalHandlerUtil.getActivePart(context);
                    if (part != null) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activePart");
                }
            };
        }
        return this.enabledWhen;
    }
}

