/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.OSCriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.OSCriticalPathPalette;
import org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider.CriticalPathDataProvider;
import org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider.Messages;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class OSCriticalPathDataProvider
extends CriticalPathDataProvider {
    private static final @NonNull String ARROW_SUFFIX = "arrow";
    private static final @NonNull Map<@NonNull String, @NonNull OutputElementStyle> STATE_MAP;
    private static final @NonNull Map<@NonNull String, @NonNull OutputElementStyle> STYLE_MAP;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static {
        STYLE_MAP = Collections.synchronizedMap(new HashMap());
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull @NonNull ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.putAll(OSCriticalPathPalette.getStyles());
        builder.put((Object)(String.valueOf(OSEdgeContextState.OSEdgeContextEnum.DEFAULT.name()) + ARROW_SUFFIX), (Object)new OutputElementStyle(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN.name(), (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.CriticalPathDataProvider_UnknownArrow), (Object)"style-group", (Object)String.valueOf(Messages.CriticalPathDataProvider_GroupArrows))));
        builder.put((Object)(String.valueOf(OSEdgeContextState.OSEdgeContextEnum.NETWORK.name()) + ARROW_SUFFIX), (Object)new OutputElementStyle(OSEdgeContextState.OSEdgeContextEnum.NETWORK.name(), (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(Messages.CriticalPathDataProvider_NetworkArrow), (Object)"style-group", (Object)String.valueOf(Messages.CriticalPathDataProvider_GroupArrows))));
        STATE_MAP = builder.build();
    }

    public OSCriticalPathDataProvider(@NonNull ITmfTrace trace, @NonNull OSCriticalPathModule criticalPathProvider) {
        super(trace, criticalPathProvider);
    }

    @Override
    protected @NonNull OutputElementStyle getMatchingState(ITmfEdgeContextState contextState, boolean arrow) {
        String parentStyleName = contextState.getContextEnum().name();
        parentStyleName = STATE_MAP.containsKey(parentStyleName) ? parentStyleName : OSEdgeContextState.OSEdgeContextEnum.UNKNOWN.name();
        parentStyleName = arrow ? String.valueOf(parentStyleName) + ARROW_SUFFIX : parentStyleName;
        return STYLE_MAP.computeIfAbsent(contextState.getContextEnum().name(), style -> new OutputElementStyle(style));
    }

    @Override
    public @NonNull TmfModelResponse<@NonNull OutputStyleModel> fetchStyle(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }
}

