/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclaratorParser;

public final class TypedefParser
extends AbstractScopedCommonTreeParser {
    public static final TypedefParser INSTANCE = new TypedefParser();

    private TypedefParser() {
    }

    @Override
    public Map<String, IDeclaration> parse(CommonTree typedef, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        CommonTree typeDeclaratorListNode = (CommonTree)typedef.getFirstChildWithType(116);
        if (typeDeclaratorListNode == null) {
            throw new ParseException("Cannot have a typedef without a declarator");
        }
        CommonTree typeSpecifierListNode = (CommonTree)typedef.getFirstChildWithType(117);
        if (typeSpecifierListNode == null) {
            throw new ParseException("Cannot have a typedef without specifiers");
        }
        List typeDeclaratorList = typeDeclaratorListNode.getChildren();
        HashMap<String, IDeclaration> declarations = new HashMap<String, IDeclaration>();
        for (CommonTree typeDeclaratorNode : typeDeclaratorList) {
            StringBuilder identifierSB;
            CTFTrace trace;
            IDeclaration typeDeclaration = TypeDeclaratorParser.INSTANCE.parse(typeDeclaratorNode, new TypeDeclaratorParser.Param(trace = ((Param)param).fTrace, typeSpecifierListNode, scope, identifierSB = new StringBuilder()));
            if (typeDeclaration instanceof VariantDeclaration && !((VariantDeclaration)typeDeclaration).isTagged()) {
                throw new ParseException("Typealias of untagged variant is not permitted");
            }
            scope.registerType(identifierSB.toString(), typeDeclaration);
            declarations.put(identifierSB.toString(), typeDeclaration);
        }
        return declarations;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

