/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEditorInput;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class TmfOpenTraceHelper {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfOpenTraceHelper.class);
    private static final @NonNull String LOCAL_CATEGORY = "TmfOpenTraceHelper";
    private static final String ENDL = System.getProperty("line.separator");
    private static final Set<TmfCommonProjectElement> fOpening = Collections.synchronizedSet(new HashSet());

    private TmfOpenTraceHelper() {
    }

    public static IStatus openTraceFromPath(TmfTraceFolder destinationFolder, String path, Shell shell) throws CoreException {
        return TmfOpenTraceHelper.openTraceFromPath(destinationFolder, path, shell, null);
    }

    public static IStatus openTraceFromPath(TmfTraceFolder destinationFolder, String path, Shell shell, String tracetypeHint) throws CoreException {
        String pathToUse = TmfOpenTraceHelper.checkTracePath(path);
        TraceTypeHelper traceTypeToSet = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TraceCompassLogUtils.ScopeLog scopeLog = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "TmfOpenTraceHelper#openTraceFromPath", new Object[]{"Get trace type"});){
                traceTypeToSet = TmfTraceTypeUIUtils.selectTraceType(pathToUse, null, tracetypeHint);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TmfTraceImportException e) {
            TraceUtils.displayErrorMsg(e);
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", e.getMessage());
        }
        IFolder folder = destinationFolder.getResource();
        String traceName = TmfOpenTraceHelper.getTraceName(pathToUse, folder);
        if (TmfOpenTraceHelper.traceExists(pathToUse, folder)) {
            return TmfOpenTraceHelper.openTraceFromFolder(destinationFolder, traceName);
        }
        IPath pathString = Path.fromOSString((String)pathToUse);
        IResource linkedTrace = TmfImportHelper.createLink(folder, pathString, traceName);
        if (linkedTrace == null || !linkedTrace.exists()) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TmfOpenTraceHelper_LinkFailed);
        }
        String sourceLocation = URIUtil.toUnencodedString((URI)pathString.toFile().toURI());
        linkedTrace.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
        if (traceTypeToSet == null) {
            return new Status(0, "org.eclipse.tracecompass.tmf.ui", 1, Messages.TmfOpenTraceHelper_NoTraceType, null);
        }
        IStatus ret = TmfTraceTypeUIUtils.setTraceType(linkedTrace, traceTypeToSet);
        if (ret.isOK()) {
            ret = TmfOpenTraceHelper.openTraceFromFolder(destinationFolder, traceName);
        }
        return ret;
    }

    private static String checkTracePath(String path) {
        File file = new File(path);
        if (file.exists() && !file.isDirectory()) {
            File parent = file.getParentFile();
            String pathToUse = parent.getAbsolutePath();
            if (TmfTraceType.isDirectoryTrace((String)pathToUse)) {
                return pathToUse;
            }
            File grandParent = parent.getParentFile();
            if (grandParent != null && TmfTraceType.isDirectoryTrace((String)(pathToUse = grandParent.getAbsolutePath()))) {
                return pathToUse;
            }
        }
        return path;
    }

    private static boolean traceExists(String path, IFolder folder) {
        String val = TmfOpenTraceHelper.getTraceName(path, folder);
        return folder.findMember(val) != null;
    }

    private static boolean isWrongMember(IFolder folder, String name, File traceFile) {
        IResource candidate = folder.findMember(name);
        if (candidate != null) {
            IPath rawLocation = candidate.getRawLocation();
            File file = rawLocation.toFile();
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {}
            return !file.equals(traceFile);
        }
        return false;
    }

    private static String getTraceName(String path, IFolder folder) {
        File traceFile = new File(path);
        try {
            traceFile = traceFile.getCanonicalFile();
        }
        catch (IOException iOException) {}
        String name = traceFile.getName();
        int i = 2;
        while (TmfOpenTraceHelper.isWrongMember(folder, name, traceFile)) {
            name = String.valueOf(traceFile.getName()) + '(' + i + ')';
            ++i;
        }
        return name;
    }

    private static IStatus openTraceFromFolder(TmfTraceFolder destinationFolder, String traceName) {
        List<ITmfProjectModelElement> elements = destinationFolder.getChildren();
        TmfTraceElement traceElement = null;
        for (ITmfProjectModelElement element : elements) {
            if (!(element instanceof TmfTraceElement) || !element.getName().equals(traceName)) continue;
            traceElement = (TmfTraceElement)element;
        }
        if (traceElement == null) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", NLS.bind((String)Messages.TmfOpenTraceHelper_TraceNotFound, (Object)traceName));
        }
        IStatus status = TmfOpenTraceHelper.openFromElement(traceElement);
        if (!status.isOK()) {
            Activator.getDefault().logError("Error opening trace from folder: " + status.getMessage());
        }
        return status;
    }

    private static ITmfTrace openTraceElement(TmfTraceElement traceElement) {
        ITmfTrace trace = traceElement.instantiateTrace();
        ITmfEvent traceEvent = traceElement.instantiateEvent();
        if (trace == null || traceEvent == null) {
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), Messages.TmfOpenTraceHelper_NoTraceType);
            if (trace != null) {
                trace.dispose();
            }
            return null;
        }
        try {
            trace.initTrace(traceElement.getResource(), traceElement.getResource().getLocation().toOSString(), traceEvent.getClass(), traceElement.getElementPath(), traceElement.getTraceType());
        }
        catch (TmfTraceException e) {
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), String.valueOf(Messages.TmfOpenTraceHelper_InitError) + ENDL + ENDL + (Object)((Object)e), e.getCause());
            trace.dispose();
            return null;
        }
        return trace;
    }

    private static ITmfTrace openExperimentElement(TmfExperimentElement experimentElement) {
        TmfExperiment experiment = experimentElement.instantiateTrace();
        if (experiment == null) {
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)experimentElement.getTypeName()), NLS.bind((String)Messages.TmfOpenTraceHelper_NoTraceOrExperimentType, (Object)experimentElement.getTypeName()));
            return null;
        }
        List<TmfTraceElement> traceEntries = experimentElement.getTraces();
        int cacheSize = Integer.MAX_VALUE;
        ITmfTrace[] traces = new ITmfTrace[traceEntries.size()];
        int i = 0;
        while (i < traceEntries.size()) {
            TmfTraceElement element = traceEntries.get(i);
            element = element.getElementUnderTraceFolder();
            ITmfTrace trace = null;
            if (element.getParent() instanceof TmfExperimentElement) {
                TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)element.getTypeName()), NLS.bind((String)Messages.TmfOpenTraceHelper_TraceNotFound, (Object)element.getElementPath()));
            } else {
                trace = TmfOpenTraceHelper.openTraceElement(element);
            }
            if (trace == null) {
                int j = 0;
                while (j < i) {
                    traces[j].dispose();
                    ++j;
                }
                experiment.dispose();
                return null;
            }
            cacheSize = Math.min(cacheSize, trace.getCacheSize());
            traces[i] = trace;
            ++i;
        }
        experiment.initExperiment(ITmfEvent.class, experimentElement.getName(), traces, cacheSize, (IResource)experimentElement.getResource(), experimentElement.getTraceType());
        return experiment;
    }

    private static ITmfTrace openProjectElement(TmfCommonProjectElement element) {
        ITmfTrace trace = null;
        if (element instanceof TmfTraceElement) {
            trace = TmfOpenTraceHelper.openTraceElement((TmfTraceElement)element);
        } else if (element instanceof TmfExperimentElement) {
            trace = TmfOpenTraceHelper.openExperimentElement((TmfExperimentElement)element);
        }
        return trace;
    }

    /*
     * Exception decompiling
     */
    public static IStatus openFromElement(TmfCommonProjectElement traceElement) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IEditorPart findEditor(IEditorInput input, boolean restore) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IEditorInput editorInput = editorReference.getEditorInput();
                if (editorInput.equals(input)) {
                    return editorReference.getEditor(restore);
                }
            }
            catch (PartInitException partInitException) {}
            ++n2;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static void reopenTraceFromElement(final TmfCommonProjectElement traceElement, final IReusableEditor editor) {
        block28: {
            Throwable throwable = null;
            Object var3_4 = null;
            try (final TraceCompassLogUtils.FlowScopeLog flow = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "reopenTraceFromElement", new Object[0]).setCategory(LOCAL_CATEGORY).build();){
                AtomicReference bookmarksFile = new AtomicReference();
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (TraceCompassLogUtils.FlowScopeLog scopeLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "createBookmarks", new Object[0]).setParentScope(flow).build();){
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                            try {
                                traceElement.refreshSupplementaryFolder(monitor);
                                bookmarksFile.set(traceElement.createBookmarksFile(monitor));
                            }
                            catch (OperationCanceledException operationCanceledException) {
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        });
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (flow != null) {
                        flow.close();
                    }
                    return;
                }
                catch (InvocationTargetException e) {
                    block27: {
                        Activator.getDefault().logError(String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)traceElement.getTypeName())) + ' ' + traceElement.getName());
                        TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorElement, (Object)traceElement.getTypeName())) + ENDL + ENDL + e.getTargetException().getMessage(), e.getTargetException());
                        if (flow == null) break block27;
                        flow.close();
                    }
                    return;
                }
                final IFile file = (IFile)bookmarksFile.get();
                if (file == null) {
                    return;
                }
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (TraceCompassLogUtils.FlowScopeLog scopeLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "createThread", new Object[0]).setParentScope(flow).build();){
                            ITmfTrace trace = TmfOpenTraceHelper.openProjectElement(traceElement);
                            if (trace == null) {
                                return;
                            }
                            TmfEditorInput editorInput = new TmfEditorInput(file, trace);
                            Display.getDefault().asyncExec(() -> {
                                Throwable throwable = null;
                                Object var4_5 = null;
                                try (TraceCompassLogUtils.FlowScopeLog innerScopeLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "OpenEditor", new Object[0]).setParentScope(flow).build();){
                                    IWorkbench wb = PlatformUI.getWorkbench();
                                    IWorkbenchWindow activeWorkbenchWindow = wb.getActiveWorkbenchWindow();
                                    if (activeWorkbenchWindow == null) {
                                        return;
                                    }
                                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                                    activePage.reuseEditor(editor, editorInput);
                                    activePage.activate((IWorkbenchPart)editor);
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            });
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                };
                thread.start();
                break block28;
                {
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
    }

    private static /* synthetic */ void lambda$0(TmfCommonProjectElement tmfCommonProjectElement, AtomicReference atomicReference, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            tmfCommonProjectElement.refreshSupplementaryFolder(monitor);
            atomicReference.set(tmfCommonProjectElement.createBookmarksFile(monitor));
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static class OpenProjectElementJob
    extends Job {
        private final TmfCommonProjectElement fTraceElement;
        private final IFile fFile;
        private ITmfTrace fTrace = null;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable TraceCompassLogUtils.FlowScopeLog fParentScope;

        public OpenProjectElementJob(TmfCommonProjectElement traceElement, IFile file) {
            super("Opening " + traceElement.getName());
            this.setSystem(true);
            this.fTraceElement = traceElement;
            this.fFile = file;
        }

        public IStatus run(IProgressMonitor monitor) {
            TraceCompassLogUtils.FlowScopeLog parentScope = this.fParentScope;
            TraceCompassLogUtils.FlowScopeLogBuilder flowScopeLogBuilder = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "OpenProjectElementJob", new Object[0]);
            Throwable throwable = null;
            Object var5_6 = null;
            try (TraceCompassLogUtils.FlowScopeLog log = parentScope == null ? flowScopeLogBuilder.setCategory(TmfOpenTraceHelper.LOCAL_CATEGORY).build() : flowScopeLogBuilder.setParentScope(parentScope).build();){
                this.fTrace = TmfOpenTraceHelper.openProjectElement(this.fTraceElement);
                if (this.fTrace == null) {
                    return Status.OK_STATUS;
                }
                String traceEditorId = this.fTraceElement.getEditorId();
                String editorId = traceEditorId != null ? traceEditorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                TmfEditorInput editorInput = new TmfEditorInput(this.fFile, this.fTrace);
                Display.getDefault().syncExec(() -> {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (TraceCompassLogUtils.FlowScopeLog displayLog = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "OpenEditor", new Object[0]).setParentScope(log).build();){
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            return;
                        }
                        IWorkbenchPage activePage = window.getActivePage();
                        if (activePage == null) {
                            return;
                        }
                        try {
                            activePage.openEditor(editorInput, editorId);
                            IDE.setDefaultEditor((IFile)this.fFile, (String)editorId);
                        }
                        catch (PartInitException e) {
                            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)this.fTraceElement.getTypeName()), String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)this.fTraceElement.getTypeName())) + ENDL + ENDL + e.getMessage(), e);
                            Activator.getDefault().logError(String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)this.fTraceElement.getTypeName())) + ' ' + this.fTraceElement.getName());
                            this.fTrace.dispose();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                });
                return Status.OK_STATUS;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public ITmfTrace getTrace() {
            return this.fTrace;
        }
    }
}

